/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.user;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.user.MdmCustomerUserImportVo;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleCustomerMapper;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.mdm.user.entity.MdmUserEntity;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmCustomerUserImportValidator")
public class MdmCustomerUserImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmCustomerMsgMapper, MdmCustomerEntity, MdmCustomerUserImportVo>
implements ExcelImportValidator<MdmCustomerUserImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerUserImportValidator.class);
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmRoleCustomerMapper mdmRoleCustomerMapper;
    private final String PHONE_REGEX = "[1][\\d]{10}";

    @Override
    public void validate(List<MdmCustomerUserImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.verify(data);
    }

    protected void verify(List<MdmCustomerUserImportVo> originList) {
        Map<Object, Object> userNameCheckMap = new HashMap(16);
        Set paramUserNameSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getUserName())).map(MdmCustomerUserImportVo::getUserName).collect(Collectors.toSet());
        if (!paramUserNameSet.isEmpty()) {
            QueryWrapper userNameQuery = new QueryWrapper();
            userNameQuery.in((Object)"user_name", paramUserNameSet);
            List userNameQueryEntityList = this.mdmUserMapper.selectList((Wrapper)userNameQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)userNameQueryEntityList)) {
                userNameCheckMap = userNameQueryEntityList.stream().collect(Collectors.toMap(MdmUserEntity::getUserName, MdmUserEntity::getUserType));
            }
        }
        Map genderDictMap = DictUtil.dictMap((String)"gender");
        HashMap genderValueCodeMap = new HashMap(16);
        for (Map.Entry entry : genderDictMap.entrySet()) {
            if (genderValueCodeMap.containsKey(entry.getValue())) continue;
            genderValueCodeMap.put(entry.getValue(), entry.getKey());
        }
        HashMap<String, MdmCustomerEntity> customerMap = new HashMap<String, MdmCustomerEntity>(16);
        HashMap<String, String> userMap = new HashMap<String, String>(16);
        Set paramCustomerCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getCustomerCode())).map(MdmCustomerUserImportVo::getCustomerCode).collect(Collectors.toSet());
        if (!paramCustomerCodeSet.isEmpty()) {
            QueryWrapper primaryPositionQuery = new QueryWrapper();
            primaryPositionQuery.in((Object)"customer_code", paramCustomerCodeSet);
            List customerEntityList = this.mdmCustomerMsgMapper.selectList((Wrapper)primaryPositionQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntityList)) {
                customerMap.putAll(customerEntityList.stream().collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, v -> v)));
                Set userNameSet = customerEntityList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getUserName())).map(MdmCustomerEntity::getUserName).collect(Collectors.toSet());
                if (!userNameSet.isEmpty()) {
                    QueryWrapper userQuery = new QueryWrapper();
                    userQuery.in((Object)"user_name", userNameSet);
                    userQuery.in((Object)"user_type", new Object[]{UserTypeEnum.CUSTOMER.getCode()});
                    userMap.putAll(this.mdmUserMapper.selectList((Wrapper)userQuery).stream().collect(Collectors.toMap(MdmUserEntity::getUserName, MdmUserEntity::getFullName)));
                }
            }
        }
        HashMap<String, String> roleCodeNameMap = new HashMap<String, String>(16);
        Set paramRoleCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getRoleCode())).map(MdmCustomerUserImportVo::getRoleCode).collect(Collectors.toSet());
        if (!paramRoleCodeSet.isEmpty()) {
            QueryWrapper roleQuery = new QueryWrapper();
            roleQuery.in((Object)"role_code", paramRoleCodeSet);
            List roleCodeQueryEntityList = this.mdmRoleMapper.selectList((Wrapper)roleQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)roleCodeQueryEntityList)) {
                roleCodeNameMap.putAll(roleCodeQueryEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName)));
            }
        }
        HashMap<String, Integer> userNameIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> customerCodeIndexMap = new HashMap<String, Integer>(16);
        for (MdmCustomerUserImportVo item2 : originList) {
            if (StringUtils.isEmpty((String)item2.getUserName())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u8d26\u53f7\uff1b");
            } else {
                if (userNameIndexMap.containsKey(item2.getUserName())) {
                    item2.appendErrorValidateMsg("\u8d26\u53f7\u4e0e\u7b2c" + userNameIndexMap.get(item2.getUserName()) + "\u884c\u91cd\u590d\uff1b");
                } else {
                    userNameIndexMap.put(item2.getUserName(), item2.getRowIndex());
                }
                if (userNameCheckMap.containsKey(item2.getUserName())) {
                    item2.appendErrorValidateMsg("\u8d26\u53f7\u5df2\u5b58\u5728\uff1b");
                }
            }
            if (StringUtils.isEmpty((String)item2.getFullName())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u7528\u6237\u540d\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item2.getGenderName())) {
                if (!genderValueCodeMap.containsKey(item2.getGenderName())) {
                    item2.appendErrorValidateMsg("\u6027\u522b\u65e0\u6548\uff1b");
                } else {
                    item2.setGender((String)genderValueCodeMap.get(item2.getGenderName()));
                }
            }
            if (StringUtils.isEmpty((String)item2.getUserPassword())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u5bc6\u7801\uff1b");
            }
            if (StringUtils.isEmpty((String)item2.getUserPhone())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u8054\u7cfb\u7535\u8bdd\uff1b");
            } else if (!item2.getUserPhone().matches("[1][\\d]{10}")) {
                item2.appendErrorValidateMsg("\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item2.getEmail()) && item2.getEmail().length() - item2.getEmail().replace("@", "").length() != 1) {
                item2.appendErrorValidateMsg("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
            }
            if (StringUtils.isEmpty((String)item2.getStartTime())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u751f\u6548\u65f6\u95f4\uff1b");
            } else if (!this.verifyDateFormat(item2.getStartTime(), "yyyy-MM-dd")) {
                item2.appendErrorValidateMsg("\u751f\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5\uff1b");
            } else {
                item2.setStartTime(item2.getStartTime() + " 00:00:00");
            }
            if (StringUtils.isEmpty((String)item2.getEndTime())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u5931\u6548\u65f6\u95f4\uff1b");
            } else if (!this.verifyDateFormat(item2.getEndTime(), "yyyy-MM-dd")) {
                item2.appendErrorValidateMsg("\u5931\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5\uff1b");
            } else {
                item2.setEndTime(item2.getEndTime() + " 23:59:59");
            }
            if (StringUtils.isEmpty((String)item2.getCustomerCode())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u5173\u8054\u5ba2\u6237\u7f16\u7801\uff1b");
            } else {
                if (!customerMap.containsKey(item2.getCustomerCode())) {
                    item2.appendErrorValidateMsg("\u5ba2\u6237\u7f16\u7801[" + item2.getCustomerCode() + "]\u65e0\u6548\uff1b");
                } else {
                    MdmCustomerEntity customer = (MdmCustomerEntity)((Object)customerMap.get(item2.getCustomerCode()));
                    if (StringUtils.isNotEmpty((String)customer.getUserName()) && userMap.containsKey(customer.getUserName())) {
                        item2.appendErrorValidateMsg("\u5ba2\u6237[" + item2.getCustomerCode() + "]\u5df2\u7ecf\u5df2\u7ecf\u5173\u8054\u4e86\u7528\u6237\uff1b");
                    }
                }
                if (customerCodeIndexMap.containsKey(item2.getCustomerCode())) {
                    item2.appendErrorValidateMsg("\u5ba2\u6237\u7f16\u7801[" + item2.getCustomerCode() + "]\u5728\u7b2c" + customerCodeIndexMap.get(item2.getCustomerCode()) + "\u884c\u5df2\u5b58\u5728\uff1b");
                } else {
                    customerCodeIndexMap.put(item2.getCustomerCode(), item2.getRowIndex());
                }
            }
            if (StringUtils.isNotEmpty((String)item2.getRoleCode()) && !roleCodeNameMap.containsKey(item2.getRoleCode())) {
                item2.appendErrorValidateMsg("\u6743\u9650\u89d2\u8272\u7f16\u7801\u65e0\u6548\uff1b");
            }
            if (AbstractImportVo.ProcessTypeEnum.SUCCESS != item2.getProcessType()) continue;
            ArrayList<String> codeList = new ArrayList<String>();
            ArrayList<String> nameList = new ArrayList<String>();
            for (String customerCode : item2.getCustomerCode().split(",")) {
                codeList.add(customerCode);
                nameList.add(((MdmCustomerEntity)((Object)customerMap.get(customerCode))).getCustomerName());
            }
            item2.setCustomerCodeRedundancy(String.join((CharSequence)",", codeList));
            item2.setCustomerNameRedundancy(String.join((CharSequence)",", nameList));
        }
    }

    private boolean verifyDateFormat(String dataStr, String formatStr) {
        boolean flag = false;
        if (StringUtils.isNotEmpty((String)dataStr) && StringUtils.isNotEmpty((String)formatStr)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                Date parse = sdf.parse(dataStr);
                String dateFormatStr = sdf.format(parse);
                if (dataStr.equals(dateFormatStr)) {
                    flag = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }
}

