/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.consumer;

import com.biz.crm.excel.util.MqMessageParam;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.websocket.user.endpoint.UserWebSocketHandler;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="EXCEL_IMPORT_WEBSOCKET_MSG", consumerGroup="EXCEL_IMPORT_WEBSOCKET_MSG${rocketmq.environment-variable}", consumeMode=ConsumeMode.ORDERLY)
public class ExcelImportWebsocketMsgConsumer
implements RocketMQListener<RocketMQMessageBody> {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportWebsocketMsgConsumer.class);
    private static UserWebSocketHandler userWebSocketHandler = new UserWebSocketHandler();

    public void onMessage(RocketMQMessageBody message) {
        MqMessageParam mqMessageParam;
        if (log.isInfoEnabled()) {
            log.info("\u53d1\u9001excel\u5bfc\u5165\u6d88\u606f>>>" + message.getMsgBody());
        }
        if (null == (mqMessageParam = (MqMessageParam)JsonPropertyUtil.toObject((String)message.getMsgBody(), MqMessageParam.class))) {
            if (log.isWarnEnabled()) {
                log.warn("\u53d1\u9001excel\u5bfc\u5165\u6d88\u606f\u5931\u8d25 mqMessageParam = null >>> " + message.getMsgBody());
            }
            return;
        }
        Boolean flag = userWebSocketHandler.getWebSocketSession(mqMessageParam.getClientId());
        if (flag.booleanValue()) {
            TextMessage textMessage = new TextMessage((CharSequence)mqMessageParam.getMsg());
            userWebSocketHandler.sendMessageToUser(mqMessageParam.getClientId(), textMessage);
        }
        if (log.isInfoEnabled()) {
            log.info("\u53d1\u9001excel\u5bfc\u5165\u6d88\u606f>>> flag = " + flag);
        }
    }
}

