/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.controller;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.upload.UploadEnum;
import com.biz.crm.excel.controller.req.ExcelImportParamVo;
import com.biz.crm.excel.controller.resp.DemoFileResp;
import com.biz.crm.excel.controller.resp.UnAsyncImportRespVo;
import com.biz.crm.excel.service.ExcelImport;
import com.biz.crm.excel.util.MqMessageParam;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.upload.excel.req.ExcelExportReqVo;
import com.biz.crm.upload.excel.ExcelExportFeign;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"excelImportController"})
@Api(tags={"\u5bfc\u5165excel "})
public class ExcelImportController {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportController.class);
    @Resource(name="defaultExcelImport")
    private ExcelImport defaultExcelImport;
    @Resource
    private ExcelExportFeign excelExportFeign;
    @Resource
    private RocketMQProducer rocketMQProducer;

    @ApiOperation(value="\u5bfc\u5165excel")
    @PostMapping(value={"import"})
    @CrmLog
    public Result doImport(@ApiParam(value="\u5bfc\u5165\u914d\u7f6e\u7f16\u7801") @RequestParam(value="configCode") String configCode, @ApiParam(value="\u662f\u5426\u6d4b\u8bd5\u6a21\u5f0f") @RequestParam(name="test", defaultValue="false") Boolean test, @ApiParam(value="webSocket\u8fde\u63a5id") @RequestParam(value="webSocketClientId") String webSocketClientId, @RequestPart(value="file") MultipartFile file) {
        this.check(webSocketClientId, configCode, file);
        ExcelImportParamVo importParamVo = this.defaultExcelImport.resolveConfig(configCode);
        if (StringUtils.isBlank((CharSequence)importParamVo.getBeanNameAsSaver())) {
            throw new BusinessException("\u5fc5\u987b\u914d\u7f6e\u4fdd\u5b58\u903b\u8f91[beanNameAsSaver]\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5b57\u5178\u68c0\u67e5Excel\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        importParamVo.setWebSocketClientId(webSocketClientId);
        this.createImportTask(importParamVo, file);
        importParamVo.setTest(test);
        this.defaultExcelImport.doAsyncImport(importParamVo, UserUtils.getToken(), this.createTempFile(file));
        return Result.ok();
    }

    private void sendMQ(String msgBody, ExcelImportParamVo importParamVo) {
        String webSocketClientId = importParamVo.getWebSocketClientId();
        if (StringUtils.isBlank((CharSequence)webSocketClientId)) {
            if (log.isInfoEnabled()) {
                log.info("\u5bfc\u5165\u4efb\u52a1[" + importParamVo.getTaskCode() + "]:\u672a\u63d0\u4ea4 websocket id\uff0c\u5ffd\u7565 websocket \u6d88\u606f\u53d1\u9001\uff01");
            }
            return;
        }
        MqMessageParam mqMessageParam = new MqMessageParam();
        mqMessageParam.setClientId(webSocketClientId);
        mqMessageParam.setMsg(msgBody);
        RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
        mqMessageBody.setTag("EXCEL_IMPORT_WEBSOCKET_MSG");
        mqMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)mqMessageParam));
        this.rocketMQProducer.convertAndSend(mqMessageBody);
    }

    @ApiOperation(value="\u540c\u6b65\u5bfc\u5165excel(\u4e0d\u4f1a\u4fdd\u5b58\u5230\u6570\u636e\u5e93)")
    @PostMapping(value={"unAsyncImportUnSave"})
    @CrmLog
    public Result<UnAsyncImportRespVo> unAsyncImportUnSave(@ApiParam(value="\u5bfc\u5165\u914d\u7f6e\u7f16\u7801") @RequestParam(value="configCode") String configCode, @ApiParam(value="\u81ea\u5b9a\u4e49\u53c2\u6570") @RequestParam(value="bizParams") String bizParams, @RequestPart(value="file") MultipartFile file) {
        AssertUtils.isNotNull((Object)file, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6587\u4ef6");
        AssertUtils.isNotEmpty((String)configCode, (String)"\u5bfc\u5165\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ExcelImportParamVo importParamVo = this.defaultExcelImport.resolveConfig(configCode);
        importParamVo.setBizParams(bizParams);
        this.createImportTask(importParamVo, file);
        return Result.ok((Object)this.defaultExcelImport.doUnAsyncImport(importParamVo, this.createTempFile(file)));
    }

    private void createImportTask(ExcelImportParamVo importParamVo, MultipartFile file) {
        ExcelExportReqVo excelExportReqVo = this.buildExcelExportReqVo(importParamVo, file.getOriginalFilename());
        Result result = this.excelExportFeign.saveExcelFileBackId(excelExportReqVo);
        if (!ApiResultUtil.checkResult((Result)result) || null == result.getResult()) {
            throw new BusinessException("\u521b\u5efa\u5bfc\u5165\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        excelExportReqVo = (ExcelExportReqVo)result.getResult();
        importParamVo.setTaskId(excelExportReqVo.getId());
        importParamVo.setTaskCode(excelExportReqVo.getFileCode());
        String msg = "\u521b\u5efa\u5bfc\u5165\u4efb\u52a1[" + importParamVo.getTaskCode() + "]\u6210\u529f\uff01";
        log.warn(msg);
        this.sendMQ(msg, importParamVo);
    }

    private ExcelExportReqVo buildExcelExportReqVo(ExcelImportParamVo importParamVo, String baseFileName) {
        ExcelExportReqVo vo = new ExcelExportReqVo();
        vo.setFileName(baseFileName);
        vo.setExcelFileName(baseFileName);
        vo.setFileSource(importParamVo.getFileNameAsDemo());
        vo.setFileParam(importParamVo.getImportConfigCode());
        vo.setFileType(UploadEnum.fileType.IMPORT.getVal());
        vo.setFileStatus(UploadEnum.fileStatus.IMPORT_IN_EXECUTION.getVal());
        vo.setWebSocketId(importParamVo.getWebSocketClientId());
        return vo;
    }

    private void check(String webSocketClientId, String importConfigCode, MultipartFile file) {
        AssertUtils.isNotNull((Object)file, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6587\u4ef6");
        AssertUtils.isNotEmpty((String)webSocketClientId, (String)"Websocket\u8fde\u63a5\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)importConfigCode, (String)"\u5bfc\u5165\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private File createTempFile(MultipartFile file) {
        if (null == file) {
            throw new BusinessException("\u8bf7\u4e0a\u4f20\u5bfc\u5165\u6587\u4ef6\uff01");
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            File fileTemp = File.createTempFile(file.getName() + UUIDGenerator.generate(), ExcelTypeEnum.XLSX.getValue());
            bis = new BufferedInputStream(file.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(fileTemp));
            int len = 0;
            byte[] buf = new byte[20480];
            while ((len = bis.read(buf)) != -1) {
                ((BufferedOutputStream)bos).write(buf, 0, len);
            }
            ((BufferedOutputStream)bos).flush();
            File file2 = fileTemp;
            return file2;
        }
        catch (IOException e) {
            log.warn("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            throw new BusinessException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                log.warn("\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff01", (Throwable)e);
                throw new BusinessException("\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            }
        }
    }

    @ApiOperation(value="\u5bfc\u5165excel,\u4e0b\u8f7d\u793a\u4f8b\u6587\u4ef6")
    @GetMapping(value={"demoFile"})
    @CrmLog
    public ResponseEntity<InputStreamResource> demoFile(@ApiParam(value="\u5bfc\u5165\u5bf9\u8c61\u7684\u7c7b\u8def\u5f84") @RequestParam String configCode) {
        DemoFileResp demoFileResp = this.defaultExcelImport.demoFile(configCode);
        String fileName = demoFileResp.getFileNameAsDemo() + ExcelTypeEnum.XLSX.getValue();
        if (!StringUtils.isEmpty((CharSequence)fileName)) {
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentDispositionFormData("attachment", fileName);
        httpHeaders.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        try {
            return new ResponseEntity((Object)new InputStreamResource((InputStream)new FileInputStream(demoFileResp.getFile())), (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (FileNotFoundException e) {
            throw new BusinessException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
    }

    @ApiOperation(value="\u5bfc\u5165excel,\u4e0b\u8f7d\u793a\u4f8b\u6587\u4ef6,\u53ef\u4f20token")
    @GetMapping(value={"demoFileTest"})
    @CrmLog
    public ResponseEntity<InputStreamResource> demoFileTest(@ApiParam(value="\u5bfc\u5165\u5bf9\u8c61\u7684\u7c7b\u8def\u5f84") @RequestParam String configCode, @ApiParam(value="token") @RequestParam String token) {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            UserUtils.setToken((String)token);
        }
        return this.demoFile(configCode);
    }
}

