/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.org;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.org.MdmOrgImportVo;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmOrgImportValidator")
public class MdmOrgImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmOrgMapper, MdmOrgEntity, MdmOrgImportVo>
implements ExcelImportValidator<MdmOrgImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgImportValidator.class);
    @Autowired
    private MdmOrgMapper mdmOrgMapper;

    @Override
    public void validate(List<MdmOrgImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validateRequired(data);
    }

    protected void validateRequired(List<MdmOrgImportVo> originList) {
        Map orgTypeMap = DictUtil.dictMap((String)"mdm_org_type");
        HashMap orgTypeValueCodeMap = new HashMap(16);
        for (Map.Entry entry : orgTypeMap.entrySet()) {
            if (orgTypeValueCodeMap.containsKey(entry.getValue())) continue;
            orgTypeValueCodeMap.put(entry.getValue(), entry.getKey());
        }
        HashMap<String, Integer> originOrgCodeMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> originOrgNameMap = new HashMap<String, Integer>(16);
        HashSet orgCodeUniqueSet = new HashSet(16);
        Set originOrgCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmOrgImportVo::getOrgCode).collect(Collectors.toSet());
        if (!originOrgCodeSet.isEmpty()) {
            QueryWrapper orgCodeUniqueQuery = new QueryWrapper();
            orgCodeUniqueQuery.in((Object)"org_code", originOrgCodeSet);
            List orgCodeUniqueList = this.mdmOrgMapper.selectList((Wrapper)orgCodeUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orgCodeUniqueList)) {
                orgCodeUniqueSet.addAll(orgCodeUniqueList.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toSet()));
            }
        }
        HashSet orgNameUniqueSet = new HashSet(16);
        Set originOrgNameSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgName())).map(MdmOrgImportVo::getOrgName).collect(Collectors.toSet());
        if (!originOrgNameSet.isEmpty()) {
            QueryWrapper orgNameUniqueQuery = new QueryWrapper();
            orgNameUniqueQuery.in((Object)"org_name", originOrgNameSet);
            List orgNameUniqueList = this.mdmOrgMapper.selectList((Wrapper)orgNameUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orgNameUniqueList)) {
                orgNameUniqueSet.addAll(orgNameUniqueList.stream().map(MdmOrgEntity::getOrgName).collect(Collectors.toSet()));
            }
        }
        HashSet parentCodeCheckSet = new HashSet(16);
        Set originParentCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentCode())).map(MdmOrgImportVo::getParentCode).collect(Collectors.toSet());
        if (!originParentCodeSet.isEmpty()) {
            QueryWrapper parentQuery = new QueryWrapper();
            parentQuery.in((Object)"org_code", originParentCodeSet);
            List parentCodeCheckList = this.mdmOrgMapper.selectList((Wrapper)parentQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)parentCodeCheckList)) {
                parentCodeCheckSet.addAll(parentCodeCheckList.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toSet()));
            }
        }
        for (MdmOrgImportVo item2 : originList) {
            if (StringUtils.isNotEmpty((String)item2.getOrgCode())) {
                if (originOrgCodeMap.containsKey(item2.getOrgCode())) {
                    item2.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801\u4e0e\u7b2c" + originOrgCodeMap.get(item2.getOrgCode()) + "\u884c\u91cd\u590d\uff1b");
                } else {
                    originOrgCodeMap.put(item2.getOrgCode(), item2.getRowIndex());
                }
                if (orgCodeUniqueSet.contains(item2.getOrgCode())) {
                    item2.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff1b");
                }
            }
            if (StringUtils.isEmpty((String)item2.getOrgName())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u7ec4\u7ec7\u540d\u79f0");
            } else {
                if (originOrgNameMap.containsKey(item2.getOrgName())) {
                    item2.appendErrorValidateMsg("\u7ec4\u7ec7\u540d\u79f0\u4e0e\u7b2c" + originOrgNameMap.get(item2.getOrgName()) + "\u884c\u91cd\u590d\uff1b");
                } else {
                    originOrgNameMap.put(item2.getOrgName(), item2.getRowIndex());
                }
                if (orgNameUniqueSet.contains(item2.getOrgName())) {
                    item2.appendErrorValidateMsg("\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728\uff1b");
                }
            }
            if (StringUtils.isEmpty((String)item2.getOrgTypeName())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u7ec4\u7ec7\u5c42\u7ea7\uff1b");
                continue;
            }
            if (!orgTypeValueCodeMap.containsKey(item2.getOrgTypeName())) {
                item2.appendErrorValidateMsg("\u7ec4\u7ec7\u5c42\u7ea7\u65e0\u6548\uff1b");
                continue;
            }
            item2.setOrgType((String)orgTypeValueCodeMap.get(item2.getOrgTypeName()));
        }
        for (MdmOrgImportVo item2 : originList) {
            if (StringUtils.isEmpty((String)item2.getParentCode()) || parentCodeCheckSet.contains(item2.getParentCode()) || originOrgCodeSet.contains(item2.getParentCode())) continue;
            item2.appendErrorValidateMsg("\u4e0a\u7ea7\u7ec4\u7ec7\u7f16\u7801\u65e0\u6548\uff1b");
        }
        Set<String> errorCode = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode()) && AbstractImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()).map(MdmOrgImportVo::getOrgCode).collect(Collectors.toSet());
        if (!errorCode.isEmpty()) {
            this.setErrorParent(originList, errorCode);
        }
    }

    private void setErrorParent(List<MdmOrgImportVo> originList, Set<String> errorCode) {
        if (errorCode.isEmpty()) {
            return;
        }
        Set<String> codeOnTheTree = this.getCodeOnTheTree(originList);
        originList.forEach(item -> {
            if (StringUtils.isNotEmpty((String)item.getParentCode()) && errorCode.contains(item.getParentCode())) {
                item.appendErrorValidateMsg("\u4e0a\u7ea7\u6821\u9a8c\u672a\u901a\u8fc7\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item.getOrgCode()) && !codeOnTheTree.contains(item.getOrgCode())) {
                item.appendErrorValidateMsg("\u53ef\u80fd\u5904\u5728\u73af\u5f62\u7ed3\u6784\u4e0a\u6216\u8005\u4e0a\u7ea7\u5904\u4e8e\u73af\u5f62\u7ed3\u6784\u4e0a\uff1b");
            }
        });
    }

    private Set<String> getCodeOnTheTree(List<MdmOrgImportVo> originList) {
        HashSet<String> orgCodeOnTheTree = new HashSet<String>(16);
        List totalList = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(totalList)) {
            Set totalSet = totalList.stream().map(MdmOrgImportVo::getOrgCode).collect(Collectors.toSet());
            Set topCodeSet = totalList.stream().filter(item -> StringUtils.isEmpty((String)item.getParentCode()) || !totalSet.contains(item.getParentCode())).map(MdmOrgImportVo::getOrgCode).collect(Collectors.toSet());
            if (!topCodeSet.isEmpty()) {
                HashSet curLevelSet = new HashSet(16);
                curLevelSet.addAll(topCodeSet);
                orgCodeOnTheTree.addAll(curLevelSet);
                while (!curLevelSet.isEmpty()) {
                    Set collect = totalList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentCode()) && curLevelSet.contains(item.getParentCode()) && !item.getParentCode().equals(item.getOrgCode())).map(MdmOrgImportVo::getOrgCode).collect(Collectors.toSet());
                    curLevelSet.clear();
                    if (collect.isEmpty()) continue;
                    orgCodeOnTheTree.addAll(collect);
                    curLevelSet.addAll(collect);
                }
            }
        }
        return orgCodeOnTheTree;
    }
}

