/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.position;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.position.MdmPositionImportVo;
import com.biz.crm.mdm.bpmrple.entity.MdmBpmRoleEntity;
import com.biz.crm.mdm.bpmrple.mapper.MdmBpmRoleMapper;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelRoleEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelRoleMapper;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmPositionImportValidator")
public class MdmPositionImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmPositionMapper, MdmPositionEntity, MdmPositionImportVo>
implements ExcelImportValidator<MdmPositionImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionImportValidator.class);
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmBpmRoleMapper mdmBpmRoleMapper;
    @Resource
    private MdmPositionLevelRoleMapper mdmPositionLevelRoleMapper;

    @Override
    public void validate(List<MdmPositionImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validateRequired(data);
    }

    protected void validateRequired(List<MdmPositionImportVo> originList) {
        HashSet positionLevelCodeSet = new HashSet(16);
        Map<Object, Object> positionLevelRoleSetMap = new HashMap(16);
        Map<Object, Object> relRoleCodeNameMap = new HashMap(16);
        Set paramPositionLevelCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionLevelCode())).map(MdmPositionImportVo::getPositionLevelCode).collect(Collectors.toSet());
        if (!paramPositionLevelCodeSet.isEmpty()) {
            QueryWrapper positionLevelQuery = new QueryWrapper();
            positionLevelQuery.in((Object)"position_level_code", paramPositionLevelCodeSet);
            List positionLevelEntityList = this.mdmPositionLevelMapper.selectList((Wrapper)positionLevelQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionLevelEntityList)) {
                positionLevelCodeSet.addAll(positionLevelEntityList.stream().map(MdmPositionLevelEntity::getPositionLevelCode).collect(Collectors.toSet()));
            }
            QueryWrapper positionLevelRoleQuery = new QueryWrapper();
            positionLevelRoleQuery.in((Object)"position_level_code", paramPositionLevelCodeSet);
            List positionLevelRoleEntityList = this.mdmPositionLevelRoleMapper.selectList((Wrapper)positionLevelRoleQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionLevelRoleEntityList)) {
                positionLevelRoleSetMap = positionLevelRoleEntityList.stream().collect(Collectors.groupingBy(MdmPositionLevelRoleEntity::getPositionLevelCode, Collectors.mapping(MdmPositionLevelRoleEntity::getRoleCode, Collectors.toSet())));
                QueryWrapper relRoleQuery = new QueryWrapper();
                relRoleQuery.in((Object)"role_code", (Collection)positionLevelRoleEntityList.stream().map(MdmPositionLevelRoleEntity::getRoleCode).collect(Collectors.toSet()));
                List relRoleEntityList = this.mdmRoleMapper.selectList((Wrapper)relRoleQuery);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)relRoleEntityList)) {
                    relRoleCodeNameMap = relRoleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName));
                }
            }
        }
        HashSet orgCodeSet = new HashSet(16);
        Set paramOrgCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmPositionImportVo::getOrgCode).collect(Collectors.toSet());
        if (!paramOrgCodeSet.isEmpty()) {
            QueryWrapper orgQuery = new QueryWrapper();
            orgQuery.in((Object)"org_code", paramOrgCodeSet);
            List orgEntityList = this.mdmOrgMapper.selectList((Wrapper)orgQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orgEntityList)) {
                orgCodeSet.addAll(orgEntityList.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toSet()));
            }
        }
        HashSet parentCodeSet = new HashSet(16);
        Set paramParentCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentCode())).map(MdmPositionImportVo::getParentCode).collect(Collectors.toSet());
        if (!paramParentCodeSet.isEmpty()) {
            QueryWrapper positionQuery = new QueryWrapper();
            positionQuery.in((Object)"position_code", paramParentCodeSet);
            positionQuery.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
            List positionEntityList = this.mdmPositionMapper.selectList((Wrapper)positionQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionEntityList)) {
                parentCodeSet.addAll(positionEntityList.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toSet()));
            }
        }
        Map<Object, Object> roleMap = new HashMap(16);
        Map<Object, Object> bpmRoleMap = new HashMap(16);
        HashSet<String> roleCodeSet = new HashSet<String>(16);
        HashSet<String> bpmRoleCodeSet = new HashSet<String>(16);
        for (MdmPositionImportVo mdmPositionImportVo : originList) {
            if (StringUtils.isNotEmpty((String)mdmPositionImportVo.getRoleCode())) {
                roleCodeSet.addAll(Arrays.asList(mdmPositionImportVo.getRoleCode().split(",")));
            }
            if (!StringUtils.isNotEmpty((String)mdmPositionImportVo.getBpmRoleCode())) continue;
            bpmRoleCodeSet.addAll(Arrays.asList(mdmPositionImportVo.getBpmRoleCode().split(",")));
        }
        if (!roleCodeSet.isEmpty()) {
            QueryWrapper roleQuery = new QueryWrapper();
            roleQuery.in((Object)"role_code", roleCodeSet);
            List roleEntityList = this.mdmRoleMapper.selectList((Wrapper)roleQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)roleEntityList)) {
                roleMap = roleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName));
            }
        }
        if (!bpmRoleCodeSet.isEmpty()) {
            QueryWrapper bpmRoleQuery = new QueryWrapper();
            bpmRoleQuery.in((Object)"bpm_role_code", bpmRoleCodeSet);
            List bpmRoleEntityList = this.mdmBpmRoleMapper.selectList((Wrapper)bpmRoleQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)bpmRoleEntityList)) {
                bpmRoleMap = bpmRoleEntityList.stream().collect(Collectors.toMap(MdmBpmRoleEntity::getBpmRoleCode, MdmBpmRoleEntity::getBpmRoleName));
            }
        }
        ConcurrentHashMap<String, Map<String, String>> positionParentOrgMap = new ConcurrentHashMap<String, Map<String, String>>(16);
        Set collect = originList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getParentCode()) && StringUtils.isNotEmpty((String)x.getOrgCode())).map(MdmPositionImportVo::getParentCode).collect(Collectors.toSet());
        if (!collect.isEmpty()) {
            positionParentOrgMap.putAll(this.findAllParentOrgCodeListOfPositionParentList(new ArrayList<String>(collect)));
        }
        for (MdmPositionImportVo item2 : originList) {
            Map map;
            ArrayList<Object> nameList;
            HashSet<String> codeList;
            if (StringUtils.isEmpty((String)item2.getPositionLevelCode())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\uff1b");
            } else if (!positionLevelCodeSet.contains(item2.getPositionLevelCode())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u5b58\u5728\uff1b");
            }
            if (StringUtils.isEmpty((String)item2.getOrgCode())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801\uff1b");
            } else if (!orgCodeSet.contains(item2.getOrgCode())) {
                item2.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801\u65e0\u6548\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item2.getParentCode()) && !parentCodeSet.contains(item2.getParentCode())) {
                item2.appendErrorValidateMsg("\u4e0a\u7ea7\u7f16\u7801\u65e0\u6548\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item2.getRoleCode())) {
                codeList = new HashSet<String>();
                nameList = new ArrayList<Object>();
                String[] split = item2.getRoleCode().split(",");
                boolean allRight = true;
                for (String roleCode : split) {
                    if (!roleMap.containsKey(roleCode)) {
                        allRight = false;
                        item2.appendErrorValidateMsg("\u6743\u9650\u89d2\u8272\u7f16\u7801[" + roleCode + "]\u65e0\u6548\uff1b");
                        continue;
                    }
                    if (codeList.contains(roleCode)) continue;
                    codeList.add(roleCode);
                    nameList.add(roleMap.get(roleCode));
                }
                if (allRight) {
                    item2.setRoleCodeRedundancy(String.join((CharSequence)",", codeList));
                    item2.setRoleNameRedundancy(String.join((CharSequence)",", nameList));
                }
            } else if (AbstractImportVo.ProcessTypeEnum.SUCCESS == item2.getProcessType() && positionLevelRoleSetMap.containsKey(item2.getPositionLevelCode())) {
                codeList = new HashSet(16);
                nameList = new ArrayList();
                Set codeSet = (Set)positionLevelRoleSetMap.get(item2.getPositionLevelCode());
                if (!codeSet.isEmpty()) {
                    for (String roleCode : codeSet) {
                        if (!relRoleCodeNameMap.containsKey(roleCode)) continue;
                        codeList.add(roleCode);
                        nameList.add(relRoleCodeNameMap.get(roleCode));
                    }
                    item2.setRoleCodeRedundancy(String.join((CharSequence)",", codeList));
                    item2.setRoleNameRedundancy(String.join((CharSequence)",", nameList));
                    item2.setRoleCode(String.join((CharSequence)",", codeList));
                }
            }
            if (StringUtils.isNotEmpty((String)item2.getBpmRoleCode())) {
                String[] split;
                for (String bpmRoleCode : split = item2.getBpmRoleCode().split(",")) {
                    if (bpmRoleMap.containsKey(bpmRoleCode)) continue;
                    item2.appendErrorValidateMsg("\u6d41\u7a0b\u89d2\u8272\u7f16\u7801[" + bpmRoleCode + "]\u65e0\u6548\uff1b");
                }
            }
            if (!StringUtils.isNotEmpty((String)item2.getOrgCode()) || !StringUtils.isNotEmpty((String)item2.getParentCode()) || !positionParentOrgMap.containsKey(item2.getParentCode()) || !(map = (Map)positionParentOrgMap.get(item2.getParentCode())).containsKey(item2.getOrgCode())) continue;
            item2.appendErrorValidateMsg("\u7ec4\u7ec7[" + item2.getOrgCode() + "]\u5c5e\u4e8e\u8be5\u884c\u4e0a\u7ea7\u804c\u4f4d[" + item2.getParentCode() + "]\uff08\u53ca\u4e0a\u7ea7\u804c\u4f4d\uff09\u7684\u7ec4\u7ec7\uff08\u53ca\u4e0a\u7ea7\uff09\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u5f53\u524d\u804c\u4f4d\u7684\u7ec4\u7ec7\uff1b");
        }
    }

    public Map<String, Map<String, String>> findAllParentOrgCodeListOfPositionParentList(List<String> positionCodeList) {
        ConcurrentHashMap<String, Map<String, String>> map = new ConcurrentHashMap<String, Map<String, String>>(16);
        QueryWrapper positionQuery = new QueryWrapper();
        positionQuery.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        positionQuery.in((Object)"position_code", positionCodeList);
        List positionEntityList = this.mdmPositionMapper.selectList((Wrapper)positionQuery);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)positionEntityList)) {
            positionEntityList.forEach(position -> {
                Set parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes((String)position.getRuleCode());
                if (!parentRuleCodes.isEmpty()) {
                    Set parentRuleCodesExcludeSelf;
                    Set orgCodeSet;
                    QueryWrapper positionParentQuery = new QueryWrapper();
                    positionParentQuery.in((Object)"rule_code", (Collection)parentRuleCodes);
                    List parentPositionList = this.mdmPositionMapper.selectList((Wrapper)positionParentQuery);
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)parentPositionList) && !(orgCodeSet = parentPositionList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmPositionEntity::getOrgCode).collect(Collectors.toSet())).isEmpty() && !(parentRuleCodesExcludeSelf = TreeRuleCodeUtil.splitParentRuleCodesExcludeSelf(new ArrayList(orgCodeSet))).isEmpty()) {
                        QueryWrapper orgQuery = new QueryWrapper();
                        orgQuery.in((Object)"rule_code", (Collection)parentRuleCodesExcludeSelf);
                        List orgEntityList = this.mdmOrgMapper.selectList((Wrapper)orgQuery);
                        if (CollectionUtil.listNotEmptyNotSizeZero((List)orgEntityList)) {
                            map.put(position.getPositionCode(), orgEntityList.stream().collect(Collectors.toMap(MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName)));
                        }
                    }
                }
            });
        }
        return map;
    }
}

