/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.upload.UploadEnum;
import com.biz.crm.excel.controller.req.ExcelImportParamVo;
import com.biz.crm.excel.controller.resp.DemoFileResp;
import com.biz.crm.excel.controller.resp.UnAsyncImportRespVo;
import com.biz.crm.excel.service.ExcelImport;
import com.biz.crm.excel.util.CurrentLimitableImportListener;
import com.biz.crm.excel.util.ExcelImportUtil;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.upload.excel.req.ExcelExportReqVo;
import com.biz.crm.upload.excel.ExcelExportFeign;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component(value="defaultExcelImport")
public class DefaultExcelImport
implements ExcelImport {
    private static final Logger log = LoggerFactory.getLogger(DefaultExcelImport.class);
    @Value(value="${excel.export.downloadUrl}")
    private String EXCEL_DOWNLOAD_URL;
    @Resource
    private ExcelExportFeign excelExportFeign;
    @Resource
    private RocketMQProducer rocketMQProducer;

    @Override
    @Async
    public void doAsyncImport(ExcelImportParamVo paramVo, String token, File file) {
        try {
            UserUtils.setToken((String)token);
            CurrentLimitableImportListener listener = new CurrentLimitableImportListener(paramVo);
            listener.setEXCEL_DOWNLOAD_URL(this.EXCEL_DOWNLOAD_URL);
            EasyExcel.read((File)file, this.getClazz(paramVo.getClassPathAsImportVo()), listener).sheet().doRead();
        }
        catch (BusinessException e) {
            String msg = "\u5bfc\u5165\u4efb\u52a1[" + paramVo.getTaskCode() + "]:\u5bfc\u5165\u5f02\u5e38>>>>>" + e.getMsg();
            log.error(msg, (Throwable)e);
            this.updateTaskStatus(paramVo, msg);
            this.sendMQ(msg, paramVo);
        }
        catch (Exception e) {
            String msg = "\u5bfc\u5165\u4efb\u52a1[" + paramVo.getTaskCode() + "]:\u5bfc\u5165\u5f02\u5e38>>>>>" + e.getMessage();
            log.error(msg, (Throwable)e);
            this.updateTaskStatus(paramVo, msg);
            this.sendMQ(msg, paramVo);
        }
    }

    private void sendMQ(String msgBody, ExcelImportParamVo importParamVo) {
        String webSocketClientId = importParamVo.getWebSocketClientId();
        if (StringUtils.isBlank((CharSequence)webSocketClientId)) {
            if (log.isInfoEnabled()) {
                log.info("\u5bfc\u5165\u4efb\u52a1[" + importParamVo.getTaskCode() + "]:\u672a\u63d0\u4ea4 websocket id\uff0c\u5ffd\u7565 websocket \u6d88\u606f\u53d1\u9001\uff01");
            }
            return;
        }
        RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
        mqMessageBody.setTag("EXCEL_IMPORT_WEBSOCKET_MSG");
        JSONObject requestParam = new JSONObject();
        requestParam.put("sid", (Object)webSocketClientId);
        requestParam.put("websocketMessage", (Object)msgBody);
        mqMessageBody.setMsgBody(JSONObject.toJSONString((Object)requestParam));
        this.rocketMQProducer.convertAndSend(mqMessageBody);
    }

    private void updateTaskStatus(ExcelImportParamVo paramVo, String msg) {
        ExcelExportReqVo excelExportReqVo = new ExcelExportReqVo();
        excelExportReqVo.setId(paramVo.getTaskId());
        excelExportReqVo.setFileStatus(UploadEnum.fileStatus.IMPORT_EXCEPTION.getVal());
        excelExportReqVo.setRemarks(msg);
        Result result = this.excelExportFeign.update(excelExportReqVo);
        if (!ApiResultUtil.checkResult((Result)result)) {
            log.error("\u5bfc\u5165\u4efb\u52a1[" + paramVo.getTaskCode() + "]: \u540c\u6b65\u4efb\u52a1\u72b6\u6001\u5931\u8d25\uff01");
        }
    }

    @Override
    public UnAsyncImportRespVo doUnAsyncImport(ExcelImportParamVo importParamVo, File file) {
        importParamVo.setTest(true);
        CurrentLimitableImportListener listener = new CurrentLimitableImportListener(importParamVo);
        EasyExcel.read((File)file, this.getClazz(importParamVo.getClassPathAsImportVo()), listener).sheet().doRead();
        UnAsyncImportRespVo respVo = new UnAsyncImportRespVo();
        respVo.setDataAsFail(listener.getDataAsFail());
        respVo.setDataAsSuccess(listener.getDataCache());
        respVo.setTaskCode(importParamVo.getTaskCode());
        respVo.setTaskId(importParamVo.getTaskId());
        return respVo;
    }

    @Override
    public DemoFileResp demoFile(String importConfigCode) {
        Set superIgnore;
        ExcelImportParamVo excelImportParamVo = this.resolveConfig(importConfigCode);
        String fileName = excelImportParamVo.getFileNameAsDemo();
        Class<? extends AbstractImportVo> clazz = this.getClazz(excelImportParamVo.getClassPathAsImportVo());
        try {
            superIgnore = clazz.newInstance().superIgnore();
        }
        catch (InstantiationException e) {
            log.warn("\u89e3\u6790\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25[" + clazz.getName() + "]\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            throw new BusinessException("\u89e3\u6790\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25[" + clazz.getName() + "]\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn("\u89e3\u6790\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25[" + clazz.getName() + "]\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            throw new BusinessException("\u89e3\u6790\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25[" + clazz.getName() + "]\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
        superIgnore.addAll(AbstractImportVo.BASE_IMPORT_COLUMNS);
        File file = ExcelImportUtil.writeFile(fileName, clazz, ExcelTypeEnum.XLSX, Lists.newArrayList(), superIgnore);
        DemoFileResp demoFileResp = (DemoFileResp)CrmBeanUtil.copy((Object)excelImportParamVo, DemoFileResp.class);
        demoFileResp.setFile(file);
        return demoFileResp;
    }

    @Override
    public ExcelImportParamVo resolveConfig(String configCode) {
        String config = (String)DictUtil.getDictValueMapsByCodes((String)"excel_import_config").get(configCode);
        if (StringUtils.isBlank((CharSequence)config)) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        ExcelImportParamVo paramVo = (ExcelImportParamVo)JsonPropertyUtil.toObject((String)config, ExcelImportParamVo.class);
        if (null == paramVo) {
            throw new BusinessException("\u89e3\u6790\u5bfc\u5165\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5b57\u5178\u68c0\u67e5Excel\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        if (StringUtils.isBlank((CharSequence)paramVo.getBeanNameAsValidator())) {
            throw new BusinessException("\u5fc5\u987b\u914d\u7f6e\u6821\u9a8c\u903b\u8f91[beanNameAsValidator]\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5b57\u5178\u68c0\u67e5Excel\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        if (StringUtils.isBlank((CharSequence)paramVo.getClassPathAsImportVo())) {
            throw new BusinessException("\u5fc5\u987b\u914d\u7f6e\u89e3\u6790\u7c7b\u8def\u5f84[classPathAsImportVo]\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5b57\u5178\u68c0\u67e5Excel\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        if (StringUtils.isBlank((CharSequence)paramVo.getFileNameAsDemo())) {
            throw new BusinessException("\u5fc5\u987b\u914d\u7f6e\u793a\u4f8b\u6587\u4ef6\u540d[fileNameAsDemo]\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5b57\u5178\u68c0\u67e5Excel\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        paramVo.setImportConfigCode(configCode);
        return paramVo;
    }

    private Class<? extends AbstractImportVo> getClazz(String classPathAsImportVo) {
        if (StringUtils.isBlank((CharSequence)classPathAsImportVo)) {
            throw new BusinessException("\u5fc5\u987b\u914d\u7f6e\u89e3\u6790\u7c7b\u8def\u5f84[classPathAsImportVo]");
        }
        try {
            return Class.forName(classPathAsImportVo);
        }
        catch (ClassNotFoundException e) {
            log.warn("\u4e0d\u5b58\u5728\u7684\u884c\u89e3\u6790\u7c7b\u8def\u5f84[" + classPathAsImportVo + "]\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u884c\u89e3\u6790\u7c7b\u8def\u5f84[" + classPathAsImportVo + "]\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
    }
}

