/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.util;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.upload.UploadEnum;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.controller.req.ExcelImportParamVo;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.util.ExcelExportUtil;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.upload.excel.req.ExcelExportReqVo;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.upload.excel.ExcelExportFeign;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.ResultUtil;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CurrentLimitableImportListener<T extends AbstractImportVo>
extends AnalysisEventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(CurrentLimitableImportListener.class);
    private RocketMQProducer rocketMQProducer = (RocketMQProducer)SpringApplicationContextUtil.getApplicationContext().getBean("rocketMQProducer", RocketMQProducer.class);
    private RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
    private ExcelExportUtil excelExportUtil = (ExcelExportUtil)SpringApplicationContextUtil.getApplicationContext().getBean("excelExportUtil", ExcelExportUtil.class);
    private ExcelExportFeign excelExportFeign = (ExcelExportFeign)SpringApplicationContextUtil.getApplicationContext().getBean(ExcelExportFeign.class);
    private Class<? extends AbstractImportVo> dataClass;
    private String EXCEL_DOWNLOAD_URL;
    private ExcelImportParamVo importParamVo;
    private List<T> dataCache = Lists.newArrayList();
    private List<T> dataAsFail = Lists.newArrayList();
    private LocalDateTime beginDateTime = LocalDateTime.now();
    private ExcelImportValidator<T> validator;
    private ExcelImportSaver<T> saver;
    private boolean initTag = false;

    private void doProcess(DefaultImportContext context) {
        boolean errorFlag = this.validate(context);
        if (errorFlag) {
            this.sendMQ("\u6821\u9a8c\u5f02\u5e38\uff0c\u8df3\u8fc7\u6570\u636e\u4fdd\u5b58...");
            return;
        }
        Boolean test = this.importParamVo.getTest();
        if (null == test || test.booleanValue()) {
            this.dataCache.forEach(v -> v.appendSuccessSaveMsg("\u8df3\u8fc7\u6570\u636e\u4fdd\u5b58"));
            this.sendMQ("\u5f53\u524d\u4e3a\u6d4b\u8bd5\u6a21\u5f0f\uff0c\u8df3\u8fc7\u6570\u636e\u4fdd\u5b58...");
            return;
        }
        this.save(context);
    }

    private void init(T data) {
        if (this.initTag) {
            return;
        }
        String msg = "\u5bfc\u5165\u4efb\u52a1[" + this.importParamVo.getTaskCode() + "]:\u521d\u59cb\u5316\u76d1\u542c\u5668\u8d44\u6e90...";
        log.warn(msg);
        this.sendMQ(msg);
        if (null == this.importParamVo) {
            throw new BusinessException("\u65e0\u6548\u7684\u5bfc\u5165\u914d\u7f6e\u53c2\u6570");
        }
        try {
            this.validator = (ExcelImportValidator)SpringApplicationContextUtil.getApplicationContext().getBean(this.importParamVo.getBeanNameAsValidator(), ExcelImportValidator.class);
            if (!this.importParamVo.getTest().booleanValue()) {
                this.saver = (ExcelImportSaver)SpringApplicationContextUtil.getApplicationContext().getBean(this.importParamVo.getBeanNameAsSaver(), ExcelImportSaver.class);
            }
        }
        catch (Exception e) {
            log.warn("\u5bfc\u5165\u4efb\u52a1[" + this.importParamVo.getTaskCode() + "]:\u672a\u627e\u5230 ExcelImportSaver/ExcelImportValidator \u5b9e\u4f8b\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            this.sendMQ("\u76d1\u542c\u5668\u8d44\u6e90\u521d\u59cb\u5316\u5931\u8d25\uff1a\u672a\u627e\u5230 ExcelImportSaver/ExcelImportValidator \u5b9e\u4f8b\uff0c\u8bf7\u91cd\u8bd5\uff01");
            throw new BusinessException("\u672a\u627e\u5230 ExcelImportSaver/ExcelImportValidator \u5b9e\u4f8b\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
        if (null == this.dataClass) {
            this.dataClass = data.getClass();
        }
        this.initTag = true;
        this.sendMQ("\u76d1\u542c\u5668\u8d44\u6e90\u521d\u59cb\u5316\u5b8c\u6210...\n\u5f00\u59cb\u8bfb\u53d6EXCEL\u6570\u636e...");
    }

    public CurrentLimitableImportListener(ExcelImportParamVo importParamVo) {
        this.importParamVo = importParamVo;
    }

    public void invoke(T data, AnalysisContext context) {
        this.init(data);
        ReadRowHolder rowHolder = context.readRowHolder();
        if (null != rowHolder) {
            data.setRowIndex(rowHolder.getRowIndex());
        }
        this.dataCache.add(data);
    }

    private boolean validate(DefaultImportContext context) {
        this.sendMQ("\u5f00\u59cb\u6821\u9a8c\u6570\u636e...");
        String msg = null;
        boolean errorFlag = false;
        try {
            this.validator.validate(this.dataCache, context);
            this.sendMQ("\u6821\u9a8c\u5b8c\u6210...");
        }
        catch (BusinessException e) {
            errorFlag = true;
            msg = "\u5bfc\u5165\u4efb\u52a1[" + this.importParamVo.getTaskCode() + "]:\u5df2\u4e2d\u65ad\u5bfc\u5165\u4efb\u52a1\uff0c\u6821\u9a8c\u5f02\u5e38\uff1a" + e.getMsg();
            log.warn(msg, (Throwable)e);
        }
        catch (Exception e) {
            errorFlag = true;
            msg = "\u5bfc\u5165\u4efb\u52a1[" + this.importParamVo.getTaskCode() + "]:\u5df2\u4e2d\u65ad\u5bfc\u5165\u4efb\u52a1\uff0c\u6821\u9a8c\u5f02\u5e38\uff1a" + e.getClass().getName() + "[" + e.getMessage() + "]";
            log.warn(msg, (Throwable)e);
        }
        if (errorFlag) {
            for (AbstractImportVo data : this.dataCache) {
                data.appendErrorValidateMsg(msg);
            }
            this.sendMQ(msg);
        }
        List<T> dataAsSuccessTemp = this.cacheFailData(this.dataCache);
        this.dataCache = dataAsSuccessTemp;
        return errorFlag;
    }

    private void save(DefaultImportContext context) {
        this.sendMQ("\u5f00\u59cb\u4fdd\u5b58\u6570\u636e...");
        String msg = null;
        boolean errorFlag = false;
        try {
            this.saver.save(this.dataCache, context);
            this.sendMQ("\u4fdd\u5b58\u5b8c\u6210...");
        }
        catch (BusinessException e) {
            errorFlag = true;
            msg = "\u5bfc\u5165\u4efb\u52a1[" + this.importParamVo.getTaskCode() + "]:\u5df2\u4e2d\u65ad\u5bfc\u5165\u4efb\u52a1\uff0c\u4fdd\u5b58\u5f02\u5e38\uff1a" + e.getMsg();
            log.warn(msg, (Throwable)e);
        }
        catch (Exception e) {
            errorFlag = true;
            msg = "\u5bfc\u5165\u4efb\u52a1[" + this.importParamVo.getTaskCode() + "]:\u5df2\u4e2d\u65ad\u5bfc\u5165\u4efb\u52a1\uff0c\u4fdd\u5b58\u5f02\u5e38\uff1a" + e.getClass().getName() + "[" + e.getMessage() + "]";
            log.warn(msg, (Throwable)e);
        }
        if (errorFlag) {
            for (AbstractImportVo data : this.dataCache) {
                data.appendErrorSaveMsg(msg);
            }
            this.sendMQ(msg);
        }
        List<T> dataAsSuccessTemp = this.cacheFailData(this.dataCache);
        this.dataCache = dataAsSuccessTemp;
    }

    private List<T> cacheFailData(List<T> dataList) {
        ArrayList dataAsSuccessTemp;
        if (null == dataList) {
            return Lists.newArrayList();
        }
        Map<AbstractImportVo.ProcessTypeEnum, List<AbstractImportVo>> typeMapData = dataList.stream().collect(Collectors.groupingBy(AbstractImportVo::getProcessType));
        List<AbstractImportVo> dataAsFailTemp = typeMapData.get(AbstractImportVo.ProcessTypeEnum.FAIL);
        if (!CollectionUtils.isEmpty(dataAsFailTemp)) {
            this.dataAsFail.addAll(dataAsFailTemp);
        }
        if (null == (dataAsSuccessTemp = typeMapData.get(AbstractImportVo.ProcessTypeEnum.SUCCESS))) {
            dataAsSuccessTemp = Lists.newArrayList();
        }
        return dataAsSuccessTemp;
    }

    private void sendMQ(String msgBody) {
        String webSocketClientId = this.importParamVo.getWebSocketClientId();
        if (StringUtils.isBlank((CharSequence)webSocketClientId)) {
            if (log.isInfoEnabled()) {
                log.info("\u5bfc\u5165\u4efb\u52a1[" + this.importParamVo.getTaskCode() + "]:\u672a\u63d0\u4ea4 websocket id\uff0c\u5ffd\u7565 websocket \u6d88\u606f\u53d1\u9001\uff01");
            }
            return;
        }
        JSONObject requestParam = new JSONObject();
        requestParam.put("sid", (Object)webSocketClientId);
        requestParam.put("websocketMessage", (Object)msgBody);
        this.mqMessageBody.setMsgBody(JSONObject.toJSONString((Object)requestParam));
        this.mqMessageBody.setTag("EXCEL_IMPORT_WEBSOCKET_MSG");
        this.rocketMQProducer.convertAndSend(this.mqMessageBody);
    }

    private void importFinish(AnalysisContext context) {
        ExcelExportReqVo excelExportReqVo = this.uploadFileAndBuildExcelExportReqVo(context);
        if (null == excelExportReqVo) {
            return;
        }
        excelExportReqVo.setId(this.importParamVo.getTaskId());
        this.sendMQ("\u540c\u6b65\u4e0b\u8f7d\u4e2d\u5fc3\u4efb\u52a1\u72b6\u6001...");
        Result result = this.excelExportFeign.update(excelExportReqVo);
        if (!ApiResultUtil.checkResult((Result)result)) {
            this.sendMQ("\u540c\u6b65\u4e0b\u8f7d\u4e2d\u5fc3\u4efb\u52a1\u72b6\u6001\u5931\u8d25\uff1a" + result.getMessage());
            return;
        }
        this.sendMQ("\u540c\u6b65\u4e0b\u8f7d\u4e2d\u5fc3\u4efb\u52a1\u72b6\u6001\u5b8c\u6210...");
        this.sendFinishMsg(excelExportReqVo);
    }

    private ExcelExportReqVo uploadFileAndBuildExcelExportReqVo(AnalysisContext context) {
        List resultAsBaseData;
        File baseFile = context.readWorkbookHolder().getFile();
        try {
            this.sendMQ("EXCEL\u539f\u6587\u4ef6\u4e0a\u4f20...");
            resultAsBaseData = ResultUtil.listResultFromJsonStr((String)this.excelExportUtil.uploadFile(baseFile.getPath(), UserUtils.getToken()), UploadVo.class, (boolean)true);
            this.sendMQ("EXCEL\u539f\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210...");
        }
        catch (BusinessException e) {
            log.warn("\u5bfc\u5165\u4efb\u52a1[" + this.importParamVo.getTaskCode() + "]:EXCEL\u539f\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMsg(), (Throwable)e);
            this.sendMQ("EXCEL\u539f\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMsg());
            return null;
        }
        catch (Exception e) {
            log.warn("\u5bfc\u5165\u4efb\u52a1[" + this.importParamVo.getTaskCode() + "]:EXCEL\u539f\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            this.sendMQ("EXCEL\u539f\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
        UploadEnum.fileStatus fileStatus2 = UploadEnum.fileStatus.IMPORT_SUCCESS;
        UploadVo failData = null;
        String failFileName = "\u5904\u7406\u5931\u8d25\u6570\u636e";
        if (!CollectionUtils.isEmpty(this.dataAsFail)) {
            List temp;
            fileStatus2 = this.dataAsFail.size() >= this.dataCache.size() ? UploadEnum.fileStatus.IMPORT_FAIL : UploadEnum.fileStatus.IMPORT_EXCEPTION;
            try {
                this.sendMQ("\u5904\u7406\u5931\u8d25\u6570\u636e\u6587\u4ef6\u4e0a\u4f20...");
                temp = ResultUtil.listResultFromJsonStr((String)this.excelExportUtil.createExcelFile(failFileName, this.dataClass, context.readWorkbookHolder().getExcelType(), this.dataAsFail, null), UploadVo.class, (boolean)true);
                this.sendMQ("\u5904\u7406\u5931\u8d25\u6570\u636e\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210...");
            }
            catch (BusinessException e) {
                log.warn("\u5bfc\u5165\u4efb\u52a1[" + this.importParamVo.getTaskCode() + "]:\u5904\u7406\u5931\u8d25\u6570\u636e\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMsg(), (Throwable)e);
                this.sendMQ("\u5904\u7406\u5931\u8d25\u6570\u636e\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMsg());
                return null;
            }
            catch (Exception e) {
                log.warn("\u5bfc\u5165\u4efb\u52a1[" + this.importParamVo.getTaskCode() + "]:\u5904\u7406\u5931\u8d25\u6570\u636e\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                this.sendMQ("\u5904\u7406\u5931\u8d25\u6570\u636e\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage());
                return null;
            }
            failData = (UploadVo)temp.get(0);
        }
        UploadVo baseData = (UploadVo)resultAsBaseData.get(0);
        return this.buildExcelExportReqVo(baseFile.getName(), baseData, failFileName, failData, fileStatus2);
    }

    private ExcelExportReqVo buildExcelExportReqVo(String baseFileName, UploadVo baseData, String failFileName, UploadVo failData, UploadEnum.fileStatus fileStatus2) {
        ExcelExportReqVo vo = new ExcelExportReqVo();
        vo.setObjectName(baseData.getObjectName());
        vo.setFilePath(baseData.getUrl());
        if (null != failData) {
            vo.setObjectNameAsImportFail(failData.getObjectName());
            vo.setFilePathAsImportFail(failData.getUrl());
            vo.setFileNameAsImportFail(failFileName);
            vo.setExcelFileNameAsImportFail(failFileName);
        }
        vo.setFileSource(this.importParamVo.getFileNameAsDemo());
        vo.setFileParam(this.importParamVo.getImportConfigCode());
        vo.setFileType(UploadEnum.fileType.IMPORT.getVal());
        vo.setFileStatus(fileStatus2.getVal());
        vo.setBeginDate(this.beginDateTime.format(CrmDateUtils.yyyyMMddHHmmss));
        vo.setEndDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        return vo;
    }

    private void sendFinishMsg(ExcelExportReqVo excelExportReqVo) {
        StringBuilder msg = new StringBuilder("\u5f53\u524d\u4efb\u52a1\u6570\u636e\u603b\u884c\u6570\uff1a");
        msg.append(this.dataCache.size());
        msg.append("\u6761\n");
        msg.append("\u6210\u529f\u6570\uff1a");
        msg.append(this.dataCache.size() - this.dataAsFail.size());
        msg.append("\u6761\n");
        msg.append("\u5931\u8d25\u6570\uff1a");
        msg.append(this.dataAsFail.size());
        msg.append("\u6761");
        if (StringUtils.isNotBlank((CharSequence)excelExportReqVo.getObjectNameAsImportFail())) {
            msg.append("<a href='");
            msg.append(this.EXCEL_DOWNLOAD_URL);
            msg.append("?objectName=");
            msg.append(excelExportReqVo.getObjectNameAsImportFail());
            msg.append("'>[\u70b9\u51fb\u4e0b\u8f7d]</a>");
        }
        this.sendMQ(msg.toString());
    }

    private String buildDataCacheMsg() {
        StringBuilder msg = new StringBuilder();
        int i = 0;
        for (AbstractImportVo data : this.dataCache) {
            if (i > 0) {
                msg.append("\n");
            }
            msg.append("\u7b2c");
            msg.append(data.getRowIndex());
            msg.append("\u884c\uff08Excel\u884c\u53f7\uff09[\u6821\u9a8c: ");
            msg.append(data.getValidateMsg());
            msg.append(" -> \u4fdd\u5b58: ");
            msg.append(data.getSaveMsg());
            msg.append("]");
            ++i;
        }
        return msg.toString();
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        DefaultImportContext importContext = new DefaultImportContext();
        importContext.setContext(analysisContext);
        importContext.setImportParamVo(this.importParamVo);
        this.sendMQ("\u8bfb\u53d6EXCEL\u6570\u636e\u5b8c\u6210\uff0c\u603b\u5171\u8bfb\u53d6[" + this.dataCache.size() + "]\u884c\u6570\u636e...");
        this.doProcess(importContext);
        this.importFinish(analysisContext);
    }

    public void setEXCEL_DOWNLOAD_URL(String EXCEL_DOWNLOAD_URL) {
        this.EXCEL_DOWNLOAD_URL = EXCEL_DOWNLOAD_URL;
    }

    public ExcelImportParamVo getImportParamVo() {
        return this.importParamVo;
    }

    public List<T> getDataCache() {
        return this.dataCache;
    }

    public List<T> getDataAsFail() {
        return this.dataAsFail;
    }
}

