/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.customerorg;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.customerorg.MdmCustomerOrgImportVo;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmCustomerOrgImportValidator")
public class MdmCustomerOrgImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmCusOrgMapper, MdmCusOrgEntity, MdmCustomerOrgImportVo>
implements ExcelImportValidator<MdmCustomerOrgImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerOrgImportValidator.class);
    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;

    @Override
    public void validate(List<MdmCustomerOrgImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validateRequired(data);
    }

    protected void validateRequired(List<MdmCustomerOrgImportVo> originList) {
        Map cusOrgTypeMap = DictUtil.dictMap((String)"cus_org_type");
        HashMap cusOrgTypeValueCodeMap = new HashMap(16);
        for (Map.Entry entry : cusOrgTypeMap.entrySet()) {
            if (cusOrgTypeValueCodeMap.containsKey(entry.getValue())) continue;
            cusOrgTypeValueCodeMap.put(entry.getValue(), entry.getKey());
        }
        Map cusOrgLevelMap = DictUtil.dictMap((String)"cus_org_level");
        HashMap cusOrgLevelValueCodeMap = new HashMap(16);
        for (Map.Entry entry : cusOrgLevelMap.entrySet()) {
            if (cusOrgLevelValueCodeMap.containsKey(entry.getValue())) continue;
            cusOrgLevelValueCodeMap.put(entry.getValue(), entry.getKey());
        }
        HashMap<String, Integer> originOrgCodeMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> originOrgNameMap = new HashMap<String, Integer>(16);
        HashSet orgCodeUniqueSet = new HashSet(16);
        Set originOrgCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getCustomerOrgCode())).map(MdmCustomerOrgImportVo::getCustomerOrgCode).collect(Collectors.toSet());
        if (!originOrgCodeSet.isEmpty()) {
            QueryWrapper orgCodeUniqueQuery = new QueryWrapper();
            orgCodeUniqueQuery.in((Object)"customer_org_code", originOrgCodeSet);
            List orgCodeUniqueList = this.mdmCusOrgMapper.selectList((Wrapper)orgCodeUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orgCodeUniqueList)) {
                orgCodeUniqueSet.addAll(orgCodeUniqueList.stream().map(MdmCusOrgEntity::getCustomerOrgCode).collect(Collectors.toSet()));
            }
        }
        HashSet orgNameUniqueSet = new HashSet(16);
        Set originOrgNameSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getCustomerOrgName())).map(MdmCustomerOrgImportVo::getCustomerOrgName).collect(Collectors.toSet());
        if (!originOrgNameSet.isEmpty()) {
            QueryWrapper orgNameUniqueQuery = new QueryWrapper();
            orgNameUniqueQuery.in((Object)"customer_org_name", originOrgNameSet);
            List orgNameUniqueList = this.mdmCusOrgMapper.selectList((Wrapper)orgNameUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orgNameUniqueList)) {
                orgNameUniqueSet.addAll(orgNameUniqueList.stream().map(MdmCusOrgEntity::getCustomerOrgName).collect(Collectors.toSet()));
            }
        }
        HashSet parentCodeCheckSet = new HashSet(16);
        Set originParentCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentCode())).map(MdmCustomerOrgImportVo::getParentCode).collect(Collectors.toSet());
        if (!originParentCodeSet.isEmpty()) {
            QueryWrapper parentQuery = new QueryWrapper();
            parentQuery.in((Object)"customer_org_code", originParentCodeSet);
            List parentCodeCheckList = this.mdmCusOrgMapper.selectList((Wrapper)parentQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)parentCodeCheckList)) {
                parentCodeCheckSet.addAll(parentCodeCheckList.stream().map(MdmCusOrgEntity::getCustomerOrgCode).collect(Collectors.toSet()));
            }
        }
        for (MdmCustomerOrgImportVo item2 : originList) {
            if (StringUtils.isNotEmpty((String)item2.getCustomerOrgCode())) {
                if (originOrgCodeMap.containsKey(item2.getCustomerOrgCode())) {
                    item2.appendErrorValidateMsg("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0e\u7b2c" + originOrgCodeMap.get(item2.getCustomerOrgCode()) + "\u884c\u91cd\u590d\uff1b");
                } else {
                    originOrgCodeMap.put(item2.getCustomerOrgCode(), item2.getRowIndex());
                }
                if (orgCodeUniqueSet.contains(item2.getCustomerOrgCode())) {
                    item2.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff1b");
                }
            }
            if (StringUtils.isEmpty((String)item2.getCustomerOrgName())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u7ec4\u7ec7\u540d\u79f0\uff1b");
            } else {
                if (originOrgNameMap.containsKey(item2.getCustomerOrgName())) {
                    item2.appendErrorValidateMsg("\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4e0e\u7b2c" + originOrgNameMap.get(item2.getCustomerOrgName()) + "\u884c\u91cd\u590d\uff1b");
                } else {
                    originOrgNameMap.put(item2.getCustomerOrgName(), item2.getRowIndex());
                }
                if (orgNameUniqueSet.contains(item2.getCustomerOrgName())) {
                    item2.appendErrorValidateMsg("\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728\uff1b");
                }
            }
            if (StringUtils.isEmpty((String)item2.getCustomerOrgLevelName())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u5ba2\u6237\u7ec4\u7ec7\u5c42\u7ea7\uff1b");
            } else if (!cusOrgLevelValueCodeMap.containsKey(item2.getCustomerOrgLevelName())) {
                item2.appendErrorValidateMsg("\u5ba2\u6237\u7ec4\u7ec7\u5c42\u7ea7\u65e0\u6548\uff1b");
            } else {
                item2.setCustomerOrgLevel((String)cusOrgLevelValueCodeMap.get(item2.getCustomerOrgLevelName()));
            }
            if (StringUtils.isEmpty((String)item2.getCustomerOrgTypeName())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u5ba2\u6237\u7ec4\u7ec7\u7c7b\u578b\uff1b");
                continue;
            }
            if (!cusOrgTypeValueCodeMap.containsKey(item2.getCustomerOrgTypeName())) {
                item2.appendErrorValidateMsg("\u5ba2\u6237\u7ec4\u7ec7\u7c7b\u578b\u65e0\u6548\uff1b");
                continue;
            }
            item2.setCustomerOrgType((String)cusOrgTypeValueCodeMap.get(item2.getCustomerOrgTypeName()));
        }
        for (MdmCustomerOrgImportVo item2 : originList) {
            if (StringUtils.isEmpty((String)item2.getParentCode()) || parentCodeCheckSet.contains(item2.getParentCode()) || originOrgCodeSet.contains(item2.getParentCode())) continue;
            item2.appendErrorValidateMsg("\u4e0a\u7ea7\u7f16\u7801\u65e0\u6548\uff1b");
        }
        Set<String> errorCode = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getCustomerOrgCode()) && AbstractImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()).map(MdmCustomerOrgImportVo::getCustomerOrgCode).collect(Collectors.toSet());
        if (!errorCode.isEmpty()) {
            this.setErrorParent(originList, errorCode);
        }
    }

    private void setErrorParent(List<MdmCustomerOrgImportVo> originList, Set<String> errorCode) {
        if (errorCode.isEmpty()) {
            return;
        }
        Set<String> codeOnTheTree = this.getCodeOnTheTree(originList);
        originList.forEach(item -> {
            if (StringUtils.isNotEmpty((String)item.getParentCode()) && errorCode.contains(item.getParentCode())) {
                item.appendErrorValidateMsg("\u4e0a\u7ea7\u6821\u9a8c\u672a\u901a\u8fc7\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item.getCustomerOrgCode()) && !codeOnTheTree.contains(item.getCustomerOrgCode())) {
                item.appendErrorValidateMsg("\u53ef\u80fd\u5904\u5728\u73af\u5f62\u7ed3\u6784\u4e0a\u6216\u8005\u4e0a\u7ea7\u5904\u4e8e\u73af\u5f62\u7ed3\u6784\u4e0a\uff1b");
            }
        });
    }

    private Set<String> getCodeOnTheTree(List<MdmCustomerOrgImportVo> originList) {
        HashSet<String> orgCodeOnTheTree = new HashSet<String>(16);
        List totalList = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getCustomerOrgCode())).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(totalList)) {
            Set totalSet = totalList.stream().map(MdmCustomerOrgImportVo::getCustomerOrgCode).collect(Collectors.toSet());
            Set topCodeSet = totalList.stream().filter(item -> StringUtils.isEmpty((String)item.getParentCode()) || !totalSet.contains(item.getParentCode())).map(MdmCustomerOrgImportVo::getCustomerOrgCode).collect(Collectors.toSet());
            if (!topCodeSet.isEmpty()) {
                HashSet curLevelSet = new HashSet(16);
                curLevelSet.addAll(topCodeSet);
                orgCodeOnTheTree.addAll(curLevelSet);
                while (!curLevelSet.isEmpty()) {
                    Set collect = totalList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentCode()) && curLevelSet.contains(item.getParentCode()) && !item.getParentCode().equals(item.getCustomerOrgCode())).map(MdmCustomerOrgImportVo::getCustomerOrgCode).collect(Collectors.toSet());
                    curLevelSet.clear();
                    if (collect.isEmpty()) continue;
                    orgCodeOnTheTree.addAll(collect);
                    curLevelSet.addAll(collect);
                }
            }
        }
        return orgCodeOnTheTree;
    }
}

