/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.availablelistrule;

import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.availablelistrule.AvailableRuleImportVo;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleAreaVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleGoodsVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Component;

@Component(value="availableRuleSaver")
public class AvailableRuleSaver
implements ExcelImportSaver<AvailableRuleImportVo> {
    private static final int SEND_MAX_COUNT = 10;
    @Resource
    private RocketMQProducer rocketMQProducer;

    @Override
    public void save(List<AvailableRuleImportVo> data, DefaultImportContext context) {
        List<AvailableListRuleVo> ruleVos = this.buildRules(data);
        ArrayList sendList = Lists.newArrayList();
        for (int i = 0; i < ruleVos.size(); ++i) {
            sendList.add(ruleVos.get(i));
            if ((i + 1) % 10 != 0 && i + 1 != ruleVos.size()) continue;
            RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)sendList));
            rocketMQMessageBody.setTag("AVAILABLE_RULE_IMPORT_TAG");
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
            sendList.clear();
        }
    }

    private List<AvailableListRuleVo> buildRules(List<AvailableRuleImportVo> data) {
        ArrayList result = Lists.newArrayList();
        Map<String, List<AvailableRuleImportVo>> map = data.stream().collect(Collectors.groupingBy(AvailableRuleImportVo::getCode));
        map.values().forEach(list2 -> this.buildRules((List<AvailableRuleImportVo>)list2, result));
        return result;
    }

    private void buildRules(List<AvailableRuleImportVo> list, List<AvailableListRuleVo> result) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        AvailableRuleImportVo importVoOne = list.get(0);
        ArrayList areas = Lists.newArrayList();
        ArrayList goods = Lists.newArrayList();
        AvailableListRuleVo rule = (AvailableListRuleVo)CrmBeanUtil.copy((Object)((Object)importVoOne), AvailableListRuleVo.class);
        list.forEach(li -> {
            AvailableListRuleAreaVo area = (AvailableListRuleAreaVo)CrmBeanUtil.copy((Object)li, AvailableListRuleAreaVo.class);
            AvailableListRuleGoodsVo good = (AvailableListRuleGoodsVo)CrmBeanUtil.copy((Object)li, AvailableListRuleGoodsVo.class);
            areas.add(area);
            goods.add(good);
        });
        rule.setGoods((List)goods);
        rule.setAreaes((List)areas);
        result.add(rule);
    }
}

