/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.product;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.product.MdmProductLevelImportVo;
import com.biz.crm.mdm.kms.MdmKmsFeign;
import com.biz.crm.mdm.product.entity.MdmProductLevelEntity;
import com.biz.crm.mdm.product.mapper.MdmProductLevelMapper;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ProductLevelUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="mdmProductLevelImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmProductLevelImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmProductLevelMapper, MdmProductLevelEntity, MdmProductLevelImportVo>
implements ExcelImportSaver<MdmProductLevelImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmProductLevelImportSaver.class);
    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;
    @Resource
    private MdmKmsFeign mdmKmsFeign;

    @Override
    public void save(List<MdmProductLevelImportVo> data, DefaultImportContext context) {
        log.info("\u4ea7\u54c1\u5c42\u7ea7\u5bfc\u5165:{}", data);
        if (!data.isEmpty()) {
            List productLevel = Lists.partition(data, (int)50);
            for (List mdmProductLevelImportVos : productLevel) {
                List levelEntities = CrmBeanUtil.copyList((List)mdmProductLevelImportVos, MdmProductLevelEntity.class);
                levelEntities.forEach(m -> {
                    if (StringUtils.isEmpty((String)m.getProductLevelCode())) {
                        m.setProductLevelCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_PRODUCT_LEVEL_CODE.getCode()));
                    }
                    m.setRuleCode(UUID.randomUUID().toString().replace("-", ""));
                    m.setLevelNum(1);
                });
                this.mdmKmsFeign.addCategoryBatch(CrmBeanUtil.copyList((List)levelEntities, MdmProductLevelReqVo.class));
                this.saveBatch(levelEntities);
            }
            this.resetRuleCode();
        }
    }

    private void resetRuleCode() {
        long l = System.currentTimeMillis();
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u5f00\u59cb-----------");
        this.mdmProductLevelMapper.copyIdToRuleCode();
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f16\u7801\u91cd\u7f6e\u6210id\u6210\u529f-----------");
        this.mdmProductLevelMapper.setNullNotExistParentCode();
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u6e05\u9664\u65e0\u6548\u4e0a\u7ea7\u7f16\u7801\u6210\u529f-----------");
        List topList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmProductLevelEntity::getParentCode)).or()).eq(MdmProductLevelEntity::getParentCode, (Object)"")).list();
        for (int i = 0; i < topList.size(); ++i) {
            this.updateCurAndChildren(((MdmProductLevelEntity)((Object)topList.get(i))).getProductLevelCode(), TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), 1);
        }
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f16\u7801\u91cd\u65b0\u751f\u6210\u6210\u529f-----------");
        ProductLevelUtil.deleteAllCache();
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f13\u5b58\u6e05\u9664\u6210\u529f-----------");
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7ed3\u675f-----------");
    }

    private void updateCurAndChildren(String productLevelCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).set(CrmTreeTenEntity::getRuleCode, (Object)curCode)).set(CrmTreeTenEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getParentCode, (Object)productLevelCode)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmProductLevelEntity)((Object)list.get(i))).getProductLevelCode(), curCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), levelNum + 1);
            }
        }
    }
}

