/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.terminal;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalImportVo;
import com.biz.crm.mdm.kms.MdmKmsFeign;
import com.biz.crm.mdm.terminal.entity.MdmTerminalContactEntity;
import com.biz.crm.mdm.terminal.entity.MdmTerminalEntity;
import com.biz.crm.mdm.terminal.entity.MdmTerminalROrgEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalContactMapper;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalROrgMapper;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmTerminalImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmTerminalImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmTerminalMapper, MdmTerminalEntity, MdmTerminalImportVo>
implements ExcelImportSaver<MdmTerminalImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalImportSaver.class);
    @Resource
    private MdmTerminalROrgMapper mdmTerminalROrgMapper;
    @Resource
    private MdmTerminalContactMapper mdmTerminalContactMapper;
    @Resource
    private MdmKmsFeign mdmKmsFeign;

    @Override
    public void save(List<MdmTerminalImportVo> data, DefaultImportContext context) {
        log.info("\u7ec8\u7aef\u5bfc\u5165:{}", data);
        Map channel = DictUtil.dictMap((String)"channel");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : channel.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        Map map = DictUtil.dictMap((String)"terminal_type");
        HashMap terminalTypeMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (terminalTypeMap.containsKey(entry.getValue())) continue;
            terminalTypeMap.put(entry.getValue(), entry.getKey());
        }
        if (!CollectionUtils.isEmpty(data)) {
            List<MdmTerminalContactEntity> mdmTerminalContactEntities;
            data.forEach(item -> {
                if (StringUtils.isEmpty((Object)item.getTerminalCode())) {
                    item.setTerminalCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_TERMINAL.getCode()));
                }
            });
            List partition = Lists.partition(data, (int)50);
            for (Object mdmTerminalVos : partition) {
                List<MdmTerminalROrgEntity> mdmTerminalROrgEntities = mdmTerminalVos.stream().filter(x -> !StringUtils.isEmpty((Object)x.getOrgCode()) && x.getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS).flatMap(x -> {
                    ArrayList<MdmTerminalROrgEntity> list = new ArrayList<MdmTerminalROrgEntity>();
                    String terminalCode = x.getTerminalCode();
                    for (String orgCode : x.getOrgCode().split(",")) {
                        MdmTerminalROrgEntity mdmTerminalROrgEntity = new MdmTerminalROrgEntity();
                        mdmTerminalROrgEntity.setId(UUID.randomUUID().toString());
                        mdmTerminalROrgEntity.setOrgCode(orgCode);
                        mdmTerminalROrgEntity.setTerminalCode(terminalCode);
                        list.add(mdmTerminalROrgEntity);
                    }
                    return list.stream();
                }).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(mdmTerminalROrgEntities)) continue;
                this.mdmTerminalROrgMapper.insertBatch(mdmTerminalROrgEntities);
            }
            ArrayList<MdmTerminalImportVo> list = new ArrayList<MdmTerminalImportVo>();
            for (MdmTerminalImportVo mdmTerminalImportVo2 : data) {
                if (mdmTerminalImportVo2.getProcessType() != AbstractImportVo.ProcessTypeEnum.SUCCESS) continue;
                mdmTerminalImportVo2.setChannel((String)channelMap.get(mdmTerminalImportVo2.getChannel()));
                mdmTerminalImportVo2.setTerminalType((String)terminalTypeMap.get(mdmTerminalImportVo2.getTerminalType()));
                list.add(mdmTerminalImportVo2);
            }
            if (!CollectionUtils.isEmpty(list)) {
                List entityList = CrmBeanUtil.copyList(list, MdmTerminalEntity.class);
                this.mdmKmsFeign.addStoreBatch(CrmBeanUtil.copyList(list, MdmTerminalVo.class));
                this.saveBatch(entityList);
            }
            if (!CollectionUtils.isEmpty(mdmTerminalContactEntities = data.stream().filter(x -> (!StringUtils.isEmpty((Object)x.getContactName()) || !StringUtils.isEmpty((Object)x.getContactPhone())) && x.getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS).map(mdmTerminalImportVo -> {
                MdmTerminalContactEntity mdmTerminalContactEntity = new MdmTerminalContactEntity();
                mdmTerminalContactEntity.setId(UUID.randomUUID().toString());
                mdmTerminalContactEntity.setTerminalCode(mdmTerminalImportVo.getTerminalCode());
                mdmTerminalContactEntity.setContactName(mdmTerminalImportVo.getContactName());
                mdmTerminalContactEntity.setContactPhone(mdmTerminalImportVo.getContactPhone());
                mdmTerminalContactEntity.setContactMain(YesNoEnum.yesNoEnum.ONE.getValue());
                return mdmTerminalContactEntity;
            }).collect(Collectors.toList()))) {
                this.mdmTerminalContactMapper.insertBatch(mdmTerminalContactEntities);
            }
        }
    }
}

