/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.user;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.user.MdmUserImportVo;
import com.biz.crm.mdm.position.entity.MdmPositionUserEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionUserMapper;
import com.biz.crm.mdm.user.entity.MdmUserEntity;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="mdmUserImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmUserImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmUserMapper, MdmUserEntity, MdmUserImportVo>
implements ExcelImportSaver<MdmUserImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmUserImportSaver.class);
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmPositionUserMapper mdmPositionUserMapper;

    @Override
    public void save(List<MdmUserImportVo> data, DefaultImportContext context) {
        log.info("\u5bfc\u5165\u7528\u6237");
        if (data == null || data.size() == 0) {
            return;
        }
        ArrayList<MdmUserEntity> userEntityList = new ArrayList<MdmUserEntity>();
        ArrayList<MdmPositionUserEntity> positionUserEntityList = new ArrayList<MdmPositionUserEntity>();
        for (MdmUserImportVo item : data) {
            if (AbstractImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()) continue;
            MdmUserEntity mdmUserEntity = (MdmUserEntity)((Object)CrmBeanUtil.copy((Object)((Object)item), MdmUserEntity.class));
            mdmUserEntity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
            mdmUserEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            mdmUserEntity.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)item.getUserPassword()));
            mdmUserEntity.setUserType(UserTypeEnum.USER.getCode());
            mdmUserEntity.setUserCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_USER_CODE.getCode()));
            userEntityList.add(mdmUserEntity);
            MdmPositionUserEntity positionUserEntity = new MdmPositionUserEntity();
            positionUserEntity.setPositionCode(item.getPrimaryPositionCode());
            positionUserEntity.setUserName(item.getUserName());
            positionUserEntity.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
            positionUserEntity.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
            positionUserEntityList.add(positionUserEntity);
            if (!StringUtils.isNotEmpty((String)item.getOtherPositionCodes())) continue;
            for (String positionCode : item.getOtherPositionCodes().split(",")) {
                MdmPositionUserEntity otherRel = new MdmPositionUserEntity();
                otherRel.setPositionCode(positionCode);
                otherRel.setUserName(item.getUserName());
                otherRel.setPrimaryFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                otherRel.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                positionUserEntityList.add(otherRel);
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(userEntityList)) {
            if (CollectionUtil.listNotEmptyNotSizeZero(positionUserEntityList)) {
                QueryWrapper positionRelUserDelete = new QueryWrapper();
                positionRelUserDelete.in((Object)"position_code", (Collection)positionUserEntityList.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toSet()));
                this.mdmPositionUserMapper.delete((Wrapper)positionRelUserDelete);
            }
            List userGroup = Lists.partition(userEntityList, (int)50);
            for (List list : userGroup) {
                this.saveBatch(list);
            }
            for (MdmPositionUserEntity mdmPositionUserEntity : positionUserEntityList) {
                this.mdmPositionUserMapper.insert((Object)mdmPositionUserEntity);
            }
            PositionUtil.deleteAllCache();
        }
    }
}

