/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.sfa;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaAchievementRuleImportVo;
import com.biz.crm.sfa.test.entity.SfaAchievementRuleEntity;
import com.biz.crm.sfa.test.entity.SfaIndexEntity;
import com.biz.crm.sfa.test.mapper.SfaAchievementRuleMapper;
import com.biz.crm.sfa.test.mapper.SfaIndexMapper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component(value="sfaAchievementRuleSaver")
@Transactional(transactionManager="sfaTransactionManager")
public class SfaAchievementRuleSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<SfaAchievementRuleMapper, SfaAchievementRuleEntity, SfaAchievementRuleImportVo>
implements ExcelImportSaver<SfaAchievementRuleImportVo> {
    private static final Logger log = LoggerFactory.getLogger(SfaAchievementRuleSaver.class);
    @Autowired
    private SfaIndexMapper indexMapper;

    @Override
    public void save(List<SfaAchievementRuleImportVo> data, DefaultImportContext context) {
        log.warn("\u5bfc\u5165---\u4fdd\u5b58\u6570\u636e\u903b\u8f91==========================");
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        BigDecimal bigDecimal = new BigDecimal("0");
        for (SfaAchievementRuleImportVo v : data) {
            StringBuilder achievementDate;
            StringBuilder msg = new StringBuilder();
            AssertUtils.isNotEmpty((String)v.getObjectCode(), (String)"\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)v.getObjectName(), (String)"\u5bf9\u8c61\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)v.getObjectPosName(), (String)"\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            if (!(v.getAchievementType().equals(WorkSignEnum.achievementTimeType.MM.getDesc()) || v.getAchievementType().equals(WorkSignEnum.achievementTimeType.TD.getDesc()) || v.getAchievementType().equals(WorkSignEnum.achievementTimeType.FT.getDesc()))) {
                msg.append("\u7ee9\u6548\u7c7b\u578b\u4e0d\u6b63\u786e\uff1b");
            }
            if (WorkSignEnum.achievementTimeType.MM.getDesc().equals(v.getAchievementType())) {
                this.doCheckMouth(v, msg);
                achievementDate = new StringBuilder().append(v.getAchievementDateYear()).append("\u5e74").append(v.getAchievementDateMonth()).append("\u6708");
                v.setAchievementDate(achievementDate.toString());
                this.getDayOfDate(v, msg);
            }
            if (WorkSignEnum.achievementTimeType.TD.getDesc().equals(v.getAchievementType())) {
                this.doCheckMouth(v, msg);
                if (org.apache.commons.lang.StringUtils.isBlank((String)v.getAchievementDateTenDays())) {
                    msg.append("\u7ee9\u6548\u65ec\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                    throw new BusinessException("\u7ee9\u6548\u65ec\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!WorkSignEnum.achievementTimeType.XX.getDesc().equals(v.getAchievementDateTenDays()) && !WorkSignEnum.achievementTimeType.SX.getDesc().equals(v.getAchievementDateTenDays())) {
                    msg.append("\u7ee9\u6548\u65ec\u5ea6\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
                }
                achievementDate = new StringBuilder().append(v.getAchievementDateYear()).append("\u5e74").append(v.getAchievementDateMonth()).append("\u6708");
                v.setAchievementDate(achievementDate.toString());
                if (v.getAchievementDateTenDays().equals(WorkSignEnum.achievementTimeType.SX.getDesc())) {
                    achievementDate.append(WorkSignEnum.achievementTimeType.SX.getDesc());
                }
                if (v.getAchievementDateTenDays().equals(WorkSignEnum.achievementTimeType.XX.getDesc())) {
                    achievementDate.append(WorkSignEnum.achievementTimeType.XX.getDesc());
                }
                this.getDayOfDate(v, msg);
            }
            if (WorkSignEnum.achievementTimeType.FT.getDesc().equals(v.getAchievementType())) {
                if (org.apache.commons.lang.StringUtils.isBlank((String)v.getBeginDate())) {
                    msg.append("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                    throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (org.apache.commons.lang.StringUtils.isBlank((String)v.getEndDate())) {
                    msg.append("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                    throw new BusinessException("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                LocalDate beginDate = null;
                try {
                    beginDate = LocalDate.parse(v.getBeginDate(), CrmDateUtils.yyyyMMdd);
                }
                catch (Exception e) {
                    msg.append("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff1b");
                    throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
                }
                LocalDate endDate = null;
                try {
                    endDate = LocalDate.parse(v.getEndDate(), CrmDateUtils.yyyyMMdd);
                }
                catch (Exception e) {
                    msg.append("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff1b");
                    throw new BusinessException("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
                }
                if (!beginDate.isBefore(endDate)) {
                    msg.append("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u7ed3\u675f\u65f6\u95f4\uff1b");
                    throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u7ed3\u675f\u65f6\u95f4");
                }
                v.setAchievementDate(v.getBeginDate() + "-" + v.getEndDate());
            }
            this.doCheckWeight(v.getWeight(), msg);
            BigDecimal wight = new BigDecimal(v.getWeight());
            bigDecimal = bigDecimal.add(wight);
            this.doCheckTargetNum(v.getTargetNum(), msg);
            this.doCheckIndex(v.getIndexCode(), v.getIndexName(), msg);
            if (org.apache.commons.lang.StringUtils.isBlank((String)v.getUnit())) {
                msg.append("\u7ee9\u6548\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                throw new BusinessException("\u7ee9\u6548\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.errorMsgAndSendWebsocket(v, msg.toString(), context);
        }
        if (bigDecimal.compareTo(new BigDecimal(YesNoEnum.YesNoCodeNumberEnum.YES.getCode())) != 0) {
            throw new BusinessException("\u5408\u8ba1\u4e0d\u4e3a100%");
        }
        List partitionDataList = Lists.partition(data, (int)50);
        partitionDataList.forEach(dataList -> this.saveBatch(CrmBeanUtil.copyList((List)dataList, SfaAchievementRuleEntity.class)));
    }

    public SfaAchievementRuleImportVo getDayOfDate(SfaAchievementRuleImportVo reqVo, StringBuilder msg) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        String s = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
        Date date = null;
        try {
            date = format.parse(s);
        }
        catch (Exception e) {
            msg.append("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff1b");
            throw new BusinessException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        cale.setTime(date);
        cale.add(2, 0);
        cale.set(5, 1);
        String firstDay = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String lastDay = format.format(cale.getTime());
        if (StringUtils.isNotEmpty((String)reqVo.getAchievementDateTenDays())) {
            if (WorkSignEnum.achievementTimeType.SX.getDesc().equals(reqVo.getAchievementDateTenDays())) {
                lastDay = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
            } else {
                firstDay = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
            }
        }
        reqVo.setBeginDate(firstDay);
        reqVo.setEndDate(lastDay);
        return reqVo;
    }

    public void doCheckMouth(SfaAchievementRuleImportVo v, StringBuilder msg) {
        if (!org.apache.commons.lang.StringUtils.isNumeric((String)v.getAchievementDateYear()) || !org.apache.commons.lang.StringUtils.isNumeric((String)v.getAchievementDateMonth())) {
            msg.append("\u7ee9\u6548\u5e74\u6708\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
            throw new BusinessException("\u7ee9\u6548\u5e74\u6708\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (v.getAchievementDateYear().length() != 4) {
            msg.append("\u7ee9\u6548\u5e74\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
            throw new BusinessException("\u7ee9\u6548\u5e74\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (v.getAchievementDateMonth().length() == 1) {
            v.setAchievementDateMonth(YesNoEnum.yesNoEnum.ZERO.getValue() + v.getAchievementDateMonth());
        }
        if (v.getAchievementDateMonth().length() != 2) {
            msg.append("\u7ee9\u6548\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
            throw new BusinessException("\u7ee9\u6548\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        int month = Integer.parseInt(v.getAchievementDateMonth());
        if (month > 12 || month < 0) {
            msg.append("\u7ee9\u6548\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
            throw new BusinessException("\u7ee9\u6548\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    public void doCheckWeight(String weight, StringBuilder msg) {
        try {
            BigDecimal w = new BigDecimal(weight);
            if (w.compareTo(new BigDecimal(YesNoEnum.yesNoEnum.ZERO.getValue())) <= -1 || w.compareTo(new BigDecimal(YesNoEnum.yesNoEnum.ONE.getValue())) >= 1) {
                msg.append("\u7ee9\u6548\u6743\u91cd\u4e0d\u5408\u6cd5\uff1b");
                throw new BusinessException("\u7ee9\u6548\u6743\u91cd\u4e0d\u5408\u6cd5");
            }
        }
        catch (Exception e) {
            msg.append("\u7ee9\u6548\u6743\u91cd\u4e0d\u5408\u6cd5\uff1b");
            throw new BusinessException("\u7ee9\u6548\u6743\u91cd\u4e0d\u5408\u6cd5");
        }
    }

    public void doCheckTargetNum(String targetNum, StringBuilder msg) {
        if (!org.apache.commons.lang.StringUtils.isNumeric((String)targetNum)) {
            msg.append("\u7ee9\u6548\u76ee\u6807\u6570\u91cf\u4e0d\u5408\u6cd5\uff1b");
            throw new BusinessException("\u7ee9\u6548\u76ee\u6807\u6570\u91cf\u4e0d\u5408\u6cd5");
        }
        try {
            int t = Integer.parseInt(targetNum);
            if (t < YesNoEnum.YesNoCodeNumberEnum.NO.getCode()) {
                msg.append("\u7ee9\u6548\u76ee\u6807\u6570\u91cf\u4e0d\u5408\u6cd5\uff1b");
                throw new BusinessException("\u7ee9\u6548\u76ee\u6807\u6570\u91cf\u4e0d\u5408\u6cd5");
            }
        }
        catch (Exception e) {
            msg.append("\u7ee9\u6548\u76ee\u6807\u6570\u91cf\u4e0d\u5408\u6cd5\uff1b");
            throw new BusinessException("\u7ee9\u6548\u76ee\u6807\u6570\u91cf\u4e0d\u5408\u6cd5");
        }
    }

    public void doCheckIndex(String indexCode, String indexName, StringBuilder msg) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"index_code", (Object)indexCode)).eq((Object)"index_name", (Object)indexName);
        SfaIndexEntity entity = (SfaIndexEntity)((Object)this.indexMapper.selectOne((Wrapper)wrapper));
        if (ObjectUtils.isEmpty((Object)((Object)entity))) {
            msg.append("\u6307\u6807\u4e0d\u5b58\u5728\uff1b");
            throw new BusinessException("\u6307\u6807\u4e0d\u5b58\u5728");
        }
    }
}

