/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.price;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.PriceSettingFieldEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.price.MdmPriceSettingImportVo;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.price.mapper.MdmPriceConditionGroupMapper;
import com.biz.crm.mdm.price.mapper.MdmPriceConditionGroupRelFieldMapper;
import com.biz.crm.mdm.price.mapper.MdmPriceConditionTypeMapper;
import com.biz.crm.mdm.price.mapper.MdmPriceSettingMapper;
import com.biz.crm.mdm.price.model.MdmPriceConditionGroupEntity;
import com.biz.crm.mdm.price.model.MdmPriceConditionGroupRelFieldEntity;
import com.biz.crm.mdm.price.model.MdmPriceConditionTypeEntity;
import com.biz.crm.mdm.price.model.MdmPriceSettingEntity;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmPriceImportValidator")
public class MdmPriceImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmPriceSettingMapper, MdmPriceSettingEntity, MdmPriceSettingImportVo>
implements ExcelImportValidator<MdmPriceSettingImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceImportValidator.class);
    @Resource
    private MdmPriceConditionGroupMapper mdmPriceConditionGroupMapper;
    @Resource
    private MdmPriceConditionTypeMapper mdmPriceConditionTypeMapper;
    @Resource
    private MdmProductMapper mdmProductMapper;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Resource
    private MdmPriceConditionGroupRelFieldMapper mdmPriceConditionGroupRelFieldMapper;

    @Override
    public void validate(List<MdmPriceSettingImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validConditionGroupCode(data);
        this.validConditionTypeCode(data);
        this.validPrice(data);
        this.validDate(data);
        this.validCurrencyType(data);
        this.validProduct(data);
    }

    protected void validProduct(List<MdmPriceSettingImportVo> data) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmProductEntity::getProductCode, MdmProductEntity::getBaseUnit, MdmProductEntity::getSaleUnit, CrmBaseEntity::getEnableStatus});
        List mdmProductEntities = this.mdmProductMapper.selectList((Wrapper)wrapper);
        Map dbProductMap = Optional.ofNullable(mdmProductEntities).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).collect(Collectors.toMap(MdmProductEntity::getProductCode, Function.identity()));
        Map baseUnitMap = DictUtil.dictRevertMap((String)"product_base_unit");
        Map unitTypeMap = DictUtil.dictRevertMap((String)"unit_type");
        Map saleUnitMap = DictUtil.dictRevertMap((String)"product_sale_unit");
        for (MdmPriceSettingImportVo mdmPriceSettingImportVo : data) {
            String productCode = mdmPriceSettingImportVo.getProductCode();
            if (org.springframework.util.StringUtils.isEmpty((Object)productCode)) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
                continue;
            }
            MdmProductEntity mdmProductEntity = (MdmProductEntity)((Object)dbProductMap.get(productCode));
            if (mdmProductEntity == null) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u5546\u54c1\u7f16\u7801" + productCode + "\u4e0d\u5b58\u5728;");
                continue;
            }
            if (!CrmEnableStatusEnum.ENABLE.getCode().equals(mdmProductEntity.getEnableStatus())) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u5546\u54c1\u7f16\u7801" + productCode + "\u88ab\u7981\u7528;");
                continue;
            }
            String unitType = mdmPriceSettingImportVo.getUnitType();
            if (org.springframework.util.StringUtils.isEmpty((Object)unitType)) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u5355\u4f4d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;");
                continue;
            }
            if (unitTypeMap == null) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u6570\u636e\u5b57\u5178unit_type\u4e0d\u5b58\u5728;");
                continue;
            }
            if (!unitTypeMap.containsKey(unitType)) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u5355\u4f4d\u7c7b\u578b" + unitType + "\u5728\u6570\u636e\u5b57\u5178unit_type\u4e2d\u4e0d\u5b58\u5728;");
                continue;
            }
            String priceUnit = mdmPriceSettingImportVo.getPriceUnit();
            if (org.springframework.util.StringUtils.isEmpty((Object)priceUnit)) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u4ef7\u683c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a;");
                continue;
            }
            String unitTypeKey = (String)unitTypeMap.get(unitType);
            if ("baseUnit".equals(unitTypeKey)) {
                if (baseUnitMap == null) {
                    mdmPriceSettingImportVo.appendErrorValidateMsg("\u6570\u636e\u5b57\u5178product_base_unit\u4e0d\u5b58\u5728;");
                    continue;
                }
                String basePriceUnit = (String)baseUnitMap.get(priceUnit);
                if (org.springframework.util.StringUtils.isEmpty((Object)basePriceUnit)) {
                    mdmPriceSettingImportVo.appendErrorValidateMsg(priceUnit + "\u5728\u6570\u636e\u5b57\u5178product_base_unit\u4e0d\u5b58\u5728;");
                    continue;
                }
                String baseUnit = mdmProductEntity.getBaseUnit();
                if (basePriceUnit.equals(baseUnit)) continue;
                mdmPriceSettingImportVo.appendErrorValidateMsg(priceUnit + "\u5728\u5546\u54c1" + productCode + "\u4e0d\u5b58\u5728;");
                continue;
            }
            if ("saleUnit".equals(unitTypeKey)) {
                if (saleUnitMap == null) {
                    mdmPriceSettingImportVo.appendErrorValidateMsg("\u6570\u636e\u5b57\u5178product_sale_unit\u4e0d\u5b58\u5728;");
                    continue;
                }
                String salePriceUnit = (String)saleUnitMap.get(priceUnit);
                if (org.springframework.util.StringUtils.isEmpty((Object)salePriceUnit)) {
                    mdmPriceSettingImportVo.appendErrorValidateMsg(priceUnit + "\u5728\u6570\u636e\u5b57\u5178product_sale_unit\u4e0d\u5b58\u5728;");
                    continue;
                }
                String saleUnit = mdmProductEntity.getSaleUnit();
                if (salePriceUnit.equals(saleUnit)) continue;
                mdmPriceSettingImportVo.appendErrorValidateMsg(priceUnit + "\u5728\u5546\u54c1" + productCode + "\u4e0d\u5b58\u5728;");
                continue;
            }
            mdmPriceSettingImportVo.appendErrorValidateMsg("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5b57\u5178\u7c7b\u578b:" + unitType + ";");
        }
    }

    protected void validCurrencyType(List<MdmPriceSettingImportVo> data) {
        Map map = DictUtil.dictRevertMap((String)"currency_type");
        for (MdmPriceSettingImportVo mdmPriceSettingImportVo : data) {
            String currencyType = mdmPriceSettingImportVo.getCurrencyType();
            if (org.springframework.util.StringUtils.isEmpty((Object)currencyType)) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a;");
                continue;
            }
            if (map == null) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u5e01\u79cd\u6570\u636e\u5b57\u5178currency_type\u4e0d\u5b58\u5728;");
                continue;
            }
            if (map.containsKey(currencyType)) continue;
            mdmPriceSettingImportVo.appendErrorValidateMsg("\u5e01\u79cd:" + currencyType + "\u5728\u6570\u636e\u5b57\u5178currency_type\u4e0d\u5b58\u5728");
        }
    }

    protected void validDate(List<MdmPriceSettingImportVo> data) {
        for (MdmPriceSettingImportVo mdmPriceSettingImportVo : data) {
            String beginDate = mdmPriceSettingImportVo.getBeginDate();
            if (org.springframework.util.StringUtils.isEmpty((Object)beginDate)) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a;");
                continue;
            }
            String endDate = mdmPriceSettingImportVo.getEndDate();
            if (org.springframework.util.StringUtils.isEmpty((Object)endDate)) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a;");
                continue;
            }
            if (!this.verifyDateFormat(beginDate, "yyyy-MM-dd")) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u5e94\u8be5\u4e3ayyyy-MM-dd");
            }
            if (!this.verifyDateFormat(endDate, "yyyy-MM-dd")) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u5e94\u8be5\u4e3ayyyy-MM-dd");
            }
            if (beginDate.compareTo(endDate) < 0) continue;
            mdmPriceSettingImportVo.appendErrorValidateMsg("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u6709\u6548\u5f00\u59cb\u65f6\u95f4");
        }
    }

    protected void validPrice(List<MdmPriceSettingImportVo> data) {
        for (MdmPriceSettingImportVo mdmPriceSettingImportVo : data) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)mdmPriceSettingImportVo.getPrice())) continue;
            mdmPriceSettingImportVo.appendErrorValidateMsg("\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a;");
        }
    }

    protected void validConditionTypeCode(List<MdmPriceSettingImportVo> data) {
        for (MdmPriceSettingImportVo mdmPriceSettingImportVo : data) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)mdmPriceSettingImportVo.getConditionTypeCode())) continue;
            mdmPriceSettingImportVo.appendErrorValidateMsg("\u6761\u4ef6\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmPriceConditionTypeEntity::getConditionTypeCode});
        List dbConditionTypeCodeList = this.mdmPriceConditionTypeMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !org.springframework.util.StringUtils.isEmpty((Object)x.getConditionTypeCode())).map(MdmPriceConditionTypeEntity::getConditionTypeCode).collect(Collectors.toList());
        for (MdmPriceSettingImportVo mdmPriceSettingImportVo : data) {
            String conditionTypeCode = mdmPriceSettingImportVo.getConditionTypeCode();
            if (org.springframework.util.StringUtils.isEmpty((Object)conditionTypeCode) || !CollectionUtils.isEmpty(dbConditionTypeCodeList) && dbConditionTypeCodeList.contains(conditionTypeCode)) continue;
            mdmPriceSettingImportVo.appendErrorValidateMsg("\u6761\u4ef6\u7c7b\u578b\u7f16\u7801" + conditionTypeCode + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validConditionGroupCode(List<MdmPriceSettingImportVo> data) {
        for (MdmPriceSettingImportVo mdmPriceSettingImportVo : data) {
            if (!org.springframework.util.StringUtils.isEmpty((Object)mdmPriceSettingImportVo.getConditionGroupCode())) continue;
            mdmPriceSettingImportVo.appendErrorValidateMsg("\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmPriceConditionGroupEntity::getConditionGroupCode});
        List dbConditionGroupCodeList = this.mdmPriceConditionGroupMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !org.springframework.util.StringUtils.isEmpty((Object)x.getConditionGroupCode())).map(MdmPriceConditionGroupEntity::getConditionGroupCode).collect(Collectors.toList());
        LambdaQueryWrapper fieldWrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmPriceConditionGroupRelFieldEntity::getFieldCode, MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode});
        Map collect = this.mdmPriceConditionGroupRelFieldMapper.selectList((Wrapper)fieldWrapper).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, Collectors.mapping(MdmPriceConditionGroupRelFieldEntity::getFieldCode, Collectors.toList())));
        LambdaQueryWrapper customerWrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmCustomerEntity::getCustomerCode, CrmBaseEntity::getEnableStatus});
        Map<String, String> dbCustomerMap = this.mdmCustomerMsgMapper.selectList((Wrapper)customerWrapper).stream().filter(x -> x != null && !org.springframework.util.StringUtils.isEmpty((Object)x.getCustomerCode())).collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, CrmBaseEntity::getEnableStatus));
        LambdaQueryWrapper orgWrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmOrgEntity::getOrgCode, CrmBaseEntity::getEnableStatus});
        Map<String, String> dbOrgMap = this.mdmOrgMapper.selectList((Wrapper)orgWrapper).stream().filter(x -> x != null && !org.springframework.util.StringUtils.isEmpty((Object)x.getOrgCode())).collect(Collectors.toMap(MdmOrgEntity::getOrgCode, CrmBaseEntity::getEnableStatus));
        Map channelMap = DictUtil.dictRevertMap((String)"channel");
        for (MdmPriceSettingImportVo mdmPriceSettingImportVo : data) {
            String conditionGroupCode = mdmPriceSettingImportVo.getConditionGroupCode();
            if (org.springframework.util.StringUtils.isEmpty((Object)conditionGroupCode)) continue;
            if (CollectionUtils.isEmpty(dbConditionGroupCodeList) || !dbConditionGroupCodeList.contains(conditionGroupCode)) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801" + conditionGroupCode + "\u4e0d\u5b58\u5728;");
                continue;
            }
            List fieldList = collect.get(conditionGroupCode);
            if (CollectionUtils.isEmpty(fieldList)) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801" + conditionGroupCode + "\u672a\u8bbe\u7f6e\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u63cf\u8ff0;");
            }
            String errorField = "";
            if (!fieldList.contains("orgCode") && !org.springframework.util.StringUtils.isEmpty((Object)mdmPriceSettingImportVo.getOrgCode())) {
                if (!org.springframework.util.StringUtils.isEmpty((Object)errorField)) {
                    errorField = errorField + "\u548c";
                }
                errorField = errorField + "\u7ec4\u7ec7";
            }
            if (!fieldList.contains("customerCode") && !org.springframework.util.StringUtils.isEmpty((Object)mdmPriceSettingImportVo.getCustomerCode())) {
                if (!org.springframework.util.StringUtils.isEmpty((Object)errorField)) {
                    errorField = errorField + "\u548c";
                }
                errorField = errorField + "\u5ba2\u6237";
            }
            if (!fieldList.contains("channel") && !org.springframework.util.StringUtils.isEmpty((Object)mdmPriceSettingImportVo.getChannel())) {
                if (!org.springframework.util.StringUtils.isEmpty((Object)errorField)) {
                    errorField = errorField + "\u548c";
                }
                errorField = errorField + "\u6e20\u9053";
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)errorField)) {
                mdmPriceSettingImportVo.appendErrorValidateMsg("\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801\u672a\u5305\u542b" + errorField + "\u5b57\u6bb5," + errorField + "\u5b57\u6bb5\u4e0d\u80fd\u8f93\u5165\u4fe1\u606f");
            }
            for (String field : fieldList) {
                PriceSettingFieldEnum match = PriceSettingFieldEnum.match((String)field);
                switch (match) {
                    case ORG_CODE: {
                        String orgCode = mdmPriceSettingImportVo.getOrgCode();
                        if (org.springframework.util.StringUtils.isEmpty((Object)orgCode)) {
                            mdmPriceSettingImportVo.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
                            break;
                        }
                        if (!dbOrgMap.containsKey(orgCode)) {
                            mdmPriceSettingImportVo.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801" + orgCode + "\u4e0d\u5b58\u5728;");
                            break;
                        }
                        if (CrmEnableStatusEnum.ENABLE.getCode().equals(dbOrgMap.get(orgCode))) break;
                        mdmPriceSettingImportVo.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801" + orgCode + "\u88ab\u7981\u7528;");
                        break;
                    }
                    case CUSTOMER_CODE: {
                        String customerCode = mdmPriceSettingImportVo.getCustomerCode();
                        if (org.springframework.util.StringUtils.isEmpty((Object)customerCode)) {
                            mdmPriceSettingImportVo.appendErrorValidateMsg("\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
                            break;
                        }
                        if (!dbCustomerMap.containsKey(customerCode)) {
                            mdmPriceSettingImportVo.appendErrorValidateMsg("\u5ba2\u6237\u7f16\u7801" + customerCode + "\u4e0d\u5b58\u5728;");
                            break;
                        }
                        if (CrmEnableStatusEnum.ENABLE.getCode().equals(dbCustomerMap.get(customerCode))) break;
                        mdmPriceSettingImportVo.appendErrorValidateMsg("\u5ba2\u6237\u7f16\u7801" + customerCode + "\u88ab\u7981\u7528;");
                        break;
                    }
                    case CHANNEL: {
                        String channel = mdmPriceSettingImportVo.getChannel();
                        if (org.springframework.util.StringUtils.isEmpty((Object)channel)) {
                            mdmPriceSettingImportVo.appendErrorValidateMsg("\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a;");
                            break;
                        }
                        if (channelMap == null) {
                            mdmPriceSettingImportVo.appendErrorValidateMsg("\u6570\u636e\u5b57\u5178channel\u4e0d\u5b58\u5728;");
                            break;
                        }
                        if (channelMap.containsKey(channel)) break;
                        mdmPriceSettingImportVo.appendErrorValidateMsg("\u6e20\u9053" + channel + "\u4e0d\u5b58\u5728;");
                    }
                }
            }
        }
    }

    private boolean verifyDateFormat(String dataStr, String formatStr) {
        boolean flag = false;
        if (StringUtils.isNotEmpty((String)dataStr) && StringUtils.isNotEmpty((String)formatStr)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                Date parse = sdf.parse(dataStr);
                String dateFormatStr = sdf.format(parse);
                if (dataStr.equals(dateFormatStr)) {
                    flag = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }
}

