/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.role;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.role.MdmRoleImportVo;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmRoleImportValidator")
public class MdmRoleImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmRoleMapper, MdmRoleEntity, MdmRoleImportVo>
implements ExcelImportValidator<MdmRoleImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmRoleImportValidator.class);
    @Resource
    private MdmRoleMapper mdmRoleMapper;

    @Override
    public void validate(List<MdmRoleImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validateRequired(data);
    }

    protected void validateRequired(List<MdmRoleImportVo> originList) {
        HashSet roleCodeSet = new HashSet(16);
        Set paramRoleCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getRoleCode())).map(MdmRoleImportVo::getRoleCode).collect(Collectors.toSet());
        if (!paramRoleCodeSet.isEmpty()) {
            QueryWrapper codeQueryWrapper = new QueryWrapper();
            codeQueryWrapper.in((Object)"role_code", paramRoleCodeSet);
            List paramRoleCodeEntityList = this.mdmRoleMapper.selectList((Wrapper)codeQueryWrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)paramRoleCodeEntityList)) {
                roleCodeSet.addAll(paramRoleCodeEntityList.stream().map(MdmRoleEntity::getRoleCode).collect(Collectors.toSet()));
            }
        }
        HashSet roleNameSet = new HashSet(16);
        Set paramNameCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getRoleName())).map(MdmRoleImportVo::getRoleName).collect(Collectors.toSet());
        if (!paramNameCodeSet.isEmpty()) {
            QueryWrapper nameQueryWrapper = new QueryWrapper();
            nameQueryWrapper.in((Object)"role_name", paramNameCodeSet);
            List paramRoleNameEntityList = this.mdmRoleMapper.selectList((Wrapper)nameQueryWrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)paramRoleNameEntityList)) {
                roleNameSet.addAll(paramRoleNameEntityList.stream().map(MdmRoleEntity::getRoleName).collect(Collectors.toSet()));
            }
        }
        HashMap<String, Integer> codeIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> nameIndexMap = new HashMap<String, Integer>(16);
        for (MdmRoleImportVo item2 : originList) {
            if (StringUtils.isNotEmpty((String)item2.getRoleCode())) {
                if (roleCodeSet.contains(item2.getRoleCode())) {
                    item2.appendErrorValidateMsg("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728\uff1b");
                } else if (codeIndexMap.containsKey(item2.getRoleCode())) {
                    item2.appendErrorValidateMsg("\u89d2\u8272\u7f16\u7801\u4e0e\u7b2c[" + codeIndexMap.get(item2.getRoleCode()) + "]\u884c\u91cd\u590d\uff1b");
                } else {
                    codeIndexMap.put(item2.getRoleCode(), item2.getRowIndex());
                }
            }
            if (StringUtils.isEmpty((String)item2.getRoleName())) {
                item2.appendErrorValidateMsg("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                continue;
            }
            if (roleNameSet.contains(item2.getRoleName())) {
                item2.appendErrorValidateMsg("\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff1b");
                continue;
            }
            if (nameIndexMap.containsKey(item2.getRoleName())) {
                item2.appendErrorValidateMsg("\u89d2\u8272\u540d\u79f0\u4e0e\u7b2c[" + nameIndexMap.get(item2.getRoleName()) + "]\u884c\u91cd\u590d\uff1b");
                continue;
            }
            nameIndexMap.put(item2.getRoleName(), item2.getRowIndex());
        }
    }
}

