/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.org;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.org.MdmOrgImportVo;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTreeRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component(value="mdmOrgImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmOrgImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmOrgMapper, MdmOrgEntity, MdmOrgImportVo>
implements ExcelImportSaver<MdmOrgImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgImportSaver.class);
    @Resource
    private MdmOrgMapper mdmOrgMapper;

    @Override
    public void save(List<MdmOrgImportVo> data, DefaultImportContext context) {
        log.info("\u7ec4\u7ec7\u5bfc\u5165:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            ArrayList<MdmOrgEntity> entityList = new ArrayList<MdmOrgEntity>();
            for (MdmOrgImportVo item : data) {
                if (AbstractImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()) continue;
                MdmOrgEntity copy = (MdmOrgEntity)((Object)CrmBeanUtil.copy((Object)((Object)item), MdmOrgEntity.class));
                if (StringUtils.isEmpty((String)copy.getOrgCode())) {
                    copy.setOrgCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_ORG_CODE.getCode()));
                }
                copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                copy.setRuleCode(UUID.randomUUID().toString().replace("-", ""));
                copy.setLevelNum(1);
                entityList.add(copy);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                List partition = Lists.partition(entityList, (int)50);
                for (List item : partition) {
                    this.saveBatch(item);
                }
                this.resetRuleCode();
            }
        }
    }

    private void resetRuleCode() {
        long l = System.currentTimeMillis();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u5f00\u59cb-----------");
        this.mdmOrgMapper.copyIdToRuleCode();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f16\u7801\u91cd\u7f6e\u6210id\u6210\u529f-----------");
        this.mdmOrgMapper.setNullNotExistParentCode();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u6e05\u9664\u65e0\u6548\u4e0a\u7ea7\u7f16\u7801\u6210\u529f-----------");
        List<MdmOrgTreeRespVo> orgTree = this.getOrgTreeForResetRuleCode();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u6811\u5f62\u7ed3\u6784\u6784\u5efa\u6210\u529f-----------");
        this.updateCurAndChildren2(orgTree, "", 1);
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f16\u7801\u66f4\u65b0\u6210\u529f-----------");
        OrgUtil.deleteAllCache();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f13\u5b58\u6e05\u9664\u6210\u529f-----------");
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7ed3\u675f-----------");
    }

    private void updateCurAndChildren2(List<MdmOrgTreeRespVo> list, String parentRuleCode, int curLevelNum) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            for (int i = 0; i < list.size(); ++i) {
                MdmOrgTreeRespVo item = list.get(i);
                item.setRuleCode(parentRuleCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)));
                item.setLevelNum(Integer.valueOf(curLevelNum));
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmOrgEntity::getOrgCode, (Object)item.getOrgCode())).set(CrmTreeTenEntity::getRuleCode, (Object)item.getRuleCode())).set(CrmTreeTenEntity::getLevelNum, (Object)item.getLevelNum())).update();
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)item.getChildren())) continue;
                this.updateCurAndChildren2(item.getChildren(), item.getRuleCode(), item.getLevelNum() + 1);
            }
        }
    }

    private List<MdmOrgTreeRespVo> getOrgTreeForResetRuleCode() {
        List list = this.lambdaQuery().select(new SFunction[]{BaseIdEntity::getId, MdmOrgEntity::getOrgCode, MdmOrgEntity::getParentCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            List totalList = CrmBeanUtil.copyList((List)list, MdmOrgTreeRespVo.class);
            ArrayList<MdmOrgTreeRespVo> treeList = new ArrayList<MdmOrgTreeRespVo>();
            ArrayList<Object> curLevelList = new ArrayList<Object>();
            ArrayList<Object> restList = new ArrayList<Object>();
            Set totalCodeSet = totalList.stream().map(MdmOrgTreeRespVo::getOrgCode).collect(Collectors.toSet());
            for (MdmOrgTreeRespVo item : totalList) {
                if (StringUtils.isEmpty((String)item.getParentCode()) || !totalCodeSet.contains(item.getParentCode())) {
                    treeList.add(item);
                    curLevelList.add(item);
                    continue;
                }
                restList.add(item);
            }
            while (curLevelList.size() > 0 && restList.size() > 0) {
                ArrayList<MdmOrgTreeRespVo> restTempList = new ArrayList<MdmOrgTreeRespVo>();
                ArrayList<MdmOrgTreeRespVo> curLevelTempList = new ArrayList<MdmOrgTreeRespVo>();
                Set curLevelCodeSet = curLevelList.stream().map(MdmOrgTreeRespVo::getOrgCode).collect(Collectors.toSet());
                HashMap curLevelChildrenMap = new HashMap();
                for (MdmOrgTreeRespVo mdmOrgTreeRespVo : restList) {
                    if (curLevelCodeSet.contains(mdmOrgTreeRespVo.getParentCode())) {
                        curLevelTempList.add(mdmOrgTreeRespVo);
                        ArrayList<MdmOrgTreeRespVo> childrenList = new ArrayList<MdmOrgTreeRespVo>();
                        if (curLevelChildrenMap.containsKey(mdmOrgTreeRespVo.getParentCode())) {
                            childrenList.addAll((Collection)curLevelChildrenMap.get(mdmOrgTreeRespVo.getParentCode()));
                        }
                        childrenList.add(mdmOrgTreeRespVo);
                        curLevelChildrenMap.put(mdmOrgTreeRespVo.getParentCode(), childrenList);
                        continue;
                    }
                    restTempList.add(mdmOrgTreeRespVo);
                }
                for (MdmOrgTreeRespVo mdmOrgTreeRespVo : curLevelList) {
                    if (!curLevelChildrenMap.containsKey(mdmOrgTreeRespVo.getOrgCode())) continue;
                    mdmOrgTreeRespVo.setChildren((List)curLevelChildrenMap.get(mdmOrgTreeRespVo.getOrgCode()));
                }
                curLevelList.clear();
                curLevelList.addAll(curLevelTempList);
                restList.clear();
                restList.addAll(restTempList);
            }
            return treeList;
        }
        return new ArrayList<MdmOrgTreeRespVo>();
    }
}

