/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.position;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.position.MdmPositionImportVo;
import com.biz.crm.mdm.position.entity.MdmPositionBpmRoleEntity;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.entity.MdmPositionRoleEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionBpmRoleMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionRoleMapper;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionBpmRoleRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.biz.crm.util.websocket.WebsocketUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component(value="mdmPositionImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmPositionImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmPositionMapper, MdmPositionEntity, MdmPositionImportVo>
implements ExcelImportSaver<MdmPositionImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionImportSaver.class);
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Resource
    private MdmPositionRoleMapper mdmPositionRoleMapper;
    @Resource
    private MdmPositionBpmRoleMapper mdmPositionBpmRoleMapper;
    @Autowired
    private WebsocketUtil websocketUtil;
    @Resource
    private RocketMQProducer rocketMQProducer;

    @Override
    public void save(List<MdmPositionImportVo> data, DefaultImportContext context) {
        log.info("\u804c\u4f4d\u5bfc\u5165:{}" + data.size());
        if (!CollectionUtils.isEmpty(data)) {
            String sid = context.getImportParamVo().getWebSocketClientId();
            this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u7ec4\u88c5\u4fdd\u5b58\u6570\u636e");
            ArrayList<MdmPositionEntity> entityList = new ArrayList<MdmPositionEntity>();
            ArrayList positionBpmRoleEntityList = new ArrayList();
            ArrayList positionRoleEntityList = new ArrayList();
            List<MdmPositionImportVo> collect = data.stream().filter(x -> AbstractImportVo.ProcessTypeEnum.SUCCESS == x.getProcessType()).collect(Collectors.toList());
            this.generatePositionName(collect);
            for (MdmPositionImportVo item : collect) {
                MdmPositionEntity copy = (MdmPositionEntity)((Object)CrmBeanUtil.copy((Object)((Object)item), MdmPositionEntity.class));
                copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                copy.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                copy.setRuleCode(UUID.randomUUID().toString().replace("-", ""));
                copy.setLevelNum(1);
                entityList.add(copy);
                if (StringUtils.isNotEmpty((String)item.getRoleCode())) {
                    positionRoleEntityList.addAll(Arrays.stream(item.getRoleCode().split(",")).map(x -> {
                        MdmPositionRoleEntity positionRoleEntity = new MdmPositionRoleEntity();
                        positionRoleEntity.setPositionCode(copy.getPositionCode());
                        positionRoleEntity.setRoleCode((String)x);
                        return positionRoleEntity;
                    }).collect(Collectors.toList()));
                }
                if (!StringUtils.isNotEmpty((String)item.getBpmRoleCode())) continue;
                positionBpmRoleEntityList.addAll(Arrays.stream(item.getBpmRoleCode().split(",")).map(x -> {
                    MdmPositionBpmRoleEntity positionRoleEntity = new MdmPositionBpmRoleEntity();
                    positionRoleEntity.setPositionCode(copy.getPositionCode());
                    positionRoleEntity.setBpmRoleCode((String)x);
                    return positionRoleEntity;
                }).collect(Collectors.toList()));
            }
            this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u7ec4\u88c5\u4fdd\u5b58\u6570\u636e");
            this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e");
            if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                List partition = Lists.partition(entityList, (int)50);
                this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u5f00\u59cb\u4fdd\u5b58\u804c\u4f4d");
                for (Object item : partition) {
                    this.saveBatch((Collection)item);
                    this.sendPositionAdd(CrmBeanUtil.copyList((List)item, MdmPositionRespVo.class));
                }
                this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u7ed3\u675f\u4fdd\u5b58\u804c\u4f4d===>" + entityList.size());
                this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u5f00\u59cb\u4fdd\u5b58\u804c\u4f4d\u5173\u8054\u89d2\u8272");
                if (CollectionUtil.listNotEmptyNotSizeZero(positionRoleEntityList)) {
                    for (Object item : positionRoleEntityList) {
                        this.mdmPositionRoleMapper.insert(item);
                    }
                }
                this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u7ed3\u675f\u4fdd\u5b58\u804c\u4f4d\u5173\u8054\u89d2\u8272===>" + positionRoleEntityList.size());
                this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u5f00\u59cb\u4fdd\u5b58\u804c\u4f4d\u5173\u8054\u6d41\u7a0b\u89d2\u8272");
                if (CollectionUtil.listNotEmptyNotSizeZero(positionBpmRoleEntityList)) {
                    for (Object item : positionBpmRoleEntityList) {
                        this.mdmPositionBpmRoleMapper.insert(item);
                    }
                    this.sendPositionRelBpmRoleAdd(CrmBeanUtil.copyList(positionBpmRoleEntityList, MdmPositionBpmRoleRespVo.class));
                }
                this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u6570\u636e===>\u7ed3\u675f\u4fdd\u5b58\u804c\u4f4d\u5173\u8054\u6d41\u7a0b\u89d2\u8272===>" + positionBpmRoleEntityList.size());
                this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u5168\u8868\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801");
                this.resetRuleCode(sid);
                this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u5168\u8868\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801");
                this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u4fdd\u5b58\u6570\u636e");
            }
        }
    }

    private void resetRuleCode(String sid) {
        long l = System.currentTimeMillis();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u5f00\u59cb-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u5f00\u59cb");
        this.mdmPositionMapper.copyIdToRuleCode();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f16\u7801\u91cd\u7f6e\u6210id\u6210\u529f-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u7f16\u7801\u91cd\u7f6e\u6210id\u6210\u529f");
        this.mdmPositionMapper.setNullNotExistParentCode();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u6e05\u9664\u65e0\u6548\u4e0a\u7ea7\u7f16\u7801\u6210\u529f-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u6e05\u9664\u65e0\u6548\u4e0a\u7ea7\u7f16\u7801\u6210\u529f");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        wrapper.and(x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"parent_code", (Object)"")).or()).isNull((Object)"parent_code");
        });
        List list = this.mdmPositionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmPositionEntity)((Object)list.get(i))).getPositionCode(), TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), 1);
            }
        }
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f16\u7801\u91cd\u65b0\u751f\u6210\u6210\u529f-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u7f16\u7801\u91cd\u65b0\u751f\u6210\u6210\u529f");
        PositionUtil.deleteAllCache();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7f13\u5b58\u6e05\u9664\u6210\u529f-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u7f13\u5b58\u6e05\u9664\u6210\u529f");
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09_" + l + "_\u7ed3\u675f-----------");
        this.websocketUtil.sendMsg(sid, "\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801\uff08\u5bfc\u5165\uff09\u7ed3\u675f");
    }

    private void updateCurAndChildren(String positionCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).set(CrmTreeTenEntity::getRuleCode, (Object)curCode)).set(CrmTreeTenEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getParentCode, (Object)positionCode)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmPositionEntity)((Object)list.get(i))).getPositionCode(), curCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), levelNum + 1);
            }
        }
    }

    public void generatePositionName(List<MdmPositionImportVo> collect) {
        List emptyPositionNameList;
        if (collect != null && collect.size() > 0 && !(emptyPositionNameList = collect.stream().filter(x -> StringUtils.isEmpty((String)x.getPositionName())).collect(Collectors.toList())).isEmpty()) {
            Set<String> existNameSet = collect.stream().filter(x -> StringUtils.isNotEmpty((String)x.getPositionName())).map(MdmPositionImportVo::getPositionName).collect(Collectors.toSet());
            Map<String, List<MdmPositionImportVo>> groupByPositionLevelCode = emptyPositionNameList.stream().collect(Collectors.groupingBy(MdmPositionImportVo::getPositionLevelCode));
            for (Map.Entry<String, List<MdmPositionImportVo>> entry : groupByPositionLevelCode.entrySet()) {
                this.generatePositionNameGroupByPositionLevel(entry.getKey(), entry.getValue(), existNameSet);
            }
        }
    }

    public void generatePositionNameGroupByPositionLevel(String positionLevelCode, List<MdmPositionImportVo> collect, Set<String> generateNameSet) {
        Assert.hasText((String)positionLevelCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"position_level_code", (Object)positionLevelCode);
        MdmPositionLevelEntity positionLevel = (MdmPositionLevelEntity)((Object)this.mdmPositionLevelMapper.selectOne((Wrapper)wrapper));
        Assert.notNull((Object)((Object)positionLevel), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7ea7\u522b");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(positionLevel.getEnableStatus()), (String)"\u8be5\u804c\u4f4d\u7ea7\u522b\u5df2\u505c\u7528");
        Integer suffixSequence = positionLevel.getSuffixSequence();
        if (suffixSequence == null) {
            suffixSequence = 0;
        }
        HashSet positionNameSet = new HashSet(16);
        List positionList = ((LambdaQueryChainWrapper)this.lambdaQuery().like(MdmPositionEntity::getPositionName, (Object)positionLevel.getPositionLevelName())).select(new SFunction[]{MdmPositionEntity::getPositionName}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)positionList)) {
            positionNameSet.addAll(positionList.stream().map(MdmPositionEntity::getPositionName).collect(Collectors.toSet()));
        }
        for (MdmPositionImportVo item : collect) {
            suffixSequence = suffixSequence + 1;
            String positionName = positionLevel.getPositionLevelName() + "_" + suffixSequence;
            while (positionNameSet.contains(positionName) || generateNameSet.contains(positionName)) {
                suffixSequence = suffixSequence + 1;
                positionName = positionLevel.getPositionLevelName() + "_" + suffixSequence;
            }
            item.setPositionName(positionName);
            generateNameSet.add(positionName);
        }
        positionLevel.setSuffixSequence(suffixSequence);
        this.mdmPositionLevelMapper.updateById((Object)positionLevel);
    }

    protected void sendPositionAdd(List<MdmPositionRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("\u804c\u4f4d\u65b0\u589e\u53d1\u9001MQ\u6d88\u606f\uff1a{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("POSITION_ADD_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("\u804c\u4f4d\u65b0\u589e\u53d1\u9001MQ\u6d88\u606f\u6210\u529f\uff1a{}", list);
    }

    protected void sendPositionRelBpmRoleAdd(List<MdmPositionBpmRoleRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("\u804c\u4f4d\u5173\u8054\u6d41\u7a0b\u89d2\u8272\u53d1\u9001MQ\u6d88\u606f\uff1a{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("POSITION_REL_BPM_ROLE_ADD_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("\u804c\u4f4d\u5173\u8054\u6d41\u7a0b\u89d2\u8272\u53d1\u9001MQ\u6d88\u606f\u6210\u529f\uff1a{}", list);
    }
}

