/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.position;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.position.MdmPositionImportTreeVo;
import com.biz.crm.excel.vo.mdm.position.MdmPositionImportVo;
import com.biz.crm.mdm.bpmrple.entity.MdmBpmRoleEntity;
import com.biz.crm.mdm.bpmrple.mapper.MdmBpmRoleMapper;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelRoleEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelRoleMapper;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.biz.crm.util.websocket.WebsocketUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmPositionImportValidator")
public class MdmPositionImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmPositionMapper, MdmPositionEntity, MdmPositionImportVo>
implements ExcelImportValidator<MdmPositionImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionImportValidator.class);
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmBpmRoleMapper mdmBpmRoleMapper;
    @Resource
    private MdmPositionLevelRoleMapper mdmPositionLevelRoleMapper;
    @Autowired
    private WebsocketUtil websocketUtil;

    @Override
    public void validate(List<MdmPositionImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validateRequired(data, context);
    }

    protected void validateRequired(List<MdmPositionImportVo> originList, DefaultImportContext context) {
        String sid = context.getImportParamVo().getWebSocketClientId();
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u804c\u4f4d\u5bfc\u5165");
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u9884\u52a0\u8f7d\u6570\u636e");
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u9884\u52a0\u8f7d\u6570\u636e===>\u5f00\u59cb\u52a0\u8f7d\u53c2\u6570\u804c\u4f4d\u6821\u9a8c\u6570\u636e");
        HashSet positionCodeSet = new HashSet(16);
        Set paramPositionCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionCode())).map(MdmPositionImportVo::getPositionCode).collect(Collectors.toSet());
        if (!paramPositionCodeSet.isEmpty()) {
            QueryWrapper positionQuery = new QueryWrapper();
            positionQuery.in((Object)"position_code", paramPositionCodeSet);
            positionQuery.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
            List positionEntityList = this.mdmPositionMapper.selectList((Wrapper)positionQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionEntityList)) {
                positionCodeSet.addAll(positionEntityList.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toSet()));
            }
        }
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u7ed3\u675f\u52a0\u8f7d\u53c2\u6570\u804c\u4f4d\u6821\u9a8c\u6570\u636e===>" + positionCodeSet.size());
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u5f00\u59cb\u52a0\u8f7d\u804c\u4f4d\u7ea7\u522b\u548c\u804c\u4f4d\u7ea7\u522b\u5173\u8054\u89d2\u8272\u6570\u636e");
        HashSet positionLevelCodeSet = new HashSet(16);
        Map<Object, Object> positionLevelRoleSetMap = new HashMap(16);
        Map<Object, Object> relRoleCodeNameMap = new HashMap(16);
        Set paramPositionLevelCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionLevelCode())).map(MdmPositionImportVo::getPositionLevelCode).collect(Collectors.toSet());
        if (!paramPositionLevelCodeSet.isEmpty()) {
            QueryWrapper positionLevelQuery = new QueryWrapper();
            positionLevelQuery.in((Object)"position_level_code", paramPositionLevelCodeSet);
            List positionLevelEntityList = this.mdmPositionLevelMapper.selectList((Wrapper)positionLevelQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionLevelEntityList)) {
                positionLevelCodeSet.addAll(positionLevelEntityList.stream().map(MdmPositionLevelEntity::getPositionLevelCode).collect(Collectors.toSet()));
            }
            QueryWrapper positionLevelRoleQuery = new QueryWrapper();
            positionLevelRoleQuery.in((Object)"position_level_code", paramPositionLevelCodeSet);
            List positionLevelRoleEntityList = this.mdmPositionLevelRoleMapper.selectList((Wrapper)positionLevelRoleQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionLevelRoleEntityList)) {
                positionLevelRoleSetMap = positionLevelRoleEntityList.stream().collect(Collectors.groupingBy(MdmPositionLevelRoleEntity::getPositionLevelCode, Collectors.mapping(MdmPositionLevelRoleEntity::getRoleCode, Collectors.toSet())));
                QueryWrapper relRoleQuery = new QueryWrapper();
                relRoleQuery.in((Object)"role_code", (Collection)positionLevelRoleEntityList.stream().map(MdmPositionLevelRoleEntity::getRoleCode).collect(Collectors.toSet()));
                List relRoleEntityList = this.mdmRoleMapper.selectList((Wrapper)relRoleQuery);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)relRoleEntityList)) {
                    relRoleCodeNameMap = relRoleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName));
                }
            }
        }
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u7ed3\u675f\u52a0\u8f7d\u804c\u4f4d\u7ea7\u522b\u548c\u804c\u4f4d\u7ea7\u522b\u5173\u8054\u89d2\u8272\u6570\u636e===>" + positionLevelCodeSet.size());
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u5f00\u59cb\u52a0\u8f7d\u7ec4\u7ec7\u6570\u636e");
        HashSet orgCodeSet = new HashSet(16);
        Set paramOrgCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmPositionImportVo::getOrgCode).collect(Collectors.toSet());
        if (!paramOrgCodeSet.isEmpty()) {
            QueryWrapper orgQuery = new QueryWrapper();
            orgQuery.in((Object)"org_code", paramOrgCodeSet);
            List orgEntityList = this.mdmOrgMapper.selectList((Wrapper)orgQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orgEntityList)) {
                orgCodeSet.addAll(orgEntityList.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toSet()));
            }
        }
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u7ed3\u675f\u52a0\u8f7d\u7ec4\u7ec7\u6570\u636e===>" + orgCodeSet.size());
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u5f00\u59cb\u52a0\u8f7d\u4e0a\u7ea7\u804c\u4f4d\u6570\u636e");
        HashSet parentCodeSet = new HashSet(16);
        Set paramParentCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentCode())).map(MdmPositionImportVo::getParentCode).collect(Collectors.toSet());
        if (!paramParentCodeSet.isEmpty()) {
            QueryWrapper positionQuery = new QueryWrapper();
            positionQuery.in((Object)"position_code", paramParentCodeSet);
            positionQuery.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
            List positionEntityList = this.mdmPositionMapper.selectList((Wrapper)positionQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionEntityList)) {
                parentCodeSet.addAll(positionEntityList.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toSet()));
            }
        }
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u7ed3\u675f\u52a0\u8f7d\u4e0a\u7ea7\u804c\u4f4d\u6570\u636e===>" + parentCodeSet.size());
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u5f00\u59cb\u52a0\u8f7d\u89d2\u8272\u6570\u636e");
        Map<Object, Object> roleMap = new HashMap(16);
        HashSet<String> roleCodeSet = new HashSet<String>(16);
        for (MdmPositionImportVo mdmPositionImportVo : originList) {
            if (!StringUtils.isNotEmpty((String)mdmPositionImportVo.getRoleCode())) continue;
            roleCodeSet.addAll(Arrays.asList(mdmPositionImportVo.getRoleCode().split(",")));
        }
        if (!roleCodeSet.isEmpty()) {
            QueryWrapper roleQuery = new QueryWrapper();
            roleQuery.in((Object)"role_code", roleCodeSet);
            List roleEntityList = this.mdmRoleMapper.selectList((Wrapper)roleQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)roleEntityList)) {
                roleMap = roleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName));
            }
        }
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u7ed3\u675f\u52a0\u8f7d\u89d2\u8272\u6570\u636e===>" + roleMap.size());
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u5f00\u59cb\u52a0\u8f7d\u6d41\u7a0b\u89d2\u8272\u6570\u636e");
        Map<Object, Object> bpmRoleMap = new HashMap(16);
        HashSet<String> bpmRoleCodeSet = new HashSet<String>(16);
        for (MdmPositionImportVo mdmPositionImportVo : originList) {
            if (!StringUtils.isNotEmpty((String)mdmPositionImportVo.getBpmRoleCode())) continue;
            bpmRoleCodeSet.addAll(Arrays.asList(mdmPositionImportVo.getBpmRoleCode().split(",")));
        }
        if (!bpmRoleCodeSet.isEmpty()) {
            QueryWrapper bpmRoleQuery = new QueryWrapper();
            bpmRoleQuery.in((Object)"bpm_role_code", bpmRoleCodeSet);
            List bpmRoleEntityList = this.mdmBpmRoleMapper.selectList((Wrapper)bpmRoleQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)bpmRoleEntityList)) {
                bpmRoleMap = bpmRoleEntityList.stream().collect(Collectors.toMap(MdmBpmRoleEntity::getBpmRoleCode, MdmBpmRoleEntity::getBpmRoleName));
            }
        }
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u7ed3\u675f\u52a0\u8f7d\u6d41\u7a0b\u89d2\u8272\u6570\u636e===>" + bpmRoleMap.size());
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u5f00\u59cb\u52a0\u8f7d\u7ec4\u7ec7\u4e0a\u7ea7\u5173\u7cfb\u6570\u636e");
        ConcurrentHashMap<String, Map<String, String>> positionParentOrgMap = new ConcurrentHashMap<String, Map<String, String>>(16);
        Set collect = originList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getParentCode()) && StringUtils.isNotEmpty((String)x.getOrgCode())).map(MdmPositionImportVo::getParentCode).collect(Collectors.toSet());
        if (!collect.isEmpty()) {
            positionParentOrgMap.putAll(this.findAllParentOrgCodeListOfPositionParentList(new ArrayList<String>(collect)));
        }
        this.websocketUtil.sendMsg(sid, "\u9884\u52a0\u8f7d\u6570\u636e===>\u7ed3\u675f\u52a0\u8f7d\u7ec4\u7ec7\u4e0a\u7ea7\u5173\u7cfb\u6570\u636e===>" + positionParentOrgMap.size());
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u9884\u52a0\u8f7d\u6570\u636e");
        HashMap<String, Integer> positionCodeIndexMap = new HashMap<String, Integer>(16);
        int i = 1;
        int total = originList.size();
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u7b2c\u4e00\u6b21\u904d\u5386");
        for (MdmPositionImportVo item2 : originList) {
            Map map;
            String[] split;
            if (StringUtils.isEmpty((String)item2.getPositionCode())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u804c\u4f4d\u7f16\u7801\uff1b");
            } else if (positionCodeSet.contains(item2.getPositionCode())) {
                item2.appendErrorValidateMsg("\u804c\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff1b");
            } else if (positionCodeIndexMap.containsKey(item2.getPositionCode())) {
                item2.appendErrorValidateMsg("\u804c\u4f4d\u7f16\u7801\u4e0e\u7b2c" + positionCodeIndexMap.get(item2.getPositionCode()) + "\u884c\u91cd\u590d\uff1b");
            } else {
                positionCodeIndexMap.put(item2.getPositionCode(), item2.getRowIndex());
            }
            if (StringUtils.isEmpty((String)item2.getPositionLevelCode())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\uff1b");
            } else if (!positionLevelCodeSet.contains(item2.getPositionLevelCode())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u5b58\u5728\uff1b");
            }
            if (StringUtils.isEmpty((String)item2.getOrgCode())) {
                item2.appendErrorValidateMsg("\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801\uff1b");
            } else if (!orgCodeSet.contains(item2.getOrgCode())) {
                item2.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801\u65e0\u6548\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item2.getRoleCode())) {
                for (String roleCode : split = item2.getRoleCode().split(",")) {
                    if (roleMap.containsKey(roleCode)) continue;
                    item2.appendErrorValidateMsg("\u6743\u9650\u89d2\u8272\u7f16\u7801[" + roleCode + "]\u65e0\u6548\uff1b");
                }
            } else if (AbstractImportVo.ProcessTypeEnum.SUCCESS == item2.getProcessType() && positionLevelRoleSetMap.containsKey(item2.getPositionLevelCode())) {
                HashSet<String> codeList = new HashSet<String>(16);
                Set codeSet = (Set)positionLevelRoleSetMap.get(item2.getPositionLevelCode());
                if (!codeSet.isEmpty()) {
                    Iterator iterator = codeSet.iterator();
                    while (iterator.hasNext()) {
                        String roleCode = (String)iterator.next();
                        if (!relRoleCodeNameMap.containsKey(roleCode)) continue;
                        codeList.add(roleCode);
                    }
                    item2.setRoleCode(String.join((CharSequence)",", codeList));
                }
            }
            if (StringUtils.isNotEmpty((String)item2.getBpmRoleCode())) {
                split = item2.getBpmRoleCode().split(",");
                for (String bpmRoleCode : split) {
                    if (bpmRoleMap.containsKey(bpmRoleCode)) continue;
                    item2.appendErrorValidateMsg("\u6d41\u7a0b\u89d2\u8272\u7f16\u7801[" + (String)bpmRoleCode + "]\u65e0\u6548\uff1b");
                }
            }
            if (StringUtils.isNotEmpty((String)item2.getOrgCode()) && StringUtils.isNotEmpty((String)item2.getParentCode()) && positionParentOrgMap.containsKey(item2.getParentCode()) && (map = (Map)positionParentOrgMap.get(item2.getParentCode())).containsKey(item2.getOrgCode())) {
                item2.appendErrorValidateMsg("\u7ec4\u7ec7[" + item2.getOrgCode() + "]\u5c5e\u4e8e\u8be5\u884c\u4e0a\u7ea7\u804c\u4f4d[" + item2.getParentCode() + "]\uff08\u53ca\u4e0a\u7ea7\u804c\u4f4d\uff09\u7684\u7ec4\u7ec7\uff08\u53ca\u4e0a\u7ea7\uff09\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u5f53\u524d\u804c\u4f4d\u7684\u7ec4\u7ec7\uff1b");
            }
            this.websocketUtil.sendMsg(sid, "\u7b2c\u4e00\u6b21\u904d\u5386\uff0c\u5b8c\u6210" + i++ + "\u6761\uff0c\u5171" + total + "\u6761");
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u7b2c\u4e00\u6b21\u904d\u5386===>" + total);
        List<MdmPositionImportTreeVo> treeList = originList.stream().map(x -> {
            MdmPositionImportTreeVo treeVo = new MdmPositionImportTreeVo();
            treeVo.setPositionCode(x.getPositionCode());
            treeVo.setOrgCode(x.getOrgCode());
            treeVo.setParentCode(x.getParentCode());
            treeVo.setSuccess(AbstractImportVo.ProcessTypeEnum.SUCCESS == x.getProcessType());
            treeVo.setRowIndex(x.getRowIndex());
            return treeVo;
        }).collect(Collectors.toList());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u6784\u5efa\u6811\u5f62\u7ed3\u6784\u7528\u4e8e\u6821\u9a8c\u4e0a\u4e0b\u7ea7");
        HashSet<String> set = new HashSet<String>(16);
        List<MdmPositionImportTreeVo> tree = this.generateTreeByParentCode(treeList, set);
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u6784\u5efa\u6811\u5f62\u7ed3\u6784");
        HashMap<Integer, String> errorMsgMap = new HashMap<Integer, String>(16);
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u6821\u9a8c\u804c\u4f4d\u4e0a\u4e0b\u7ea7\u5173\u8054\u5173\u7cfb");
        for (MdmPositionImportTreeVo node : tree) {
            if (StringUtils.isNotEmpty((String)node.getParentCode()) && !parentCodeSet.contains(node.getParentCode())) {
                node.setSuccess(false);
                errorMsgMap.put(node.getRowIndex(), "\u4e0a\u7ea7\u7f16\u7801\u65e0\u6548");
            }
            if (!CollectionUtil.listNotEmptyNotSizeZero(node.getChildren())) continue;
            this.setCheckChildren(node, node.getChildren(), errorMsgMap);
        }
        for (MdmPositionImportVo item3 : originList) {
            if (StringUtils.isNotEmpty((String)item3.getPositionCode()) && !set.contains(item3.getPositionCode())) {
                item3.appendErrorValidateMsg("\u5f53\u524d\u6570\u636e\u7684\u4e0a\u4e0b\u7ea7\u53ef\u80fd\u6784\u6210\u73af\u72b6\u7ed3\u6784\uff1b");
            }
            if (!errorMsgMap.containsKey(item3.getRowIndex())) continue;
            item3.appendErrorValidateMsg((String)errorMsgMap.get(item3.getRowIndex()));
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u6821\u9a8c\u804c\u4f4d\u4e0a\u4e0b\u7ea7\u5173\u8054\u5173\u7cfb");
    }

    protected Map<String, Map<String, String>> findAllParentOrgCodeListOfPositionParentList(List<String> positionCodeList) {
        ConcurrentHashMap<String, Map<String, String>> map = new ConcurrentHashMap<String, Map<String, String>>(16);
        QueryWrapper positionQuery = new QueryWrapper();
        positionQuery.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        positionQuery.in((Object)"position_code", positionCodeList);
        List positionEntityList = this.mdmPositionMapper.selectList((Wrapper)positionQuery);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)positionEntityList)) {
            positionEntityList.forEach(position -> {
                Set parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes((String)position.getRuleCode());
                if (!parentRuleCodes.isEmpty()) {
                    Set parentRuleCodesExcludeSelf;
                    Set orgCodeSet;
                    QueryWrapper positionParentQuery = new QueryWrapper();
                    positionParentQuery.in((Object)"rule_code", (Collection)parentRuleCodes);
                    List parentPositionList = this.mdmPositionMapper.selectList((Wrapper)positionParentQuery);
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)parentPositionList) && !(orgCodeSet = parentPositionList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmPositionEntity::getOrgCode).collect(Collectors.toSet())).isEmpty() && !(parentRuleCodesExcludeSelf = TreeRuleCodeUtil.splitParentRuleCodesExcludeSelf(new ArrayList(orgCodeSet))).isEmpty()) {
                        QueryWrapper orgQuery = new QueryWrapper();
                        orgQuery.in((Object)"rule_code", (Collection)parentRuleCodesExcludeSelf);
                        List orgEntityList = this.mdmOrgMapper.selectList((Wrapper)orgQuery);
                        if (CollectionUtil.listNotEmptyNotSizeZero((List)orgEntityList)) {
                            map.put(position.getPositionCode(), orgEntityList.stream().collect(Collectors.toMap(MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName)));
                        }
                    }
                }
            });
        }
        return map;
    }

    protected List<MdmPositionImportTreeVo> generateTreeByParentCode(List<MdmPositionImportTreeVo> totalList, Set<String> set) {
        ArrayList<MdmPositionImportTreeVo> treeList = new ArrayList<MdmPositionImportTreeVo>();
        ArrayList<MdmPositionImportTreeVo> curLevelList = new ArrayList<MdmPositionImportTreeVo>();
        ArrayList<MdmPositionImportTreeVo> restList = new ArrayList<MdmPositionImportTreeVo>();
        Map<String, MdmPositionImportTreeVo> totalMap = totalList.stream().collect(Collectors.toMap(MdmPositionImportTreeVo::getPositionCode, v -> v));
        for (MdmPositionImportTreeVo item : totalList) {
            if (StringUtils.isEmpty((String)item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                curLevelList.add(item);
                set.add(item.getPositionCode());
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<MdmPositionImportTreeVo> restTempList = new ArrayList<MdmPositionImportTreeVo>();
            ArrayList<MdmPositionImportTreeVo> curLevelTempList = new ArrayList<MdmPositionImportTreeVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(MdmPositionImportTreeVo::getPositionCode, MdmPositionImportTreeVo::getPositionCode));
            HashMap curLevelChildrenMap = new HashMap();
            for (MdmPositionImportTreeVo item : restList) {
                if (curLevelMap.containsKey(item.getParentCode())) {
                    curLevelTempList.add(item);
                    ArrayList<MdmPositionImportTreeVo> childrenList = new ArrayList<MdmPositionImportTreeVo>();
                    if (curLevelChildrenMap.containsKey(item.getParentCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(item.getParentCode()));
                    }
                    set.add(item.getPositionCode());
                    childrenList.add(item);
                    curLevelChildrenMap.put(item.getParentCode(), childrenList);
                    continue;
                }
                restTempList.add(item);
            }
            for (MdmPositionImportTreeVo item : curLevelList) {
                if (!curLevelChildrenMap.containsKey(item.getPositionCode())) continue;
                item.setChildren((List)curLevelChildrenMap.get(item.getPositionCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }

    protected void setCheckChildren(MdmPositionImportTreeVo node, List<MdmPositionImportTreeVo> children, Map<Integer, String> errorMsg) {
        for (MdmPositionImportTreeVo child : children) {
            if (node.isSuccess()) continue;
            child.setSuccess(false);
            errorMsg.put(child.getRowIndex(), "\u4e0a\u7ea7\u6821\u9a8c\u672a\u901a\u8fc7");
            if (!CollectionUtil.listNotEmptyNotSizeZero(child.getChildren())) continue;
            this.setCheckChildren(child, child.getChildren(), errorMsg);
        }
    }
}

