/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.terminal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalImportVo;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.region.entity.MdmRegionEntity;
import com.biz.crm.mdm.region.mapper.MdmRegionMapper;
import com.biz.crm.mdm.terminal.entity.MdmTerminalEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalROrgMapper;
import com.biz.crm.nebular.mdm.constant.RegionLevelEnum;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.websocket.WebsocketUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmTerminalImportValidator")
public class MdmTerminalImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmTerminalMapper, MdmTerminalEntity, MdmTerminalImportVo>
implements ExcelImportValidator<MdmTerminalImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalImportValidator.class);
    private String phone = "^[1]+[3,8]+\\d{9}$";
    private final String NUM_REGEX = "^[0-9]*$";
    @Resource
    private MdmTerminalMapper mdmTerminalMapper;
    @Resource
    private MdmTerminalROrgMapper mdmTerminalROrgMapper;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;
    @Resource
    private MdmRegionMapper mdmRegionMapper;
    @Autowired
    private WebsocketUtil websocketUtil;

    @Override
    public void validate(List<MdmTerminalImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validTerminalName(data, context);
        this.validTerminalCode(data, context);
        this.validOrgCode(data, context);
        this.validCustomerOrg(data);
        this.validChannel(data);
        this.validTerminalType(data);
        this.validRegion(data);
        this.validPhone(data);
    }

    protected void validPhone(List<MdmTerminalImportVo> data) {
        for (MdmTerminalImportVo mdmTerminalImportVo : data) {
            if (StringUtils.isEmpty((Object)mdmTerminalImportVo.getContactPhone()) || mdmTerminalImportVo.getContactPhone().matches("^[0-9]*$")) continue;
            mdmTerminalImportVo.appendErrorValidateMsg("\u8054\u7cfb\u4eba\u7535\u8bdd\u4ec5\u80fd\u8f93\u5165\u6570\u5b57;");
        }
    }

    protected void validRegion(List<MdmTerminalImportVo> data) {
        LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmRegionEntity::getRegionLevel, new Object[]{RegionLevelEnum.PROVINCE.getCode(), RegionLevelEnum.CITY.getCode(), RegionLevelEnum.COUNTY.getCode()})).select(new SFunction[]{MdmRegionEntity::getRegionCode, MdmRegionEntity::getRegionName, MdmRegionEntity::getRegionLevel, MdmRegionEntity::getParentCode});
        List regionList = this.mdmRegionMapper.selectList((Wrapper)wrapper);
        Map<String, String> provinceRevertMap = regionList.stream().filter(x -> RegionLevelEnum.PROVINCE.getCode().equals(x.getRegionLevel())).collect(Collectors.toMap(MdmRegionEntity::getRegionName, MdmRegionEntity::getRegionCode, (x1, x2) -> x1));
        Map<String, List<MdmRegionEntity>> cityGroupMap = regionList.stream().filter(x -> RegionLevelEnum.CITY.getCode().equals(x.getRegionLevel()) && !StringUtils.isEmpty((Object)x.getParentCode())).collect(Collectors.groupingBy(MdmRegionEntity::getParentCode));
        Map<String, Map> provinceCityRevertMap = cityGroupMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().collect(Collectors.toMap(MdmRegionEntity::getRegionName, MdmRegionEntity::getRegionCode, (x1, x2) -> x1))));
        Map<String, List<MdmRegionEntity>> countyGroupMap = regionList.stream().filter(x -> RegionLevelEnum.COUNTY.getCode().equals(x.getRegionLevel()) && !StringUtils.isEmpty((Object)x.getParentCode())).collect(Collectors.groupingBy(MdmRegionEntity::getParentCode));
        Map<String, Map> cityCountyRevertMap = countyGroupMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().collect(Collectors.toMap(MdmRegionEntity::getRegionName, MdmRegionEntity::getRegionCode, (x1, x2) -> x1))));
        for (MdmTerminalImportVo item : data) {
            if (StringUtils.isEmpty((Object)item.getProvinceName())) continue;
            if (provinceRevertMap.containsKey(item.getProvinceName())) {
                String provinceCode = provinceRevertMap.get(item.getProvinceName());
                item.setProvinceCode(provinceCode);
                if (StringUtils.isEmpty((Object)item.getCityName())) continue;
                Map cityMap = provinceCityRevertMap.get(provinceCode);
                if (cityMap != null && cityMap.containsKey(item.getCityName())) {
                    String cityCode = (String)cityMap.get(item.getCityName());
                    item.setCityCode(cityCode);
                    if (StringUtils.isEmpty((Object)item.getDistrictName())) continue;
                    Map countyMap = cityCountyRevertMap.get(cityCode);
                    if (countyMap != null && countyMap.containsKey(item.getDistrictName())) {
                        item.setDistrictCode((String)countyMap.get(cityCode));
                        continue;
                    }
                    item.appendErrorValidateMsg("\u533a\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                item.appendErrorValidateMsg("\u5e02\u4e0d\u5b58\u5728\uff1b");
                continue;
            }
            item.appendErrorValidateMsg("\u7701\u4e0d\u5b58\u5728\uff1b");
        }
    }

    protected void validProvince(List<MdmTerminalImportVo> data) {
        LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MdmRegionEntity::getRegionLevel, (Object)1)).select(new SFunction[]{MdmRegionEntity::getRegionName});
        Set set = this.mdmRegionMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getRegionName())).map(MdmRegionEntity::getRegionName).collect(Collectors.toSet());
        for (MdmTerminalImportVo mdmTerminalImportVo : data) {
            if (StringUtils.isEmpty((Object)mdmTerminalImportVo.getProvinceCode()) || set.contains(mdmTerminalImportVo.getProvinceCode())) continue;
            mdmTerminalImportVo.appendErrorValidateMsg("\u7701\u4e0d\u5b58\u5728;");
        }
    }

    protected void validCity(List<MdmTerminalImportVo> data) {
        LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MdmRegionEntity::getRegionLevel, (Object)2)).select(new SFunction[]{MdmRegionEntity::getRegionName});
        Set set = this.mdmRegionMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getRegionName())).map(MdmRegionEntity::getRegionName).collect(Collectors.toSet());
        for (MdmTerminalImportVo mdmTerminalImportVo : data) {
            if (StringUtils.isEmpty((Object)mdmTerminalImportVo.getCityCode()) || set.contains(mdmTerminalImportVo.getCityCode())) continue;
            mdmTerminalImportVo.appendErrorValidateMsg("\u5e02\u4e0d\u5b58\u5728;");
        }
    }

    protected void validDistrict(List<MdmTerminalImportVo> data) {
        LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MdmRegionEntity::getRegionLevel, (Object)3)).select(new SFunction[]{MdmRegionEntity::getRegionName});
        Set set = this.mdmRegionMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getRegionName())).map(MdmRegionEntity::getRegionName).collect(Collectors.toSet());
        for (MdmTerminalImportVo mdmTerminalImportVo : data) {
            if (StringUtils.isEmpty((Object)mdmTerminalImportVo.getDistrictCode()) || set.contains(mdmTerminalImportVo.getDistrictCode())) continue;
            mdmTerminalImportVo.appendErrorValidateMsg("\u533a\u4e0d\u5b58\u5728;");
        }
    }

    protected void validChannel(List<MdmTerminalImportVo> data) {
        Map map = DictUtil.dictMap((String)"channel");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmTerminalImportVo mdmTerminalImportVo : data) {
            String channel = mdmTerminalImportVo.getChannel();
            if (StringUtils.isEmpty((Object)channel)) {
                mdmTerminalImportVo.appendErrorValidateMsg("\u6e20\u9053\u6ca1\u6709\u586b\u5199;");
                continue;
            }
            if (channelMap.containsKey(channel)) continue;
            mdmTerminalImportVo.appendErrorValidateMsg("\u6e20\u9053:" + channel + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validTerminalType(List<MdmTerminalImportVo> data) {
        Map map = DictUtil.dictMap((String)"terminal_type");
        HashMap terminalTypeMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (terminalTypeMap.containsKey(entry.getValue())) continue;
            terminalTypeMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmTerminalImportVo mdmTerminalImportVo : data) {
            String terminalType = mdmTerminalImportVo.getTerminalType();
            if (StringUtils.isEmpty((Object)terminalType)) {
                mdmTerminalImportVo.appendErrorValidateMsg("\u7ec8\u7aef\u7c7b\u578b\u6ca1\u6709\u586b\u5199;");
                continue;
            }
            if (terminalTypeMap.containsKey(terminalType)) continue;
            mdmTerminalImportVo.appendErrorValidateMsg("\u7ec8\u7aef\u7c7b\u578b:" + terminalType + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validCustomerOrg(List<MdmTerminalImportVo> data) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmCusOrgEntity::getCustomerOrgCode});
        Set dbCustomerOrgCodeSet = this.mdmCusOrgMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getCustomerOrgCode())).map(MdmCusOrgEntity::getCustomerOrgCode).collect(Collectors.toSet());
        for (MdmTerminalImportVo mdmTerminalImportVo : data) {
            String customerOrgCode = mdmTerminalImportVo.getCustomerOrgCode();
            if (StringUtils.isEmpty((Object)customerOrgCode)) {
                mdmTerminalImportVo.appendErrorValidateMsg("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u6ca1\u6709\u586b\u5199;");
                continue;
            }
            if (!CollectionUtils.isEmpty(dbCustomerOrgCodeSet) && dbCustomerOrgCodeSet.contains(customerOrgCode)) continue;
            mdmTerminalImportVo.appendErrorValidateMsg("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801:" + customerOrgCode + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validOrgCode(List<MdmTerminalImportVo> data, DefaultImportContext context) {
        String sid = context.getImportParamVo().getWebSocketClientId();
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u6821\u9a8c\u7ec4\u7ec7\u7f16\u7801");
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmOrgEntity::getOrgCode});
        Set dbOrgCodeSet = this.mdmOrgMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getOrgCode())).map(MdmOrgEntity::getOrgCode).collect(Collectors.toSet());
        for (MdmTerminalImportVo mdmTerminalImportVo : data) {
            String orgCode = mdmTerminalImportVo.getOrgCode();
            if (StringUtils.isEmpty((Object)orgCode)) {
                mdmTerminalImportVo.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801\u6ca1\u6709\u586b\u5199;");
                continue;
            }
            if (orgCode.contains(",")) {
                String[] currentOrgCodeList;
                for (String currentOrgCode : currentOrgCodeList = orgCode.split(",")) {
                    if (!CollectionUtils.isEmpty(dbOrgCodeSet) && dbOrgCodeSet.contains(currentOrgCode)) continue;
                    mdmTerminalImportVo.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801" + currentOrgCode + "\u4e0d\u5b58\u5728;");
                }
                continue;
            }
            if (!CollectionUtils.isEmpty(dbOrgCodeSet) && dbOrgCodeSet.contains(orgCode)) continue;
            mdmTerminalImportVo.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801:" + orgCode + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validTerminalCode(List<MdmTerminalImportVo> data, DefaultImportContext context) {
        String sid = context.getImportParamVo().getWebSocketClientId();
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u6821\u9a8c\u7ec8\u7aef\u7f16\u7801");
        Set collect = data.stream().filter(item -> !StringUtils.isEmpty((Object)item.getTerminalCode())).map(MdmTerminalImportVo::getTerminalCode).collect(Collectors.toSet());
        if (collect.isEmpty()) {
            return;
        }
        HashSet materialCodeSet = new HashSet();
        ArrayList list = new ArrayList(collect);
        List lists = Lists.partition(list, (int)500);
        for (List item2 : lists) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmTerminalEntity::getTerminalCode});
            wrapper.in(MdmTerminalEntity::getTerminalCode, (Collection)item2);
            Set materialCodeSetTemp = this.mdmTerminalMapper.selectList((Wrapper)wrapper).stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toSet());
            materialCodeSet.addAll(materialCodeSetTemp);
        }
        HashMap<String, Integer> codeIndexMap = new HashMap<String, Integer>(16);
        for (MdmTerminalImportVo item3 : data) {
            if (StringUtils.isEmpty((Object)item3.getTerminalCode())) continue;
            if (materialCodeSet.contains(item3.getTerminalCode())) {
                item3.appendErrorValidateMsg("\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728\uff1b");
                continue;
            }
            if (codeIndexMap.containsKey(item3.getTerminalCode())) {
                item3.appendErrorValidateMsg("\u7ec8\u7aef\u7f16\u7801\u4e0e\u7b2c" + item3.getTerminalCode() + "\u884c\u91cd\u590d\uff1b");
                continue;
            }
            codeIndexMap.put(item3.getTerminalCode(), item3.getRowIndex());
        }
    }

    protected void validTerminalName(List<MdmTerminalImportVo> data, DefaultImportContext context) {
        String sid = context.getImportParamVo().getWebSocketClientId();
        this.websocketUtil.sendMsg(sid, "\u6821\u9a8c\u7ec8\u7aef\u540d\u79f0\u548c\u7ec8\u7aef\u5730\u5740");
        for (MdmTerminalImportVo mdmTerminalVo : data) {
            if (StringUtils.isEmpty((Object)mdmTerminalVo.getTerminalName())) {
                mdmTerminalVo.appendErrorValidateMsg("\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (!StringUtils.isEmpty((Object)mdmTerminalVo.getTerminalAddress())) continue;
            mdmTerminalVo.appendErrorValidateMsg("\u7ec8\u7aef\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a;");
        }
    }
}

