/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.sfa;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaIndexImportVo;
import com.biz.crm.sfa.test.entity.SfaIndexEntity;
import com.biz.crm.sfa.test.mapper.SfaIndexMapper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component(value="sfaIndexValidator")
public class SfaIndexValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<SfaIndexMapper, SfaIndexEntity, SfaIndexImportVo>
implements ExcelImportValidator<SfaIndexImportVo> {
    private static final Logger log = LoggerFactory.getLogger(SfaIndexValidator.class);
    @Autowired
    private SfaIndexMapper indexMapper;

    @Override
    public void validate(List<SfaIndexImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        data.forEach(v -> {
            StringBuilder msg = new StringBuilder();
            if (StringUtils.isBlank((CharSequence)v.getIndexCode())) {
                msg.append("\u6307\u6807\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (StringUtils.isBlank((CharSequence)v.getIndexName())) {
                msg.append("\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            this.doCheckIndex(v.getIndexCode(), v.getIndexName(), msg);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.errorMsgAndSendWebsocket(v, msg.toString(), context);
            }
        });
    }

    public void doCheckIndex(String indexCode, String indexName, StringBuilder msg) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"index_code", (Object)indexCode)).eq((Object)"index_name", (Object)indexName);
        SfaIndexEntity entity = (SfaIndexEntity)((Object)this.indexMapper.selectOne((Wrapper)wrapper));
        if (!ObjectUtils.isEmpty((Object)((Object)entity))) {
            msg.append("\u5df2\u5b58\u5728\u7684\u6307\u6807;");
        }
    }
}

