/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.availablelistrule;

import com.biz.crm.eunm.dms.AvailableListRuleEunm;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.availablelistrule.AvailableRuleImportVo;
import com.biz.crm.mdm.availablelistrule.AvailableListRuleFeign;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="availableRuleValidator")
public class AvailableRuleValidator
implements ExcelImportValidator<AvailableRuleImportVo> {
    @Resource
    private AvailableListRuleFeign availableListRuleFeign;

    @Override
    public void validate(List<AvailableRuleImportVo> data, DefaultImportContext context) {
        Set<String> codes = data.stream().collect(Collectors.groupingBy(AvailableRuleImportVo::getCode)).keySet();
        Map exists = (Map)this.availableListRuleFeign.findExistByCodes((List)Lists.newArrayList(codes)).getResult();
        data.forEach(d -> {
            if (StringUtils.isEmpty((String)d.getCode())) {
                d.appendErrorValidateMsg("\u53ef\u8d2d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (AvailableRuleImportVo da : data) {
                if (da == d || !Objects.equals(da.getCode(), d.getCode())) continue;
                d.appendErrorValidateMsg("\u53ef\u8d2d\u89c4\u5219\u7f16\u7801\uff1a\u3010".concat(d.getCode()).concat("\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5"));
                break;
            }
            if (exists.get(d.getCode()) != null && ((Boolean)exists.get(d.getCode())).booleanValue()) {
                d.appendErrorValidateMsg("\u53ef\u8d2d\u7f16\u7801\u3010".concat(d.getCode()).concat("\u3011\u5df2\u5b58\u5728"));
            }
            AvailableListRuleEunm.Dimension dimension = AvailableListRuleEunm.Dimension.getByCode((Integer)d.getDimension());
            switch (dimension) {
                case CUS: {
                    if (StringUtils.isEmpty((String)d.getCusCode())) {
                        d.appendErrorValidateMsg("\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u5ba2\u6237\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((String)d.getCusName())) {
                        d.appendErrorValidateMsg("\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u5ba2\u6237\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    d.setOrgCode(null);
                    d.setOrgName(null);
                    d.setTerminalCode(null);
                    d.setTerminalName(null);
                    d.setTerminalChannelCode(null);
                    d.setTerminalChannelName(null);
                    d.setTerminalOrgCode(null);
                    d.setTerminalOrgName(null);
                    break;
                }
                case CUSORG: {
                    if (StringUtils.isEmpty((String)d.getOrgCode())) {
                        d.appendErrorValidateMsg("\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u5ba2\u6237\u7ec4\u7ec7\u65f6\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((String)d.getOrgName())) {
                        d.appendErrorValidateMsg("\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u5ba2\u6237\u7ec4\u7ec7\u65f6\uff0c\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    d.setCusCode(null);
                    d.setOrgName(null);
                    d.setCusChannelCode(null);
                    d.setCusChannelName(null);
                    d.setTerminalCode(null);
                    d.setTerminalName(null);
                    d.setTerminalChannelCode(null);
                    d.setTerminalChannelName(null);
                    d.setTerminalOrgCode(null);
                    d.setTerminalOrgName(null);
                    break;
                }
                case TERMINAL: {
                    if (StringUtils.isEmpty((String)d.getTerminalCode())) {
                        d.appendErrorValidateMsg("\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u7ec8\u7aef\u65f6\uff0c\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((String)d.getTerminalName())) {
                        d.appendErrorValidateMsg("\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u7ec8\u7aef\u65f6\uff0c\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    d.setCusCode(null);
                    d.setCusName(null);
                    d.setCusChannelCode(null);
                    d.setCusChannelName(null);
                    d.setOrgCode(null);
                    d.setOrgName(null);
                    d.setTerminalOrgCode(null);
                    d.setTerminalOrgName(null);
                    break;
                }
                case TERMINALORG: {
                    if (StringUtils.isEmpty((String)d.getTerminalOrgCode())) {
                        d.appendErrorValidateMsg("\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u7ec8\u7aef\u7ec4\u7ec7\u65f6\uff0c\u7ec8\u7aef\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((String)d.getTerminalOrgName())) {
                        d.appendErrorValidateMsg("\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u7ec8\u7aef\u7ec4\u7ec7\u65f6\uff0c\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    d.setCusCode(null);
                    d.setCusName(null);
                    d.setCusChannelCode(null);
                    d.setCusChannelName(null);
                    d.setOrgCode(null);
                    d.setOrgName(null);
                    d.setTerminalCode(null);
                    d.setTerminalName(null);
                    d.setTerminalChannelCode(null);
                    d.setTerminalChannelName(null);
                    break;
                }
            }
            if (CommonConstant.GLOBAL.YesOrNo.Y.getItemCode().equals(d.getProductLevelFlag())) {
                if (StringUtils.isEmpty((String)d.getProductLevelCode())) {
                    d.appendErrorValidateMsg("\u5546\u54c1\u7c7b\u578b\u4e3a\u5546\u54c1\u5c42\u7ea7\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((String)d.getProductLevelName())) {
                    d.appendErrorValidateMsg("\u5546\u54c1\u7c7b\u578b\u4e3a\u5546\u54c1\u5c42\u7ea7\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                d.setGoodsCode(null);
                d.setGoodsName(null);
            } else {
                if (StringUtils.isEmpty((String)d.getGoodsCode())) {
                    d.appendErrorValidateMsg("\u5546\u54c1\u7c7b\u578b\u4e3a\u5546\u54c1\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((String)d.getGoodsName())) {
                    d.appendErrorValidateMsg("\u5546\u54c1\u7c7b\u578b\u4e3a\u5546\u54c1\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                d.setProductLevelCode(null);
                d.setProductLevelName(null);
            }
        });
    }
}

