/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.export.extend.head.sfa;

import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="sfa_attendance_monthly_attendanceExportHeadExtend")
public class MonthSignExportHeadExtend
implements ExportHeadExtend {
    private static final Logger log = LoggerFactory.getLogger(MonthSignExportHeadExtend.class);
    private static final String day = "day";
    private static final String month = "month";
    private static final String year = "year";

    @Override
    public List<MdmColumnExportRespVo> getHeads(ExportHeadExtend.ExportHeadExtendParam headExtendParam) throws BusinessException {
        Map dataRow = headExtendParam.getDataRow();
        ArrayList columnExportRespVos = Lists.newArrayList();
        LocalDate date = this.getDate(dataRow);
        if (null == date) {
            int dayOfMonth = 31;
            this.buildColumn(dayOfMonth, columnExportRespVos);
            return columnExportRespVos;
        }
        LocalDate now = LocalDate.now();
        int dayOfMonth = now.getYear() == date.getYear() && now.getMonthValue() == date.getMonthValue() ? now.getDayOfMonth() : date.getMonth().maxLength();
        this.buildColumn(dayOfMonth, columnExportRespVos);
        return columnExportRespVos;
    }

    private void buildColumn(int dayOfMonth, List<MdmColumnExportRespVo> columnExportRespVos) {
        for (int i = 1; i <= dayOfMonth; ++i) {
            MdmColumnExportRespVo columnExportRespVo = new MdmColumnExportRespVo();
            columnExportRespVo.setField(day + i);
            columnExportRespVo.setTitle(String.valueOf(i));
            columnExportRespVos.add(columnExportRespVo);
        }
    }

    private LocalDate getDate(Map dataRow) {
        try {
            String year = (String)dataRow.get(year);
            String month = (String)dataRow.get(month);
            if (month.length() == 1) {
                month = "0" + month;
            }
            month = month + "-01";
            return LocalDate.parse(year + "-" + month);
        }
        catch (Exception e) {
            log.error("\u6ca1\u6709\u5e74\u6708\u6570\u636e", (Throwable)e);
            return null;
        }
    }
}

