/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.terminal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalSupplyDetailImportVo;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.entity.MdmProductLevelEntity;
import com.biz.crm.mdm.product.mapper.MdmProductLevelMapper;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.mdm.terminal.entity.MdmTerminalSupplyEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalSupplyMapper;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmTerminalSupplyDetailImportValidator")
public class MdmTerminalSupplyDetailImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmTerminalSupplyMapper, MdmTerminalSupplyEntity, MdmTerminalSupplyDetailImportVo>
implements ExcelImportValidator<MdmTerminalSupplyDetailImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalSupplyDetailImportValidator.class);
    @Resource
    private MdmProductMapper mdmProductMapper;
    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;
    @Resource
    private MdmTerminalSupplyMapper mdmTerminalSupplyMapper;

    @Override
    public void validate(List<MdmTerminalSupplyDetailImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validDataType(data);
        this.validCode(data);
        this.validEmptyName(data);
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            if (!StringUtils.isEmpty((Object)mdmTerminalSupplyDetailImportVo.getSupplyId())) continue;
            mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyDetailImportVo.getRowIndex() + ",\u5bf9\u63a5\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        Set importSupplyIdSet = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getSupplyId())).map(MdmTerminalSupplyDetailImportVo::getSupplyId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(importSupplyIdSet)) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{BaseIdEntity::getId});
        Set dbTerminalSupplyIdSet = this.mdmTerminalSupplyMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getId())).map(BaseIdEntity::getId).collect(Collectors.toSet());
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            String supplyId = mdmTerminalSupplyDetailImportVo.getSupplyId();
            if (StringUtils.isEmpty((Object)supplyId) || !CollectionUtils.isEmpty(dbTerminalSupplyIdSet) && dbTerminalSupplyIdSet.contains(supplyId)) continue;
            mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyDetailImportVo.getRowIndex() + ",\u5bf9\u63a5\u4ebaid" + supplyId + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validCode(List<MdmTerminalSupplyDetailImportVo> data) {
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            if (!StringUtils.isEmpty((Object)mdmTerminalSupplyDetailImportVo.getCode())) continue;
            mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyDetailImportVo.getRowIndex() + ",\u4f9b\u8d27\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        Set importCodeSet = data.stream().filter(x -> "1".equals(x.getDataType()) || !"2".equals(x.getDataType())).filter(x -> !StringUtils.isEmpty((Object)x.getCode())).map(MdmTerminalSupplyDetailImportVo::getCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(importCodeSet)) {
            return;
        }
        LambdaQueryWrapper productWrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmProductEntity::getProductCode});
        Set dbProductCodeSet = this.mdmProductMapper.selectList((Wrapper)productWrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getProductCode())).map(MdmProductEntity::getProductCode).collect(Collectors.toSet());
        LambdaQueryWrapper productLevelWrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode});
        Set dbProductLevelCodeSet = this.mdmProductLevelMapper.selectList((Wrapper)productLevelWrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getProductLevelCode())).map(MdmProductLevelEntity::getProductLevelCode).collect(Collectors.toSet());
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            String code = mdmTerminalSupplyDetailImportVo.getCode();
            String dataType = mdmTerminalSupplyDetailImportVo.getDataType();
            if (StringUtils.isEmpty((Object)code) || !importCodeSet.contains(code)) continue;
            if ("1".equals(dataType)) {
                if (!CollectionUtils.isEmpty(dbProductCodeSet) && dbProductCodeSet.contains(code)) continue;
                mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyDetailImportVo.getRowIndex() + ",\u5546\u54c1\u7f16\u7801" + code + "\u4e0d\u5b58\u5728;");
                continue;
            }
            if (!"2".equals(dataType) || !CollectionUtils.isEmpty(dbProductLevelCodeSet) && dbProductLevelCodeSet.contains(code)) continue;
            mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyDetailImportVo.getRowIndex() + ",\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801" + code + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validEmptyName(List<MdmTerminalSupplyDetailImportVo> data) {
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            if (!StringUtils.isEmpty((Object)mdmTerminalSupplyDetailImportVo.getName())) continue;
            mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyDetailImportVo.getRowIndex() + ",\u4f9b\u8d27\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
        }
    }

    protected void validDataType(List<MdmTerminalSupplyDetailImportVo> data) {
        for (MdmTerminalSupplyDetailImportVo mdmTerminalSupplyDetailImportVo : data) {
            String dataType = mdmTerminalSupplyDetailImportVo.getDataType();
            if ("1".equals(dataType) || "2".equals(dataType)) continue;
            mdmTerminalSupplyDetailImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyDetailImportVo.getRowIndex() + ",\u7ec8\u7aef\u4f9b\u8d27\u7c7b\u578b\u4ec5\u652f\u6301\u7c7b\u578b 1: \u5546\u54c1 2\uff1a\u4ea7\u54c1\u5c42\u7ea7");
        }
    }
}

