/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.sfa.visitgroup;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaVisitGroupImportVo;
import com.biz.crm.sfa.test.entity.SfaVisitGroupEntity;
import com.biz.crm.sfa.test.mapper.SfaVisitGroupMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="sfaVisitGroupImportValidator")
public class SfaVisitGroupImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<SfaVisitGroupMapper, SfaVisitGroupEntity, SfaVisitGroupImportVo>
implements ExcelImportValidator<SfaVisitGroupImportVo> {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitGroupImportValidator.class);
    private static final String DEALER = "0";
    private static final String TERMINAL = "1";

    @Override
    public void validate(List<SfaVisitGroupImportVo> data, DefaultImportContext context) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(data)) {
            return;
        }
    }

    private void checkData(List<SfaVisitGroupImportVo> data) {
        data.forEach(da -> {
            if (StringUtils.isEmpty((String)da.getGroupName())) {
                da.appendErrorValidateMsg("\u7ebf\u8def\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)da.getPosCode())) {
                da.appendErrorValidateMsg("\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)da.getPosName())) {
                da.appendErrorValidateMsg("\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)da.getCode())) {
                da.appendErrorValidateMsg("\u7ecf\u9500\u5546/\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)da.getName())) {
                da.appendErrorValidateMsg("\u7ecf\u9500\u5546/\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)da.getType())) {
                da.appendErrorValidateMsg("\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (!da.getType().equals(DEALER) && !da.getType().equals(TERMINAL)) {
                da.appendErrorValidateMsg("\u5ba2\u6237\u7c7b\u578b\u9519\u8bef(0-\u7ecf\u9500\u5546,1-\u7ec8\u7aef)");
            }
        });
    }
}

