/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.config.OperatorInterceptor;
import com.biz.crm.data.DmsDruidParam;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(value={"com.biz.crm.dms.**.mapper*"}, sqlSessionTemplateRef="dmsSqlSessionTemplate")
public class DmsDruidConfig {
    private static final Logger log = LoggerFactory.getLogger(DmsDruidConfig.class);
    @Resource
    private DmsDruidParam dmsDruidParam;

    @Bean(value={"dmsDataSource"})
    public DataSource dmsDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.dmsDruidParam.getDbUrl());
        datasource.setUsername(this.dmsDruidParam.getUsername());
        datasource.setPassword(this.dmsDruidParam.getPassword());
        datasource.setDriverClassName(this.dmsDruidParam.getDriverClassName());
        datasource.setInitialSize(this.dmsDruidParam.getInitialSize());
        datasource.setMinIdle(this.dmsDruidParam.getMinIdle());
        datasource.setMaxActive(this.dmsDruidParam.getMaxActive());
        datasource.setMaxWait((long)this.dmsDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis((long)this.dmsDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis((long)this.dmsDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis((long)this.dmsDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(this.dmsDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(this.dmsDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(this.dmsDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(this.dmsDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(this.dmsDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(this.dmsDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(this.dmsDruidParam.getFilters());
        }
        catch (Exception e) {
            log.error("druid configuration initialization filter", (Throwable)e);
        }
        datasource.setConnectionProperties(this.dmsDruidParam.getConnectionProperties());
        return datasource;
    }

    @Bean
    public SqlSessionFactory dmsSqlSessionFactory() throws Exception {
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(this.dmsDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/dms/**/*.xml"));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new OperatorInterceptor());
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }

    @Bean(name={"dmsTransactionManager"})
    @Primary
    public DataSourceTransactionManager dmsTransactionManager() {
        return new DataSourceTransactionManager(this.dmsDataSource());
    }

    @Primary
    @Bean(name={"dmsSqlSessionTemplate"})
    public SqlSessionTemplate dmsSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(this.dmsSqlSessionFactory());
    }
}

