/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.config.OperatorInterceptor;
import com.biz.crm.data.SfaDruidParam;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(value={"com.biz.crm.sfa.**.mapper*"}, sqlSessionTemplateRef="sfaSqlSessionTemplate")
public class SfaDruidConfig {
    private static final Logger log = LoggerFactory.getLogger(SfaDruidConfig.class);
    @Resource
    private SfaDruidParam sfaDruidParam;

    @Bean(value={"sfaDataSource"})
    public DataSource sfaDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.sfaDruidParam.getDbUrl());
        datasource.setUsername(this.sfaDruidParam.getUsername());
        datasource.setPassword(this.sfaDruidParam.getPassword());
        datasource.setDriverClassName(this.sfaDruidParam.getDriverClassName());
        datasource.setInitialSize(this.sfaDruidParam.getInitialSize());
        datasource.setMinIdle(this.sfaDruidParam.getMinIdle());
        datasource.setMaxActive(this.sfaDruidParam.getMaxActive());
        datasource.setMaxWait((long)this.sfaDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis((long)this.sfaDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis((long)this.sfaDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis((long)this.sfaDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(this.sfaDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(this.sfaDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(this.sfaDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(this.sfaDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(this.sfaDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(this.sfaDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(this.sfaDruidParam.getFilters());
        }
        catch (Exception e) {
            log.error("druid configuration initialization filter", (Throwable)e);
        }
        datasource.setConnectionProperties(this.sfaDruidParam.getConnectionProperties());
        return datasource;
    }

    @Bean
    public SqlSessionFactory sfaSqlSessionFactory() throws Exception {
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(this.sfaDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/sfa/**/*.xml"));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new OperatorInterceptor());
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }

    @Bean(name={"sfaTransactionManager"})
    @Primary
    public DataSourceTransactionManager sfaTransactionManager() {
        return new DataSourceTransactionManager(this.sfaDataSource());
    }

    @Primary
    @Bean(name={"sfaSqlSessionTemplate"})
    public SqlSessionTemplate sfaSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(this.sfaSqlSessionFactory());
    }
}

