/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.dms.order;

import com.biz.crm.dms.order.DmsOrderFeign;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.dms.order.OrderGroupItemVo;
import com.biz.crm.nebular.dms.order.OrderUpdateImportVo;
import com.biz.crm.nebular.dms.order.OrderVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Component;

@Component(value="orderUpdateSaver")
public class OrderUpdateSaver
implements ExcelImportSaver<OrderUpdateImportVo> {
    private static final String DEFAULT_PICK_TYPE = "0";
    private static final int SAVE_COUNT = 20;
    @Resource
    private DmsOrderFeign dmsOrderFeign;

    @Override
    public void save(List<OrderUpdateImportVo> data, DefaultImportContext context) {
        Map<String, List<OrderUpdateImportVo>> orderMap = data.stream().collect(Collectors.groupingBy(OrderUpdateImportVo::getOrderCode));
        ArrayList orderVos = Lists.newArrayList();
        orderMap.forEach((k, v) -> {
            OrderVo order = new OrderVo();
            order.setOrderCode(k);
            List<OrderDetailVo> details = this.buildOrderDetails((List<OrderUpdateImportVo>)v);
            ArrayList orderGroupItemVos = Lists.newArrayList();
            details.forEach(detail -> {
                OrderGroupItemVo groupItemVo = new OrderGroupItemVo();
                if (OrderEunm.LineTypeEnum.getByCode((String)detail.getProductCode()) == OrderEunm.LineTypeEnum.SOURCE_PRODUCT) {
                    groupItemVo.setNormalList((List)Lists.newArrayList((Object[])new OrderDetailVo[]{detail}));
                }
                orderGroupItemVos.add(groupItemVo);
            });
            OrderGroupItemVo groupItemVo = new OrderGroupItemVo();
            ArrayList backList = Lists.newArrayList();
            details.forEach(detail -> {
                if (OrderEunm.LineTypeEnum.getByCode((String)detail.getProductCode()) == OrderEunm.LineTypeEnum.REP_PRODUCT) {
                    backList.add(detail);
                }
            });
            groupItemVo.setBackList((List)backList);
            orderGroupItemVos.add(groupItemVo);
            order.setGroupItemVos((List)orderGroupItemVos);
            orderVos.add(order);
            ArrayList vos = Lists.newArrayList();
            for (int i = 1; i <= orderVos.size(); ++i) {
                vos.add(orderVos.get(i - 1));
                if (i % 20 != 0 && i != orderVos.size()) continue;
                vos.clear();
            }
        });
    }

    private List<OrderDetailVo> buildOrderDetails(List<OrderUpdateImportVo> orderImportVos) {
        ArrayList details = Lists.newArrayList();
        int i = 0;
        for (OrderUpdateImportVo o : orderImportVos) {
            OrderDetailVo detail = new OrderDetailVo();
            detail.setProductCode(o.getProductCode());
            detail.setProductName(o.getProductName());
            detail.setProductNum(new BigDecimal(o.getCount()));
            detail.setLineNo(String.valueOf(i));
            detail.setPrice(o.getPrice());
            detail.setAmount(o.getAmount());
            detail.setId(o.getDetailId());
            detail.setLineType(o.getProductType());
            detail.setFeeCode(o.getFeeCode());
            detail.setFeeName(o.getFeeName());
            details.add(detail);
            ++i;
        }
        return details;
    }
}

