/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.bpmrole;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.bpmrole.MdmBpmRoleImportVo;
import com.biz.crm.mdm.bpmrple.entity.MdmBpmRoleEntity;
import com.biz.crm.mdm.bpmrple.mapper.MdmBpmRoleMapper;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component(value="mdmBpmRoleImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmBpmRoleImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmBpmRoleMapper, MdmBpmRoleEntity, MdmBpmRoleImportVo>
implements ExcelImportSaver<MdmBpmRoleImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmBpmRoleImportSaver.class);
    @Resource
    private RocketMQProducer rocketMQProducer;

    @Override
    public void save(List<MdmBpmRoleImportVo> data, DefaultImportContext context) {
        log.info("\u6d41\u7a0b\u89d2\u8272\u5bfc\u5165:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            ArrayList<MdmBpmRoleEntity> entityList = new ArrayList<MdmBpmRoleEntity>();
            for (MdmBpmRoleImportVo item : data) {
                if (AbstractImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()) continue;
                MdmBpmRoleEntity copy = (MdmBpmRoleEntity)((Object)CrmBeanUtil.copy((Object)((Object)item), MdmBpmRoleEntity.class));
                if (StringUtils.isEmpty((String)copy.getBpmRoleCode())) {
                    copy.setBpmRoleCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_BPM_ROLE_CODE.getCode()));
                }
                copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                entityList.add(copy);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                List partition = Lists.partition(entityList, (int)50);
                for (List item : partition) {
                    this.saveBatch(item);
                    this.sendBpmRoleAdd(CrmBeanUtil.copyList((List)item, MdmBpmRoleRespVo.class));
                }
            }
        }
    }

    protected void sendBpmRoleAdd(List<MdmBpmRoleRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("\u804c\u4f4d\u65b0\u589e\u53d1\u9001MQ\u6d88\u606f\uff1a{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("BPM_ROLE_ADD_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("\u804c\u4f4d\u65b0\u589e\u53d1\u9001MQ\u6d88\u606f\u6210\u529f\uff1a{}", list);
    }
}

