/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.customermaterial;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.customermaterial.MdmCustomerMaterialImportVo;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.mdm.material.entity.MdmMaterialEntity;
import com.biz.crm.mdm.material.mapper.MdmMaterialMapper;
import com.biz.crm.util.CollectionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmCustomerMaterialValidator")
public class MdmCustomerMaterialValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmMaterialMapper, MdmMaterialEntity, MdmCustomerMaterialImportVo>
implements ExcelImportValidator<MdmCustomerMaterialImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerMaterialValidator.class);
    @Resource
    private MdmMaterialMapper mdmMaterialMapper;
    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;

    @Override
    public void validate(List<MdmCustomerMaterialImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashMap<String, String> cusOrg = new HashMap<String, String>(16);
        Set cusOrgSet = data.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getCustomerOrgCode())).map(MdmCustomerMaterialImportVo::getCustomerOrgCode).collect(Collectors.toSet());
        if (!cusOrgSet.isEmpty()) {
            QueryWrapper cusOrgCodeUniqueQuery = new QueryWrapper();
            cusOrgCodeUniqueQuery.in((Object)"customer_org_code", cusOrgSet);
            List list = this.mdmCusOrgMapper.selectList((Wrapper)cusOrgCodeUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                for (int i = 0; i < list.size(); ++i) {
                    cusOrg.put(((MdmCusOrgEntity)((Object)list.get(i))).getCustomerOrgCode(), ((MdmCusOrgEntity)((Object)list.get(i))).getEnableStatus());
                }
            }
        }
        HashMap<String, String> material = new HashMap<String, String>(16);
        Set materialSet = data.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getMaterialCode())).map(MdmCustomerMaterialImportVo::getMaterialCode).collect(Collectors.toSet());
        if (!materialSet.isEmpty()) {
            QueryWrapper materialCodeUniqueQuery = new QueryWrapper();
            materialCodeUniqueQuery.in((Object)"material_code", materialSet);
            List list = this.mdmMaterialMapper.selectList((Wrapper)materialCodeUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                for (int i = 0; i < list.size(); ++i) {
                    material.put(((MdmMaterialEntity)((Object)list.get(i))).getMaterialCode(), ((MdmMaterialEntity)((Object)list.get(i))).getEnableStatus());
                }
            }
        }
        HashMap customerOrgCodeMap = new HashMap(16);
        HashMap materialCodeMap = new HashMap(16);
        HashMap barCodeMap = new HashMap(16);
        data.forEach(v -> {
            StringBuilder msg = new StringBuilder();
            if (StringUtils.isBlank((CharSequence)v.getCustomerOrgCode())) {
                msg.append("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            } else {
                if (!cusOrg.containsKey(v.getCustomerOrgCode())) {
                    msg.append("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801:" + v.getCustomerOrgCode() + "\u4e0d\u5b58\u5728;");
                } else if (!CrmEnableStatusEnum.ENABLE.getCode().equals(cusOrg.get(v.getCustomerOrgCode()))) {
                    msg.append("\u6240\u9009\u5ba2\u6237\u7ec4\u7ec7\u7981\u7528\u4e86;");
                }
                if (customerOrgCodeMap.containsKey(v.getCustomerOrgCode())) {
                    msg.append("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0e\u7b2c" + customerOrgCodeMap.get(v.getCustomerOrgCode()) + "\u884c\u91cd\u590d;");
                } else {
                    customerOrgCodeMap.put(v.getCustomerOrgCode(), v.getRowIndex());
                }
            }
            if (StringUtils.isBlank((CharSequence)v.getMaterialCode())) {
                msg.append("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            } else {
                if (!material.containsKey(v.getMaterialCode())) {
                    msg.append("\u7269\u6599\u7f16\u7801:" + v.getMaterialCode() + "\u4e0d\u5b58\u5728;");
                } else if (!CrmEnableStatusEnum.ENABLE.getCode().equals(material.get(v.getMaterialCode()))) {
                    msg.append("\u6240\u9009\u7269\u6599\u7981\u7528\u4e86;");
                }
                if (materialCodeMap.containsKey(v.getMaterialCode())) {
                    msg.append("\u7269\u6599\u7f16\u7801\u4e0e\u7b2c" + materialCodeMap.get(v.getMaterialCode()) + "\u884c\u91cd\u590d;");
                } else {
                    materialCodeMap.put(v.getMaterialCode(), v.getRowIndex());
                }
            }
            if (StringUtils.isBlank((CharSequence)v.getBarCode())) {
                msg.append("\u6761\u5f62\u7f16\u7801\u6ca1\u6709\u586b\u5199;");
            } else if (barCodeMap.containsKey(v.getBarCode())) {
                msg.append("\u6761\u5f62\u7801\u4e0e\u7b2c" + barCodeMap.get(v.getBarCode()) + "\u884c\u91cd\u590d;");
            } else {
                barCodeMap.put(v.getBarCode(), v.getRowIndex());
            }
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                v.appendErrorValidateMsg(msg.toString());
            }
        });
    }
}

