/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.terminal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalSupplyImportVo;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.terminal.entity.MdmTerminalEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.util.DictUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmTerminalSupplyImportValidator")
public class MdmTerminalSupplyImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmTerminalMapper, MdmTerminalEntity, MdmTerminalSupplyImportVo>
implements ExcelImportValidator<MdmTerminalSupplyImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalSupplyImportValidator.class);
    @Resource
    private MdmTerminalMapper mdmTerminalMapper;
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;

    @Override
    public void validate(List<MdmTerminalSupplyImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validTerminalCode(data);
        this.validPositionCode(data);
        this.validOrgCode(data);
        this.validCustomerCode(data);
        this.validSaleCompany(data);
        this.validChannel(data);
    }

    protected void validChannel(List<MdmTerminalSupplyImportVo> data) {
        Map map = DictUtil.dictMap((String)"channel");
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String channel = mdmTerminalSupplyImportVo.getChannel();
            if (StringUtils.isEmpty((Object)channel) || map != null && map.size() != 0 && map.get(channel) != null) continue;
            mdmTerminalSupplyImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyImportVo.getRowIndex() + "\u6570\u636e\u5b57\u5178channel:" + channel + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validSaleCompany(List<MdmTerminalSupplyImportVo> data) {
        Map map = DictUtil.dictMap((String)"sale_company");
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String saleCompany = mdmTerminalSupplyImportVo.getSaleCompany();
            if (StringUtils.isEmpty((Object)saleCompany) || map != null && map.size() != 0 && map.get(saleCompany) != null) continue;
            mdmTerminalSupplyImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyImportVo.getRowIndex() + "\u6570\u636e\u5b57\u5178sale_company:" + saleCompany + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validCustomerCode(List<MdmTerminalSupplyImportVo> data) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmCustomerEntity::getCustomerCode});
        Set dbCustomerCodeSet = this.mdmCustomerMsgMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getCustomerCode())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toSet());
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String customerCode = mdmTerminalSupplyImportVo.getCustomerCode();
            if (StringUtils.isEmpty((Object)customerCode) || !CollectionUtils.isEmpty(dbCustomerCodeSet) && dbCustomerCodeSet.contains(customerCode)) continue;
            mdmTerminalSupplyImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyImportVo.getRowIndex() + "\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728;");
        }
    }

    protected void validOrgCode(List<MdmTerminalSupplyImportVo> data) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmOrgEntity::getOrgCode});
        Set dbOrgCodeSet = this.mdmOrgMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getOrgCode())).map(MdmOrgEntity::getOrgCode).collect(Collectors.toSet());
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String orgCode = mdmTerminalSupplyImportVo.getOrgCode();
            if (StringUtils.isEmpty((Object)orgCode) || !CollectionUtils.isEmpty(dbOrgCodeSet) && dbOrgCodeSet.contains(orgCode)) continue;
            mdmTerminalSupplyImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyImportVo.getRowIndex() + "\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728;");
        }
    }

    protected void validPositionCode(List<MdmTerminalSupplyImportVo> data) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmPositionEntity::getPositionCode});
        Set dbPositionCodeList = this.mdmPositionMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getPositionCode())).map(MdmPositionEntity::getPositionCode).collect(Collectors.toSet());
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String positionCode = mdmTerminalSupplyImportVo.getPositionCode();
            if (StringUtils.isEmpty((Object)positionCode) || !CollectionUtils.isEmpty(dbPositionCodeList) && dbPositionCodeList.contains(positionCode)) continue;
            mdmTerminalSupplyImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyImportVo.getRowIndex() + "\u804c\u4f4d\u7f16\u7801\u4e0d\u5b58\u5728;");
        }
    }

    protected void validTerminalCode(List<MdmTerminalSupplyImportVo> data) {
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            if (!StringUtils.isEmpty((Object)mdmTerminalSupplyImportVo.getTerminalCode())) continue;
            mdmTerminalSupplyImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyImportVo.getRowIndex() + "\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmTerminalEntity::getTerminalCode});
        Set dbTerminalCodeSet = this.mdmTerminalMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getTerminalCode())).map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toSet());
        for (MdmTerminalSupplyImportVo mdmTerminalSupplyImportVo : data) {
            String terminalCode = mdmTerminalSupplyImportVo.getTerminalCode();
            if (StringUtils.isEmpty((Object)terminalCode) || !CollectionUtils.isEmpty(dbTerminalCodeSet) && dbTerminalCodeSet.contains(terminalCode)) continue;
            mdmTerminalSupplyImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmTerminalSupplyImportVo.getRowIndex() + "\u7ec8\u7aef\u7f16\u7801\u4e0d\u5b58\u5728;");
        }
    }
}

