/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.user;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.user.MdmUserImportTreeVo;
import com.biz.crm.excel.vo.mdm.user.MdmUserImportVo;
import com.biz.crm.mdm.bpmrple.entity.MdmBpmRoleEntity;
import com.biz.crm.mdm.bpmrple.mapper.MdmBpmRoleMapper;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.entity.MdmPositionUserEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionUserMapper;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelRoleEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelRoleMapper;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.mdm.user.entity.MdmUserEntity;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.nebular.mdm.constant.PositionOperationEnum;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.websocket.WebsocketUtil;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmUserImportValidator")
public class MdmUserImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmUserMapper, MdmUserEntity, MdmUserImportVo>
implements ExcelImportValidator<MdmUserImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmUserImportValidator.class);
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmPositionUserMapper mdmPositionUserMapper;
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmBpmRoleMapper mdmBpmRoleMapper;
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Resource
    private MdmPositionLevelRoleMapper mdmPositionLevelRoleMapper;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Autowired
    private WebsocketUtil websocketUtil;
    private final String PHONE_REGEX = "[1][\\d]{10}";

    @Override
    public void validate(List<MdmUserImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.verify(data, context);
    }

    protected void verify(List<MdmUserImportVo> originList, DefaultImportContext context) {
        String sid = context.getImportParamVo().getWebSocketClientId();
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u6821\u9a8c\u524d\u9884\u52a0\u8f7d\u51c6\u5907\u6570\u636e");
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u8d26\u53f7\u9884\u52a0\u8f7d\u6570\u636e");
        HashMap<String, String> userNameCheckMap = new HashMap<String, String>(16);
        Set paramUserNameSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getUserName())).map(MdmUserImportVo::getUserName).collect(Collectors.toSet());
        if (!paramUserNameSet.isEmpty()) {
            ArrayList list = new ArrayList(paramUserNameSet);
            List lists = Lists.partition(list, (int)500);
            for (List item2 : lists) {
                QueryWrapper userNameQuery = new QueryWrapper();
                userNameQuery.in((Object)"user_name", (Collection)item2);
                userNameQuery.select(new String[]{"user_name", "user_type"});
                List userNameQueryEntityList = this.mdmUserMapper.selectList((Wrapper)userNameQuery);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)userNameQueryEntityList)) continue;
                userNameCheckMap.putAll(userNameQueryEntityList.stream().collect(Collectors.toMap(MdmUserEntity::getUserName, MdmUserEntity::getUserType)));
            }
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u8d26\u53f7\u9884\u52a0\u8f7d\u6570\u636e===>" + paramUserNameSet.size());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u624b\u673a\u53f7\u9884\u52a0\u8f7d\u6570\u636e");
        HashSet existPhoneSet = new HashSet(16);
        Set paramPhoneSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getEmail())).map(MdmUserImportVo::getUserPhone).collect(Collectors.toSet());
        if (!paramPhoneSet.isEmpty()) {
            ArrayList list = new ArrayList(paramPhoneSet);
            List lists = Lists.partition(list, (int)500);
            for (List item3 : lists) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"user_phone", (Collection)item3);
                queryWrapper.select(new String[]{"user_phone"});
                List entityList = this.mdmUserMapper.selectList((Wrapper)queryWrapper);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) continue;
                existPhoneSet.addAll(entityList.stream().map(MdmUserEntity::getUserPhone).collect(Collectors.toList()));
            }
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u624b\u673a\u53f7\u9884\u52a0\u8f7d\u6570\u636e===>" + existPhoneSet.size());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u90ae\u7bb1\u9884\u52a0\u8f7d\u6570\u636e");
        HashSet existEmailSet = new HashSet(16);
        Set paramEmailSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getEmail())).map(MdmUserImportVo::getEmail).collect(Collectors.toSet());
        if (!paramEmailSet.isEmpty()) {
            ArrayList list = new ArrayList(paramEmailSet);
            List lists = Lists.partition(list, (int)500);
            for (List item4 : lists) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"email", (Collection)item4);
                queryWrapper.select(new String[]{"email"});
                List entityList = this.mdmUserMapper.selectList((Wrapper)queryWrapper);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) continue;
                existEmailSet.addAll(entityList.stream().map(MdmUserEntity::getEmail).collect(Collectors.toList()));
            }
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u90ae\u7bb1\u9884\u52a0\u8f7d\u6570\u636e===>" + existEmailSet.size());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u4e0a\u7ea7\u8d26\u53f7\u9884\u52a0\u8f7d\u6570\u636e");
        HashMap<String, MdmUserEntity> parentUserNameCheckMap = new HashMap<String, MdmUserEntity>(16);
        HashMap<String, MdmPositionEntity> parentUserNamePrimaryPositionMap = new HashMap<String, MdmPositionEntity>(16);
        Set paramParentUserNameSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentUserName())).map(MdmUserImportVo::getParentUserName).collect(Collectors.toSet());
        if (!paramParentUserNameSet.isEmpty()) {
            ArrayList list = new ArrayList(paramParentUserNameSet);
            List lists = Lists.partition(list, (int)500);
            for (List item5 : lists) {
                QueryWrapper userNameQuery = new QueryWrapper();
                userNameQuery.in((Object)"user_name", (Collection)item5);
                userNameQuery.select(new String[]{"user_name", "user_type", "enable_status"});
                List userNameQueryEntityList = this.mdmUserMapper.selectList((Wrapper)userNameQuery);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)userNameQueryEntityList)) continue;
                parentUserNameCheckMap.putAll(userNameQueryEntityList.stream().collect(Collectors.toMap(MdmUserEntity::getUserName, v -> v)));
                QueryWrapper positionUserQuery = new QueryWrapper();
                positionUserQuery.eq((Object)"primary_flag", (Object)YesNoEnum.yesNoEnum.ONE.getValue());
                positionUserQuery.in((Object)"user_name", (Collection)userNameQueryEntityList.stream().map(MdmUserEntity::getUserName).collect(Collectors.toSet()));
                positionUserQuery.select(new String[]{"user_name", "position_code"});
                List positionUserEntityList = this.mdmPositionUserMapper.selectList((Wrapper)positionUserQuery);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)positionUserEntityList)) continue;
                QueryWrapper positionQuery = new QueryWrapper();
                positionQuery.in((Object)"position_code", (Collection)positionUserEntityList.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toSet()));
                positionQuery.select(new String[]{"position_code", "position_name", "org_code", "enable_status"});
                Map<String, MdmPositionEntity> parentPositionMap = this.mdmPositionMapper.selectList((Wrapper)positionQuery).stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v));
                if (parentPositionMap.isEmpty()) continue;
                parentUserNamePrimaryPositionMap.putAll(positionUserEntityList.stream().filter(x -> parentPositionMap.containsKey(x.getPositionCode())).collect(Collectors.toMap(MdmPositionUserEntity::getUserName, v -> (MdmPositionEntity)((Object)((Object)parentPositionMap.get(v.getPositionCode()))))));
            }
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u4e0a\u7ea7\u8d26\u53f7\u9884\u52a0\u8f7d\u6570\u636e===>" + paramEmailSet.size());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u6027\u522b\u9884\u52a0\u8f7d\u6570\u636e");
        Map genderValueCodeMap = DictUtil.dictRevertMap((String)"gender");
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u6027\u522b\u9884\u52a0\u8f7d\u6570\u636e===>" + genderValueCodeMap.size());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u804c\u4f4d\u64cd\u4f5c\u7c7b\u578b\u9884\u52a0\u8f7d\u6570\u636e");
        Map operationValueCodeMap = DictUtil.dictRevertMap((String)"position_operation");
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u804c\u4f4d\u64cd\u4f5c\u7c7b\u578b\u9884\u52a0\u8f7d\u6570\u636e===>" + operationValueCodeMap.size());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u804c\u4f4d\u9884\u52a0\u8f7d\u6570\u636e");
        HashMap<String, MdmPositionEntity> positionMap = new HashMap<String, MdmPositionEntity>(16);
        HashMap<String, MdmPositionUserEntity> positionRelUserMap = new HashMap<String, MdmPositionUserEntity>(16);
        Set paramPositionCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPrimaryPositionCode())).map(MdmUserImportVo::getPrimaryPositionCode).collect(Collectors.toSet());
        for (MdmUserImportVo item6 : originList) {
            if (!StringUtils.isNotEmpty((String)item6.getOtherPositionCodes())) continue;
            paramPositionCodeSet.addAll(Arrays.asList(item6.getOtherPositionCodes().split(",")));
        }
        if (!paramPositionCodeSet.isEmpty()) {
            ArrayList list = new ArrayList(paramPositionCodeSet);
            List lists = Lists.partition(list, (int)500);
            for (List item7 : lists) {
                QueryWrapper primaryPositionQuery = new QueryWrapper();
                primaryPositionQuery.in((Object)"position_code", (Collection)item7);
                List primaryPositionEntityList = this.mdmPositionMapper.selectList((Wrapper)primaryPositionQuery);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)primaryPositionEntityList)) continue;
                positionMap.putAll(primaryPositionEntityList.stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v)));
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"position_code", (Collection)item7);
                positionRelUserMap.putAll(this.mdmPositionUserMapper.selectList((Wrapper)queryWrapper).stream().collect(Collectors.toMap(MdmPositionUserEntity::getPositionCode, v -> v)));
            }
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u804c\u4f4d\u9884\u52a0\u8f7d\u6570\u636e===>" + positionRelUserMap.size());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u6743\u9650\u89d2\u8272\u9884\u52a0\u8f7d\u6570\u636e");
        Set paramRoleCodeSet = originList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getRoleCode())).flatMap(x -> Arrays.stream(x.getRoleCode().split(","))).collect(Collectors.toSet());
        HashMap<String, MdmRoleEntity> roleMap = new HashMap<String, MdmRoleEntity>(16);
        if (!paramRoleCodeSet.isEmpty()) {
            QueryWrapper roleQuery = new QueryWrapper();
            roleQuery.in((Object)"role_code", paramRoleCodeSet);
            roleQuery.select(new String[]{"role_code", "role_name", "enable_status"});
            roleMap.putAll(this.mdmRoleMapper.selectList((Wrapper)roleQuery).stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, v -> v)));
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u6743\u9650\u89d2\u8272\u9884\u52a0\u8f7d\u6570\u636e===>" + roleMap.size());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u6d41\u7a0b\u89d2\u8272\u9884\u52a0\u8f7d\u6570\u636e");
        Set paramBpmRoleCodeSet = originList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getBpmRoleCode())).flatMap(x -> Arrays.stream(x.getBpmRoleCode().split(","))).collect(Collectors.toSet());
        HashMap<String, MdmBpmRoleEntity> bpmRoleMap = new HashMap<String, MdmBpmRoleEntity>(16);
        if (!paramBpmRoleCodeSet.isEmpty()) {
            QueryWrapper bpmRoleQuery = new QueryWrapper();
            bpmRoleQuery.in((Object)"bpm_role_code", paramBpmRoleCodeSet);
            bpmRoleQuery.select(new String[]{"bpm_role_code", "bpm_role_name", "enable_status"});
            bpmRoleMap.putAll(this.mdmBpmRoleMapper.selectList((Wrapper)bpmRoleQuery).stream().collect(Collectors.toMap(MdmBpmRoleEntity::getBpmRoleCode, v -> v)));
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u6d41\u7a0b\u89d2\u8272\u9884\u52a0\u8f7d\u6570\u636e===>" + bpmRoleMap.size());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u804c\u4f4d\u7ea7\u522b\u9884\u52a0\u8f7d\u6570\u636e");
        Set paramPositionLevelCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionLevelCode())).map(MdmUserImportVo::getPositionLevelCode).collect(Collectors.toSet());
        HashMap<String, MdmPositionLevelEntity> positionLevelMap = new HashMap<String, MdmPositionLevelEntity>(16);
        if (!paramPositionLevelCodeSet.isEmpty()) {
            QueryWrapper positionLevelQuery = new QueryWrapper();
            positionLevelQuery.in((Object)"position_level_code", paramPositionLevelCodeSet);
            positionLevelQuery.select(new String[]{"position_level_code", "position_level_name", "enable_status"});
            positionLevelMap.putAll(this.mdmPositionLevelMapper.selectList((Wrapper)positionLevelQuery).stream().collect(Collectors.toMap(MdmPositionLevelEntity::getPositionLevelCode, v -> v)));
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u804c\u4f4d\u7ea7\u522b\u9884\u52a0\u8f7d\u6570\u636e===>" + positionLevelMap.size());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u804c\u4f4d\u7ea7\u522b\u5173\u8054\u6743\u9650\u89d2\u8272\u9884\u52a0\u8f7d\u6570\u636e");
        Set strings = positionLevelMap.keySet();
        HashMap positionLevelRoleMap = new HashMap(16);
        if (!strings.isEmpty()) {
            QueryWrapper positionLevelRoleQuery = new QueryWrapper();
            positionLevelRoleQuery.in((Object)"position_level_code", strings);
            positionLevelRoleQuery.select(new String[]{"position_level_code", "role_code"});
            positionLevelRoleMap.putAll(this.mdmPositionLevelRoleMapper.selectList((Wrapper)positionLevelRoleQuery).stream().collect(Collectors.groupingBy(MdmPositionLevelRoleEntity::getPositionLevelCode, Collectors.mapping(MdmPositionLevelRoleEntity::getRoleCode, Collectors.toList()))));
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u804c\u4f4d\u7ea7\u522b\u5173\u8054\u6743\u9650\u89d2\u8272\u9884\u52a0\u8f7d\u6570\u636e===>" + positionLevelRoleMap.size());
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u83b7\u53d6\u4f01\u4e1a\u7ec4\u7ec7\u9884\u52a0\u8f7d\u6570\u636e");
        Set paramOrgCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmUserImportVo::getOrgCode).collect(Collectors.toSet());
        HashMap<String, MdmOrgEntity> orgMap = new HashMap<String, MdmOrgEntity>(16);
        if (!paramOrgCodeSet.isEmpty()) {
            QueryWrapper orgQuery = new QueryWrapper();
            orgQuery.in((Object)"org_code", paramOrgCodeSet);
            orgQuery.select(new String[]{"org_code", "org_name", "enable_status", "parent_code"});
            orgMap.putAll(this.mdmOrgMapper.selectList((Wrapper)orgQuery).stream().collect(Collectors.toMap(MdmOrgEntity::getOrgCode, v -> v)));
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u4f01\u4e1a\u7ec4\u7ec7\u9884\u52a0\u8f7d\u6570\u636e===>" + orgMap.size());
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u83b7\u53d6\u6821\u9a8c\u524d\u9884\u52a0\u8f7d\u51c6\u5907\u6570\u636e");
        HashMap<String, Integer> userNameIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> emailIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> phoneIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> primaryPositionIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> otherPositionIndexMap = new HashMap<String, Integer>(16);
        int count = 1;
        int total = originList.size();
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u6267\u884c\u7b2c\u4e00\u6b21\u904d\u5386\u8fdb\u884c\u5e38\u89c4\u6821\u9a8c");
        for (MdmUserImportVo item8 : originList) {
            if (StringUtils.isEmpty((String)item8.getUserName())) {
                item8.appendErrorValidateMsg("\u7f3a\u5931\u8d26\u53f7\uff1b");
            } else {
                if (userNameIndexMap.containsKey(item8.getUserName())) {
                    item8.appendErrorValidateMsg("\u8d26\u53f7\u4e0e\u7b2c" + userNameIndexMap.get(item8.getUserName()) + "\u884c\u91cd\u590d\uff1b");
                } else {
                    userNameIndexMap.put(item8.getUserName(), item8.getRowIndex());
                }
                if (userNameCheckMap.containsKey(item8.getUserName())) {
                    item8.appendErrorValidateMsg("\u8d26\u53f7\u5df2\u5b58\u5728\uff1b");
                }
            }
            if (StringUtils.isEmpty((String)item8.getFullName())) {
                item8.appendErrorValidateMsg("\u7f3a\u5931\u7528\u6237\u540d\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item8.getGenderName())) {
                if (!genderValueCodeMap.containsKey(item8.getGenderName())) {
                    item8.appendErrorValidateMsg("\u6027\u522b\u65e0\u6548\uff1b");
                } else {
                    item8.setGender((String)genderValueCodeMap.get(item8.getGenderName()));
                }
            }
            if (StringUtils.isEmpty((String)item8.getUserPassword())) {
                item8.appendErrorValidateMsg("\u7f3a\u5931\u5bc6\u7801\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item8.getUserPhone())) {
                if (existPhoneSet.contains(item8.getUserPhone())) {
                    item8.appendErrorValidateMsg("\u8054\u7cfb\u7535\u8bdd\u5df2\u5b58\u5728\uff1b");
                } else {
                    if (!item8.getUserPhone().matches("[1][\\d]{10}")) {
                        item8.appendErrorValidateMsg("\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
                    }
                    if (phoneIndexMap.containsKey(item8.getUserPhone())) {
                        item8.appendErrorValidateMsg("\u8054\u7cfb\u7535\u8bdd\u4e0e\u7b2c" + phoneIndexMap.get(item8.getUserPhone()) + "\u884c\u91cd\u590d\uff1b");
                    } else {
                        phoneIndexMap.put(item8.getUserPhone(), item8.getRowIndex());
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)item8.getEmail()) && existEmailSet.contains(item8.getEmail())) {
                item8.appendErrorValidateMsg("\u90ae\u7bb1\u5df2\u5b58\u5728\uff1b");
                if (item8.getEmail().length() - item8.getEmail().replace("@", "").length() != 1) {
                    item8.appendErrorValidateMsg("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
                }
                if (emailIndexMap.containsKey(item8.getEmail())) {
                    item8.appendErrorValidateMsg("\u90ae\u7bb1\u4e0e\u7b2c" + emailIndexMap.get(item8.getEmail()) + "\u884c\u91cd\u590d\uff1b");
                } else {
                    emailIndexMap.put(item8.getEmail(), item8.getRowIndex());
                }
            }
            if (StringUtils.isEmpty((String)item8.getStartTime())) {
                item8.appendErrorValidateMsg("\u7f3a\u5931\u751f\u6548\u65f6\u95f4\uff1b");
            } else if (!this.verifyDateFormat(item8.getStartTime(), "yyyy-MM-dd")) {
                item8.appendErrorValidateMsg("\u751f\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5\uff1b");
            }
            if (StringUtils.isEmpty((String)item8.getEndTime())) {
                item8.appendErrorValidateMsg("\u7f3a\u5931\u5931\u6548\u65f6\u95f4\uff1b");
            } else if (!this.verifyDateFormat(item8.getEndTime(), "yyyy-MM-dd")) {
                item8.appendErrorValidateMsg("\u5931\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5\uff1b");
            }
            if (StringUtils.isEmpty((String)item8.getOperationTypeName())) {
                item8.appendErrorValidateMsg("\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b\uff1b");
            } else if (!operationValueCodeMap.containsKey(item8.getOperationTypeName())) {
                item8.appendErrorValidateMsg("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5b58\u5728\uff1b");
            } else {
                item8.setOperationType((String)operationValueCodeMap.get(item8.getOperationTypeName()));
                if (PositionOperationEnum.NEW.getCode().equals(item8.getOperationType())) {
                    if (StringUtils.isEmpty((String)item8.getOrgCode())) {
                        item8.appendErrorValidateMsg("\u7f3a\u5931\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\uff1b");
                    } else if (!orgMap.containsKey(item8.getOrgCode())) {
                        item8.appendErrorValidateMsg("\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\uff1b");
                    } else if (CrmEnableStatusEnum.DISABLE.getCode().equals(((MdmOrgEntity)((Object)orgMap.get(item8.getOrgCode()))).getEnableStatus())) {
                        item8.appendErrorValidateMsg("\u7ec4\u7ec7\u5df2\u7ecf\u505c\u7528\uff1b");
                    }
                    if (StringUtils.isEmpty((String)item8.getPositionLevelCode())) {
                        item8.appendErrorValidateMsg("\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\uff1b");
                    } else if (!positionLevelMap.containsKey(item8.getPositionLevelCode())) {
                        item8.appendErrorValidateMsg("\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728\uff1b");
                    } else if (CrmEnableStatusEnum.DISABLE.getCode().equals(((MdmPositionLevelEntity)((Object)positionLevelMap.get(item8.getPositionLevelCode()))).getEnableStatus())) {
                        item8.appendErrorValidateMsg("\u804c\u4f4d\u7ea7\u522b\u5df2\u7ecf\u505c\u7528\uff1b");
                    }
                    if (StringUtils.isNotEmpty((String)item8.getRoleCode())) {
                        for (String roleCode : item8.getRoleCode().split(",")) {
                            if (!roleMap.containsKey(roleCode)) {
                                item8.appendErrorValidateMsg("\u6743\u9650\u89d2\u8272\u7f16\u7801" + roleCode + "\u4e0d\u5b58\u5728\uff1b");
                                continue;
                            }
                            if (!CrmEnableStatusEnum.DISABLE.getCode().equals(((MdmRoleEntity)((Object)roleMap.get(roleCode))).getEnableStatus())) continue;
                            item8.appendErrorValidateMsg("\u6743\u9650\u89d2\u8272\u7f16\u7801" + roleCode + "\u5df2\u505c\u7528\uff1b");
                        }
                    }
                    if (StringUtils.isNotEmpty((String)item8.getBpmRoleCode())) {
                        for (String bpmRoleCode : item8.getBpmRoleCode().split(",")) {
                            if (!bpmRoleMap.containsKey(bpmRoleCode)) {
                                item8.appendErrorValidateMsg("\u6d41\u7a0b\u89d2\u8272\u7f16\u7801" + bpmRoleCode + "\u4e0d\u5b58\u5728\uff1b");
                                continue;
                            }
                            if (!CrmEnableStatusEnum.DISABLE.getCode().equals(((MdmBpmRoleEntity)((Object)bpmRoleMap.get(bpmRoleCode))).getEnableStatus())) continue;
                            item8.appendErrorValidateMsg("\u6d41\u7a0b\u89d2\u8272\u7f16\u7801" + bpmRoleCode + "\u5df2\u505c\u7528\uff1b");
                        }
                    }
                } else if (PositionOperationEnum.HISTORY.getCode().equals(item8.getOperationType())) {
                    if (StringUtils.isEmpty((String)item8.getPrimaryPositionCode())) {
                        item8.appendErrorValidateMsg("\u7f3a\u5931\u4e3b\u804c\u4f4d\u7f16\u7801\uff1b");
                    } else {
                        if (!positionMap.containsKey(item8.getPrimaryPositionCode())) {
                            item8.appendErrorValidateMsg("\u4e3b\u804c\u4f4d\u7f16\u7801\u65e0\u6548\uff1b");
                        } else if (positionRelUserMap.containsKey(item8.getPrimaryPositionCode()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(((MdmPositionUserEntity)((Object)positionRelUserMap.get(item8.getPrimaryPositionCode()))).getPrimaryFlag())) {
                            item8.appendErrorValidateMsg("\u4e3b\u804c\u4f4d\u5df2\u7ecf\u662f\u5176\u5b83\u7528\u6237\u7684\u4e3b\u804c\u4f4d\uff1b");
                        }
                        if (primaryPositionIndexMap.containsKey(item8.getPrimaryPositionCode())) {
                            item8.appendErrorValidateMsg("\u4e3b\u804c\u4f4d\u4e0e\u7b2c" + primaryPositionIndexMap.get(item8.getPrimaryPositionCode()) + "\u884c\u4e3b\u804c\u4f4d\u91cd\u590d\uff1b");
                        } else {
                            primaryPositionIndexMap.put(item8.getPrimaryPositionCode(), item8.getRowIndex());
                        }
                        if (otherPositionIndexMap.containsKey(item8.getPrimaryPositionCode())) {
                            item8.appendErrorValidateMsg("\u4e3b\u804c\u4f4d\u5728\u7b2c" + otherPositionIndexMap.get(item8.getPrimaryPositionCode()) + "\u884c\u5df2\u5b58\u5728\uff1b");
                        }
                    }
                    if (StringUtils.isNotEmpty((String)item8.getOtherPositionCodes())) {
                        for (String positionCode : item8.getOtherPositionCodes().split(",")) {
                            if (!positionMap.containsKey(positionCode)) {
                                item8.appendErrorValidateMsg("\u804c\u4f4d\u7f16\u7801[" + positionCode + "]\u65e0\u6548\uff1b");
                            } else if (positionRelUserMap.containsKey(item8.getPrimaryPositionCode()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(((MdmPositionUserEntity)((Object)positionRelUserMap.get(item8.getPrimaryPositionCode()))).getPrimaryFlag())) {
                                item8.appendErrorValidateMsg("\u804c\u4f4d[" + positionCode + "]\u5df2\u7ecf\u662f\u5176\u5b83\u7528\u6237\u7684\u4e3b\u804c\u4f4d\uff1b");
                            }
                            if (primaryPositionIndexMap.containsKey(positionCode)) {
                                item8.appendErrorValidateMsg("\u804c\u4f4d\u7f16\u7801[" + positionCode + "]\u4e0e\u7b2c" + primaryPositionIndexMap.get(positionCode) + "\u884c\u4e3b\u804c\u4f4d\u91cd\u590d\uff1b");
                            }
                            if (otherPositionIndexMap.containsKey(positionCode)) {
                                item8.appendErrorValidateMsg("\u804c\u4f4d\u7f16\u7801[" + positionCode + "]\u5728\u7b2c" + otherPositionIndexMap.get(positionCode) + "\u884c\u5df2\u5b58\u5728\uff1b");
                                continue;
                            }
                            otherPositionIndexMap.put(positionCode, item8.getRowIndex());
                        }
                    }
                }
            }
            if (count > 1 && count % 300 == 0) {
                this.websocketUtil.sendMsg(sid, "\u7b2c\u4e00\u6b21\u904d\u5386\u5df2\u6821\u9a8c\u6570\u636e===>" + count + "\u6761\uff0c\u5171" + total + "\u6761");
            }
            ++count;
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u6267\u884c\u7b2c\u4e00\u6b21\u904d\u5386\u5e38\u89c4\u6821\u9a8c===>" + total);
        this.verifyParent(originList, context, sid, parentUserNameCheckMap, parentUserNamePrimaryPositionMap);
    }

    protected void verifyParent(List<MdmUserImportVo> originList, DefaultImportContext context, String sid, Map<String, MdmUserEntity> parentUserNameCheckMap, Map<String, MdmPositionEntity> parentUserNamePrimaryPositionMap) {
        this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u7b2c\u4e8c\u6b21\u904d\u5386\u6821\u9a8c\u4e0a\u7ea7\u7528\u6237");
        int total = originList.size();
        int count = 1;
        HashMap<String, MdmUserImportTreeVo> map = new HashMap<String, MdmUserImportTreeVo>(16);
        for (MdmUserImportVo item : originList) {
            if (StringUtils.isNotEmpty((String)item.getUserName())) {
                MdmUserImportTreeVo vo = new MdmUserImportTreeVo();
                vo.setRowIndex(item.getRowIndex());
                vo.setUserName(item.getUserName());
                vo.setParentUserName(item.getParentUserName());
                vo.setSuccess(AbstractImportVo.ProcessTypeEnum.SUCCESS == item.getProcessType());
                map.put(item.getUserName(), vo);
            }
            if (count > 1 && count % 300 == 0) {
                this.websocketUtil.sendMsg(sid, "\u7b2c\u4e8c\u6b21\u904d\u5386\u5df2\u6821\u9a8c\u6570\u636e===>\u7b2c" + count + "\u6761\uff0c\u5171" + total + "\u6761");
            }
            ++count;
        }
        for (MdmUserImportVo item : originList) {
            if (!StringUtils.isNotEmpty((String)item.getUserName()) || !PositionOperationEnum.NEW.getCode().equals(item.getOperationType()) || !StringUtils.isNotEmpty((String)item.getParentUserName())) continue;
            if (parentUserNameCheckMap.containsKey(item.getParentUserName())) {
                MdmUserEntity mdmUserEntity = parentUserNameCheckMap.get(item.getParentUserName());
                if (CrmEnableStatusEnum.DISABLE.getCode().equals(mdmUserEntity.getEnableStatus())) {
                    item.appendErrorValidateMsg("\u4e0a\u7ea7\u7528\u6237\u5df2\u505c\u7528\uff1b");
                    continue;
                }
                if (!parentUserNamePrimaryPositionMap.containsKey(item.getParentUserName())) {
                    item.appendErrorValidateMsg("\u4e0a\u7ea7\u7528\u6237\u6ca1\u6709\u4e3b\u804c\u4f4d\uff1b");
                    continue;
                }
                if (!CrmEnableStatusEnum.DISABLE.getCode().equals(parentUserNamePrimaryPositionMap.get(item.getParentUserName()).getEnableStatus())) continue;
                item.appendErrorValidateMsg("\u4e0a\u7ea7\u7528\u6237\u7684\u4e3b\u804c\u4f4d\u88ab\u505c\u7528\uff1b");
                continue;
            }
            if (map.containsKey(item.getParentUserName())) continue;
            item.appendErrorValidateMsg("\u4e0a\u7ea7\u7528\u6237\u4e0d\u5b58\u5728\uff1b");
        }
        ArrayList<MdmUserImportTreeVo> collect = new ArrayList<MdmUserImportTreeVo>(map.values());
        HashSet<String> set = new HashSet<String>(16);
        List<MdmUserImportTreeVo> tree = this.generateTree(collect, set);
        HashSet<Integer> parentErrorRowIndexSet = new HashSet<Integer>(16);
        for (MdmUserImportTreeVo node : tree) {
            if (!CollectionUtil.listNotEmptyNotSizeZero(node.getChildren())) continue;
            this.setCheckChildren(node, node.getChildren(), parentErrorRowIndexSet);
        }
        for (MdmUserImportVo item : originList) {
            if (parentErrorRowIndexSet.contains(item.getRowIndex())) {
                item.appendErrorValidateMsg("\u4e0a\u7ea7\u6821\u9a8c\u672a\u901a\u8fc7\uff1b");
            }
            if (!StringUtils.isNotEmpty((String)item.getUserName()) || set.contains(item.getUserName())) continue;
            item.appendErrorValidateMsg("\u5f53\u524d\u6570\u636e\u7684\u4e0a\u4e0b\u7ea7\u53ef\u80fd\u6784\u6210\u73af\u72b6\u7ed3\u6784\uff1b");
        }
        this.websocketUtil.sendMsg(sid, "\u7ed3\u675f\u7b2c\u4e8c\u6b21\u904d\u5386\u6821\u9a8c\u4e0a\u7ea7\u7528\u6237===>" + total);
    }

    protected void setCheckChildren(MdmUserImportTreeVo node, List<MdmUserImportTreeVo> children, Set<Integer> parentErrorRowIndexSet) {
        for (MdmUserImportTreeVo child : children) {
            if (!node.isSuccess()) {
                child.setSuccess(false);
                parentErrorRowIndexSet.add(child.getRowIndex());
            }
            if (!CollectionUtil.listNotEmptyNotSizeZero(child.getChildren())) continue;
            this.setCheckChildren(child, child.getChildren(), parentErrorRowIndexSet);
        }
    }

    private List<MdmUserImportTreeVo> generateTree(List<MdmUserImportTreeVo> totalList, Set<String> set) {
        ArrayList<MdmUserImportTreeVo> treeList = new ArrayList<MdmUserImportTreeVo>();
        ArrayList<MdmUserImportTreeVo> curLevelList = new ArrayList<MdmUserImportTreeVo>();
        ArrayList<MdmUserImportTreeVo> restList = new ArrayList<MdmUserImportTreeVo>();
        Map<String, MdmUserImportTreeVo> totalMap = totalList.stream().collect(Collectors.toMap(MdmUserImportTreeVo::getUserName, v -> v));
        for (MdmUserImportTreeVo item : totalList) {
            if (StringUtils.isEmpty((String)item.getParentUserName()) || !totalMap.containsKey(item.getParentUserName())) {
                treeList.add(item);
                set.add(item.getUserName());
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<MdmUserImportTreeVo> restTempList = new ArrayList<MdmUserImportTreeVo>();
            ArrayList<MdmUserImportTreeVo> curLevelTempList = new ArrayList<MdmUserImportTreeVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(MdmUserImportTreeVo::getUserName, MdmUserImportTreeVo::getUserName));
            HashMap curLevelChildrenMap = new HashMap();
            for (MdmUserImportTreeVo item : restList) {
                if (curLevelMap.containsKey(item.getParentUserName())) {
                    curLevelTempList.add(item);
                    ArrayList<MdmUserImportTreeVo> childrenList = new ArrayList<MdmUserImportTreeVo>();
                    if (curLevelChildrenMap.containsKey(item.getParentUserName())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(item.getParentUserName()));
                    }
                    childrenList.add(item);
                    set.add(item.getUserName());
                    curLevelChildrenMap.put(item.getParentUserName(), childrenList);
                    continue;
                }
                restTempList.add(item);
            }
            for (MdmUserImportTreeVo item : curLevelList) {
                if (!curLevelChildrenMap.containsKey(item.getUserName())) continue;
                item.setChildren((List)curLevelChildrenMap.get(item.getUserName()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }

    protected boolean verifyDateFormat(String dataStr, String formatStr) {
        boolean flag = false;
        if (StringUtils.isNotEmpty((String)dataStr) && StringUtils.isNotEmpty((String)formatStr)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                Date parse = sdf.parse(dataStr);
                String dateFormatStr = sdf.format(parse);
                if (dataStr.equals(dateFormatStr)) {
                    flag = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }
}

