/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.upload.UploadEnum;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.mdm.tableconfig.MdmFunctionSubFeign;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.upload.excel.req.ExcelExportReqVo;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.upload.excel.ExcelExportFeign;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportHelper {
    private static final Logger log = LoggerFactory.getLogger(ExportHelper.class);
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Resource
    private ExcelExportFeign excelExportFeign;
    @Resource
    private MdmFunctionSubFeign mdmFunctionSubFeign;

    public void saveExcelFile(DefaultExportContext exportContext) {
        ExcelExportReqVo excelExportReqVo = this.buildExcelExportReqVo(exportContext);
        Result result = this.excelExportFeign.saveExcelFileBackId(excelExportReqVo);
        ExcelExportReqVo reqVo = (ExcelExportReqVo)ApiResultUtil.objResult((Result)result, (boolean)true);
        String id = reqVo.getId();
        if (StringUtils.isBlank((CharSequence)id)) {
            this.sendWebsocketMsgMQ("\u4fdd\u5b58excel\u5230\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25", exportContext);
            throw new BusinessException("\u4fdd\u5b58excel\u5230\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25");
        }
        exportContext.setTaskId(reqVo.getId());
        exportContext.setTaskCode(reqVo.getFileCode());
    }

    public void processException(DefaultExportContext exportContext, String msg) {
        exportContext.setErrorInfo(msg);
        this.sendWebsocketMsgMQ(msg, exportContext);
        exportContext.setErrorInfo(msg);
        exportContext.setTaskEndTime(LocalDateTime.now());
        this.updateExcelFile(exportContext, false);
        throw new BusinessException(msg);
    }

    public void updateExcelFile(DefaultExportContext exportContext, boolean success) {
        ExcelExportReqVo excelExportReqVo = this.checkUpdateParam(exportContext, success);
        Duration duration = Duration.between(exportContext.getTaskBeginTime(), exportContext.getTaskEndTime());
        String minutes = String.valueOf(duration.toMillis());
        excelExportReqVo.setTimeSpent(minutes);
        ApiResultUtil.checkResult((Result)this.excelExportFeign.updateExcelFileById(excelExportReqVo));
    }

    private ExcelExportReqVo checkUpdateParam(DefaultExportContext exportContext, boolean success) {
        ExcelExportReqVo excelExportReqVo = new ExcelExportReqVo();
        excelExportReqVo.setId(exportContext.getTaskId());
        if (success) {
            excelExportReqVo.setFileName(exportContext.getExcelFileName());
            UploadVo uploadVo = exportContext.getUploadVo();
            excelExportReqVo.setObjectName(uploadVo.getObjectName());
            excelExportReqVo.setFilePath(uploadVo.getUrl());
            excelExportReqVo.setFileStatus(UploadEnum.fileStatus.EXPORT_SUCCESS.getVal());
        } else {
            excelExportReqVo.setRemarks(exportContext.getErrorInfo());
            excelExportReqVo.setFileStatus(UploadEnum.fileStatus.EXPORT_FAIL.getVal());
        }
        return excelExportReqVo;
    }

    private ExcelExportReqVo buildExcelExportReqVo(DefaultExportContext exportContext) {
        String excelFileName = exportContext.getFunctionName() + "_" + exportContext.getTaskCreatedTime().format(CrmDateUtils.yyyyMMddHH_mm_ss);
        exportContext.setExcelFileName(excelFileName);
        ExcelExportReqVo excelExportReqVo = new ExcelExportReqVo();
        excelExportReqVo.setExcelFileName(excelFileName);
        excelExportReqVo.setFileParam(JsonPropertyUtil.toJsonString((Object)exportContext.getExportParam()));
        excelExportReqVo.setFileSource(exportContext.getFunctionName());
        excelExportReqVo.setFileType(UploadEnum.fileType.EXPORT.getVal());
        excelExportReqVo.setWebSocketId(exportContext.getExportParam().getSid());
        excelExportReqVo.setFileStatus(UploadEnum.fileStatus.EXPORT_IN_EXECUTION.getVal());
        return excelExportReqVo;
    }

    public void sendWebsocketMsgMQ(String msg, DefaultExportContext exportContext) {
        String webSocketClientId = exportContext.getExportParam().getSid();
        if (StringUtils.isBlank((CharSequence)webSocketClientId)) {
            if (log.isInfoEnabled()) {
                log.info("\u672a\u63d0\u4ea4 websocket id\uff0c\u5ffd\u7565 websocket \u6d88\u606f\u53d1\u9001\uff01");
            }
            return;
        }
        final JSONObject requestParam = new JSONObject();
        requestParam.put("sid", (Object)webSocketClientId);
        requestParam.put("websocketMessage", (Object)msg);
        RocketMQMessageBody body = new RocketMQMessageBody(){
            {
                this.setTag("WEBSOCKET_SESSION");
                this.setMsgBody(JSONObject.toJSONString((Object)requestParam));
            }
        };
        this.rocketMQProducer.convertAndSend(body);
    }

    public void sendWebsocketMsgMQ(String msg, String sid) {
        if (StringUtils.isBlank((CharSequence)sid)) {
            if (log.isInfoEnabled()) {
                log.info("\u672a\u63d0\u4ea4 websocket id\uff0c\u5ffd\u7565 websocket \u6d88\u606f\u53d1\u9001\uff01");
            }
            return;
        }
        final JSONObject requestParam = new JSONObject();
        requestParam.put("sid", (Object)sid);
        requestParam.put("websocketMessage", (Object)msg);
        RocketMQMessageBody body = new RocketMQMessageBody(){
            {
                this.setTag("WEBSOCKET_SESSION");
                this.setMsgBody(JSONObject.toJSONString((Object)requestParam));
            }
        };
        this.rocketMQProducer.convertAndSend(body);
    }

    public void delTask(String msg, final DefaultExportContext exportContext) {
        this.sendWebsocketMsgMQ(msg, exportContext);
        ExcelExportReqVo reqVo = new ExcelExportReqVo(){
            {
                this.setIds(Lists.newArrayList((Object[])new String[]{exportContext.getTaskId()}));
            }
        };
        ApiResultUtil.checkResult((Result)this.excelExportFeign.delete(reqVo));
    }
}

