/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.tenantrydirectstore;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectstore.KmsTenantryDirectStoreImportVo;
import com.biz.crm.kms.tenantrydirectstore.entity.KmsTenantryDirectStoreEntity;
import com.biz.crm.kms.tenantrydirectstore.mapper.KmsTenantryDirectStoreMapper;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="kmsTenantryDirectStoreValidator")
public class KmsTenantryDirectStoreValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsTenantryDirectStoreMapper, KmsTenantryDirectStoreEntity, KmsTenantryDirectStoreImportVo>
implements ExcelImportValidator<KmsTenantryDirectStoreImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectStoreValidator.class);
    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;

    @Override
    public void validate(List<KmsTenantryDirectStoreImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet deduplicationStrings = Sets.newHashSet();
        data.forEach(x -> {
            if (StringUtils.isNotBlank((CharSequence)x.getBsDirectSystemCode()) && StringUtils.isNotBlank((CharSequence)x.getStoreCode()) && StringUtils.isNotBlank((CharSequence)x.getTerminalCode())) {
                if (deduplicationStrings.contains(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode())) {
                    throw new BusinessException(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode() + "\u884c\u7684\u6570\u636e\u91cd\u590d");
                }
                deduplicationStrings.add(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode());
            }
        });
        if (CollectionUtils.isEmpty((Collection)deduplicationStrings)) {
            return;
        }
        List<KmsTenantryDirectStoreEntity> entities = this.kmsTenantryDirectStoreMapper.findList();
        HashSet duplicationStringsByDb = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getBsDirectSystemCode()) && StringUtils.isNotBlank((CharSequence)x.getStoreCode()) && StringUtils.isNotBlank((CharSequence)x.getTerminalCode())) {
                    duplicationStringsByDb.add(x.getBsDirectSystemCode() + x.getStoreCode() + x.getTerminalCode());
                }
            });
        }
        deduplicationStrings.retainAll(duplicationStringsByDb);
        if (CollectionUtils.isNotEmpty((Collection)deduplicationStrings)) {
            throw new BusinessException(((Object)deduplicationStrings).toString() + "\u884c\u7684\u6570\u636e\u91cd\u590d");
        }
    }
}

