/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.price;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.component.saver.mdm.price.MdmPriceSettingServiceHelper;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.price.MdmPriceSettingImportVo;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.price.mapper.MdmPriceSettingMapper;
import com.biz.crm.mdm.price.model.MdmPriceSettingEntity;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmPriceImportSavor")
@Transactional(value="mdmTransactionManager")
public class MdmPriceImportSavor<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmPriceSettingMapper, MdmPriceSettingEntity, MdmPriceSettingImportVo>
implements ExcelImportSaver<MdmPriceSettingImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceImportSavor.class);
    @Resource
    private MdmPriceSettingServiceHelper mdmPriceSettingServiceHelper;
    @Resource
    private MdmProductMapper mdmProductMapper;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;

    @Override
    public void save(List<MdmPriceSettingImportVo> data, DefaultImportContext context) {
        if (!CollectionUtils.isEmpty(data)) {
            Map channelMap = DictUtil.dictRevertMap((String)"channel");
            Map currencyTypeMap = DictUtil.dictRevertMap((String)"currency_type");
            Map baseUnitMap = DictUtil.dictRevertMap((String)"product_base_unit");
            Map unitTypeMap = DictUtil.dictRevertMap((String)"unit_type");
            Map saleUnitMap = DictUtil.dictRevertMap((String)"product_sale_unit");
            LambdaQueryWrapper productWrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmProductEntity::getProductCode, MdmProductEntity::getProductName});
            Map<String, String> productMap = this.mdmProductMapper.selectList((Wrapper)productWrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getProductCode())).collect(Collectors.toMap(MdmProductEntity::getProductCode, MdmProductEntity::getProductName));
            LambdaQueryWrapper customerWrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName});
            Map<String, String> customerMap = this.mdmCustomerMsgMapper.selectList((Wrapper)customerWrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getCustomerCode())).collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName));
            LambdaQueryWrapper orgWrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName});
            Map<String, String> orgMap = this.mdmOrgMapper.selectList((Wrapper)orgWrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getOrgCode())).collect(Collectors.toMap(MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName));
            for (MdmPriceSettingImportVo datum : data) {
                datum.setCurrencyType((String)currencyTypeMap.get(datum.getCurrencyType()));
                MdmPriceSettingReqVo reqVo = (MdmPriceSettingReqVo)CrmBeanUtil.copy((Object)((Object)datum), MdmPriceSettingReqVo.class);
                reqVo.setChannelName(datum.getChannel());
                reqVo.setChannel((String)channelMap.get(datum.getChannel()));
                reqVo.setCurrencyType(datum.getCurrencyType());
                String unitType = (String)unitTypeMap.get(reqVo.getUnitType());
                reqVo.setUnitType(unitType);
                reqVo.setPriceName(datum.getPriceUnit());
                if ("baseUnit".equals(unitType)) {
                    reqVo.setPriceUnit((String)baseUnitMap.get(datum.getPriceUnit()));
                } else {
                    reqVo.setPriceUnit((String)saleUnitMap.get(datum.getPriceUnit()));
                }
                reqVo.setProductName(productMap.get(datum.getProductCode()));
                reqVo.setOrgName(orgMap.get(datum.getOrgCode()));
                reqVo.setCustomerName(productMap.get(datum.getCustomerCode()));
                reqVo.setBeginDateSecond("00:00:00");
                reqVo.setEndDateSecond("00:00:00");
                reqVo.setPrice(new BigDecimal(datum.getPrice()));
                List<MdmPriceSettingEntity> mdmPriceSettingEntities = this.mdmPriceSettingServiceHelper.dataUniqueSaveOrUpdate(reqVo);
                if (CollectionUtils.isEmpty(mdmPriceSettingEntities)) continue;
                this.saveOrUpdateBatch(mdmPriceSettingEntities);
            }
        }
    }
}

