/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.terminal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalContactImportVo;
import com.biz.crm.mdm.terminal.entity.MdmTerminalContactEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalContactMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmTerminalContactImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmTerminalContactImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmTerminalContactMapper, MdmTerminalContactEntity, MdmTerminalContactImportVo>
implements ExcelImportSaver<MdmTerminalContactImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalContactImportSaver.class);
    @Resource
    private MdmTerminalContactMapper mdmTerminalContactMapper;

    @Override
    public void save(List<MdmTerminalContactImportVo> data, DefaultImportContext context) {
        if (!CollectionUtils.isEmpty(data)) {
            LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MdmTerminalContactEntity::getContactMain, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).select(new SFunction[]{MdmTerminalContactEntity::getTerminalCode});
            Set dbTerminalCodeMainSet = this.mdmTerminalContactMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getTerminalCode())).map(MdmTerminalContactEntity::getTerminalCode).collect(Collectors.toSet());
            List collect = data.stream().collect(Collectors.groupingBy(MdmTerminalContactImportVo::getTerminalCode, Collectors.collectingAndThen(Collectors.toList(), x -> {
                String terminalCode = ((MdmTerminalContactImportVo)((Object)((Object)x.get(0)))).getTerminalCode();
                if (CollectionUtils.isEmpty((Collection)dbTerminalCodeMainSet) || !dbTerminalCodeMainSet.contains(terminalCode)) {
                    long count = x.stream().filter(k -> !StringUtils.isEmpty((Object)k.getContactMain()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(k.getContactMain())).count();
                    if (count != 1L) {
                        x = x.stream().peek(k -> k.setContactMain(YesNoEnum.yesNoEnum.ZERO.getValue())).collect(Collectors.toList());
                        ((MdmTerminalContactImportVo)((Object)((Object)x.get(0)))).setContactMain(YesNoEnum.yesNoEnum.ONE.getValue());
                    }
                } else {
                    x = x.stream().peek(k -> k.setContactMain(YesNoEnum.yesNoEnum.ZERO.getValue())).collect(Collectors.toList());
                }
                return x;
            }))).values().stream().filter(x -> !CollectionUtils.isEmpty((Collection)x)).flatMap(Collection::stream).collect(Collectors.toList());
            List partition = Lists.partition(collect, (int)50);
            for (List mdmTerminalContactImportVos : partition) {
                this.saveBatch(CrmBeanUtil.copyList((List)mdmTerminalContactImportVos, MdmTerminalContactEntity.class));
            }
        }
    }
}

