/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.websocket.config;

import com.biz.crm.websocket.interceptor.WebSocketInterceptor;
import com.biz.crm.websocket.user.endpoint.UserWebSocketHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
@EnableWebSocket
public class WebSocketConfig
implements WebSocketConfigurer {
    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry.addHandler((WebSocketHandler)new UserWebSocketHandler(), new String[]{"/websocket/user"}).setAllowedOrigins(new String[]{"*"}).addInterceptors(new HandshakeInterceptor[]{new WebSocketInterceptor()});
    }

    @Bean
    @Nullable
    public TaskScheduler defaultSockJsTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolScheduler = new ThreadPoolTaskScheduler();
        threadPoolScheduler.setThreadNamePrefix("SockJS-");
        threadPoolScheduler.setPoolSize(10);
        threadPoolScheduler.initialize();
        threadPoolScheduler.setRemoveOnCancelPolicy(true);
        return threadPoolScheduler;
    }
}

