/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.websocket.controller;

import com.biz.crm.excel.component.ExportHelper;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.websocket.vo.WebsocketMsg;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/websocket"})
public class WebsocketController {
    private static final Logger log = LoggerFactory.getLogger(WebsocketController.class);
    @Resource
    private ExportHelper exportHelper;

    @PostMapping(value={"/sendMsg"})
    public Result sendMsg(@RequestBody WebsocketMsg websocketMsg) {
        if (StringUtils.isEmpty((String)websocketMsg.getSid())) {
            return Result.error((String)"\u8bf7\u4f20\u5165sid");
        }
        this.exportHelper.sendWebsocketMsgMQ(websocketMsg.getMsg(), websocketMsg.getSid());
        return Result.ok();
    }
}

