/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.function;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.function.MdmRoleFunctionButtonImportVo;
import com.biz.crm.mdm.function.entity.MdmButtonRoleEntity;
import com.biz.crm.mdm.function.entity.MdmFunctionRoleEntity;
import com.biz.crm.mdm.function.entity.MdmFunctionSubButtonEntity;
import com.biz.crm.mdm.function.mapper.MdmButtonRoleMapper;
import com.biz.crm.mdm.function.mapper.MdmFunctionRoleMapper;
import com.biz.crm.mdm.function.mapper.MdmFunctionSubButtonMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmRoleFunctionButtonImportSavor")
@Transactional(value="mdmTransactionManager", rollbackFor={Exception.class})
public class MdmRoleFunctionButtonImportSavor
implements ExcelImportSaver<MdmRoleFunctionButtonImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmRoleFunctionButtonImportSavor.class);
    @Resource
    private MdmFunctionRoleMapper mdmFunctionRoleMapper;
    @Resource
    private MdmFunctionSubButtonMapper mdmFunctionSubButtonMapper;
    @Resource
    private MdmButtonRoleMapper mdmButtonRoleMapper;

    @Override
    public void save(List<MdmRoleFunctionButtonImportVo> data, DefaultImportContext context) {
        LambdaQueryWrapper buttonRoleWrapper;
        List mdmButtonRoleEntities;
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.saveFunctionRole(data);
        ArrayList<MdmButtonRoleEntity> list = new ArrayList<MdmButtonRoleEntity>();
        list.addAll(this.setUpAllConfigButtonList(data));
        list.addAll(this.setUpAllButtonList(data));
        list.addAll(this.setUpButtonList(data));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Collection values = list.stream().collect(Collectors.toMap(x -> x.getRoleCode() + x.getParentCode() + x.getFunctionCode() + x.getButtonCode(), Function.identity())).values();
        list = new ArrayList(values);
        HashSet<String> excelRoleCodeSet = new HashSet<String>();
        HashSet<String> excelFunctionCodeSet = new HashSet<String>();
        HashSet<String> excelConfigCodeSet = new HashSet<String>();
        HashSet<String> excelButtonCodeSet = new HashSet<String>();
        for (MdmButtonRoleEntity buttonRoleEntity : list) {
            excelRoleCodeSet.add(buttonRoleEntity.getRoleCode());
            excelFunctionCodeSet.add(buttonRoleEntity.getParentCode());
            excelConfigCodeSet.add(buttonRoleEntity.getFunctionCode());
            excelButtonCodeSet.add(buttonRoleEntity.getButtonCode());
        }
        if (!(CollectionUtils.isEmpty(excelRoleCodeSet) || CollectionUtils.isEmpty(excelFunctionCodeSet) || CollectionUtils.isEmpty(excelConfigCodeSet) || CollectionUtils.isEmpty(excelButtonCodeSet) || CollectionUtils.isEmpty((Collection)(mdmButtonRoleEntities = this.mdmButtonRoleMapper.selectList((Wrapper)(buttonRoleWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmButtonRoleEntity::getRoleCode, excelRoleCodeSet)).in(MdmButtonRoleEntity::getParentCode, excelFunctionCodeSet)).in(MdmButtonRoleEntity::getFunctionCode, excelConfigCodeSet)).in(MdmButtonRoleEntity::getButtonCode, excelButtonCodeSet))))))) {
            Set repeatSet = mdmButtonRoleEntities.stream().map(x -> x.getRoleCode() + x.getParentCode() + x.getFunctionCode() + x.getButtonCode()).collect(Collectors.toSet());
            Collection values1 = list.stream().filter(x -> !repeatSet.contains(x.getRoleCode() + x.getParentCode() + x.getFunctionCode() + x.getButtonCode())).collect(Collectors.toMap(x -> x.getRoleCode() + x.getParentCode() + x.getFunctionCode() + x.getButtonCode(), Function.identity(), (x1, x2) -> x1)).values();
            list = new ArrayList(values1);
        }
        list.forEach(x -> x.setId(UUID.randomUUID().toString()));
        this.mdmButtonRoleMapper.insertBatch(list);
    }

    protected List<MdmButtonRoleEntity> setUpButtonList(List<MdmRoleFunctionButtonImportVo> data) {
        return data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getListConfigCode()) && !StringUtils.isEmpty((Object)x.getButtonCode())).map(x -> {
            MdmButtonRoleEntity buttonRoleEntity = new MdmButtonRoleEntity();
            buttonRoleEntity.setButtonCode(x.getButtonCode());
            buttonRoleEntity.setRoleCode(x.getRoleCode());
            buttonRoleEntity.setParentCode(x.getFunctionCode());
            buttonRoleEntity.setFunctionCode(x.getListConfigCode());
            return buttonRoleEntity;
        }).collect(Collectors.toList());
    }

    protected List<MdmButtonRoleEntity> setUpAllButtonList(List<MdmRoleFunctionButtonImportVo> data) {
        List collect = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getListConfigCode()) && StringUtils.isEmpty((Object)x.getButtonCode())).filter(x -> {
            for (MdmRoleFunctionButtonImportVo importVo : data) {
                if (!importVo.getRoleCode().equals(x.getRoleCode()) || !importVo.getFunctionCode().equals(x.getFunctionCode()) || !x.getListConfigCode().equals(importVo.getListConfigCode()) || StringUtils.isEmpty((Object)importVo.getButtonCode())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return new ArrayList<MdmButtonRoleEntity>();
        }
        HashSet<String> excelFunctionCodeSet = new HashSet<String>();
        HashSet<String> excelConfigCodeSet = new HashSet<String>();
        for (MdmRoleFunctionButtonImportVo importVo : collect) {
            excelFunctionCodeSet.add(importVo.getFunctionCode());
            excelConfigCodeSet.add(importVo.getListConfigCode());
        }
        LambdaQueryWrapper functionButtonWrapper = ((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmFunctionSubButtonEntity::getParentCode, excelFunctionCodeSet)).in(MdmFunctionSubButtonEntity::getFunctionCode, excelConfigCodeSet)).select(new SFunction[]{MdmFunctionSubButtonEntity::getParentCode, MdmFunctionSubButtonEntity::getFunctionCode, MdmFunctionSubButtonEntity::getButtonCode});
        List mdmFunctionSubButtonEntities = this.mdmFunctionSubButtonMapper.selectList((Wrapper)functionButtonWrapper);
        if (CollectionUtils.isEmpty((Collection)mdmFunctionSubButtonEntities)) {
            return new ArrayList<MdmButtonRoleEntity>();
        }
        Map configMap = collect.stream().collect(Collectors.groupingBy(MdmRoleFunctionButtonImportVo::getListConfigCode, Collectors.mapping(x -> x.getFunctionCode() + ":" + x.getListConfigCode(), Collectors.toSet())));
        return mdmFunctionSubButtonEntities.stream().filter(x -> {
            Set roleCodeSet = (Set)configMap.get(x.getParentCode() + ":" + x.getFunctionCode());
            return !CollectionUtils.isEmpty((Collection)roleCodeSet);
        }).flatMap(x -> {
            Set roleCodeSet = (Set)configMap.get(x.getParentCode() + ":" + x.getFunctionCode());
            return roleCodeSet.stream().map(k -> {
                MdmButtonRoleEntity mdmButtonRoleEntity = new MdmButtonRoleEntity();
                mdmButtonRoleEntity.setRoleCode((String)k);
                mdmButtonRoleEntity.setParentCode(x.getParentCode());
                mdmButtonRoleEntity.setFunctionCode(x.getFunctionCode());
                mdmButtonRoleEntity.setButtonCode(x.getButtonCode());
                return mdmButtonRoleEntity;
            });
        }).collect(Collectors.toList());
    }

    protected List<MdmButtonRoleEntity> setUpAllConfigButtonList(List<MdmRoleFunctionButtonImportVo> data) {
        List collect = data.stream().filter(x -> StringUtils.isEmpty((Object)x.getListConfigCode()) && StringUtils.isEmpty((Object)x.getButtonCode())).filter(x -> {
            for (MdmRoleFunctionButtonImportVo importVo : data) {
                if (!importVo.getRoleCode().equals(x.getRoleCode()) || !importVo.getFunctionCode().equals(x.getFunctionCode()) || StringUtils.isEmpty((Object)importVo.getListConfigCode())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return new ArrayList<MdmButtonRoleEntity>();
        }
        HashSet<String> excelFunctionCodeSet = new HashSet<String>();
        for (MdmRoleFunctionButtonImportVo importVo : collect) {
            excelFunctionCodeSet.add(importVo.getFunctionCode());
        }
        LambdaQueryWrapper functionButtonWrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmFunctionSubButtonEntity::getParentCode, excelFunctionCodeSet)).select(new SFunction[]{MdmFunctionSubButtonEntity::getParentCode, MdmFunctionSubButtonEntity::getFunctionCode, MdmFunctionSubButtonEntity::getButtonCode});
        List mdmFunctionSubButtonEntities = this.mdmFunctionSubButtonMapper.selectList((Wrapper)functionButtonWrapper);
        if (CollectionUtils.isEmpty((Collection)mdmFunctionSubButtonEntities)) {
            return new ArrayList<MdmButtonRoleEntity>();
        }
        Map functionRoleMap = collect.stream().collect(Collectors.groupingBy(MdmRoleFunctionButtonImportVo::getFunctionCode, Collectors.mapping(MdmRoleFunctionButtonImportVo::getRoleCode, Collectors.toSet())));
        return mdmFunctionSubButtonEntities.stream().filter(x -> {
            Set roleCodeSet = (Set)functionRoleMap.get(x.getParentCode());
            return !CollectionUtils.isEmpty((Collection)roleCodeSet);
        }).flatMap(x -> {
            Set roleCodeSet = (Set)functionRoleMap.get(x.getParentCode());
            return roleCodeSet.stream().map(k -> {
                MdmButtonRoleEntity mdmButtonRoleEntity = new MdmButtonRoleEntity();
                mdmButtonRoleEntity.setRoleCode((String)k);
                mdmButtonRoleEntity.setParentCode(x.getParentCode());
                mdmButtonRoleEntity.setFunctionCode(x.getFunctionCode());
                mdmButtonRoleEntity.setButtonCode(x.getButtonCode());
                return mdmButtonRoleEntity;
            });
        }).collect(Collectors.toList());
    }

    protected void saveFunctionRole(List<MdmRoleFunctionButtonImportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet mayDbFunctionCodeSet = new HashSet();
        data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getRoleCode()) && !StringUtils.isEmpty((Object)x.getFunctionCode())).forEach(x -> mayDbFunctionCodeSet.add(x.getFunctionCode()));
        if (!CollectionUtils.isEmpty(mayDbFunctionCodeSet)) {
            LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmFunctionRoleEntity::getFunctionCode, mayDbFunctionCodeSet)).select(new SFunction[]{MdmFunctionRoleEntity::getRoleCode, MdmFunctionRoleEntity::getFunctionCode});
            List functionRoleUniqueKey = this.mdmFunctionRoleMapper.selectList((Wrapper)wrapper).stream().map(x -> x.getFunctionCode() + ":" + x.getRoleCode()).distinct().collect(Collectors.toList());
            Collection values = data.stream().filter(x -> !functionRoleUniqueKey.contains(x.getFunctionCode() + ":" + x.getRoleCode())).collect(Collectors.toMap(x -> x.getFunctionCode() + "" + x.getRoleCode(), Function.identity(), (x1, x2) -> x1)).values();
            ArrayList collect = new ArrayList(values);
            Lists.partition(collect, (int)500).parallelStream().forEach(x -> {
                List<MdmFunctionRoleEntity> mdmFunctionRoleEntityList = x.stream().map(k -> {
                    MdmFunctionRoleEntity mdmFunctionRoleEntity = new MdmFunctionRoleEntity();
                    mdmFunctionRoleEntity.setId(UUID.randomUUID().toString());
                    mdmFunctionRoleEntity.setRoleCode(k.getRoleCode());
                    mdmFunctionRoleEntity.setFunctionCode(k.getFunctionCode());
                    return mdmFunctionRoleEntity;
                }).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(mdmFunctionRoleEntityList)) {
                    this.mdmFunctionRoleMapper.insertBatch(mdmFunctionRoleEntityList);
                }
            });
        }
    }

    public static void main(String[] args) {
        MdmRoleFunctionButtonImportVo m1 = new MdmRoleFunctionButtonImportVo();
        m1.setRoleCode("r1");
        m1.setFunctionCode("f1");
        m1.setListConfigCode("l1");
        MdmRoleFunctionButtonImportVo m2 = new MdmRoleFunctionButtonImportVo();
        m2.setRoleCode("r2");
        m2.setFunctionCode("f2");
        m2.setListConfigCode("l2");
        m2.setButtonCode("b2");
        MdmRoleFunctionButtonImportVo m3 = new MdmRoleFunctionButtonImportVo();
        m3.setRoleCode("r3");
        m3.setFunctionCode("f3");
        List<MdmRoleFunctionButtonImportVo> list = Arrays.asList(m1, m2, m3);
        Map<String, Map<String, List<MdmRoleFunctionButtonImportVo>>> collect = list.stream().collect(Collectors.groupingBy(MdmRoleFunctionButtonImportVo::getRoleCode, Collectors.groupingBy(MdmRoleFunctionButtonImportVo::getFunctionCode)));
        System.out.println(1);
    }
}

