/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.excel.component.ExportHelper;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.excel.util.ExcelExportUtil;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.util.UserUtils;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTaskThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ExportTaskThread.class);
    private DefaultExportContext exportContext;
    private ExportHelper exportHelper = (ExportHelper)SpringApplicationContextUtil.getApplicationContext().getBean("exportHelper", ExportHelper.class);
    private ExcelExportUtil excelExportUtil = (ExcelExportUtil)SpringApplicationContextUtil.getApplicationContext().getBean("excelExportUtil", ExcelExportUtil.class);
    private String EXCEL_DOWNLOAD_URL;

    public ExportTaskThread(DefaultExportContext exportContext, String EXCEL_DOWNLOAD_URL) {
        this.exportContext = exportContext;
        this.EXCEL_DOWNLOAD_URL = EXCEL_DOWNLOAD_URL;
        this.check();
    }

    private void check() {
        if (null == this.exportContext) {
            throw new BusinessException("\u521b\u5efa\u4efb\u52a1\u5931\u8d25\uff0c\u975e\u6cd5\u7684\u521d\u59cb\u5316\u53c2\u6570\u6570\u636e[exportContext]");
        }
        if (StringUtils.isBlank((CharSequence)this.EXCEL_DOWNLOAD_URL)) {
            throw new BusinessException("\u521b\u5efa\u4efb\u52a1\u5931\u8d25\uff0c\u975e\u6cd5\u7684\u521d\u59cb\u5316\u53c2\u6570\u6570\u636e[EXCEL_DOWNLOAD_URL]");
        }
    }

    @Override
    public void run() {
        try {
            UserUtils.setToken((String)this.exportContext.getLoginUserToken());
            this.exportContext.setTaskBeginTime(LocalDateTime.now());
            this.exportHelper.saveExcelFile(this.exportContext);
            String msg = "\u521b\u5efa\u5bfc\u51fa\u4efb\u52a1 [" + this.exportContext.getTaskCode() + "] -> \u5f00\u59cb\u6267\u884c...";
            log.warn(msg);
            this.exportHelper.sendWebsocketMsgMQ(msg, this.exportContext);
            UploadVo uploadVo = this.excelExportUtil.repeatedWrite(this.exportContext);
            this.exportContext.setUploadVo(uploadVo);
            this.exportContext.setTaskEndTime(LocalDateTime.now());
            this.exportHelper.updateExcelFile(this.exportContext, true);
            this.exportHelper.sendWebsocketMsgMQ("\u4e0a\u4f20\u5b8c\u6210\uff1a<a href=" + this.EXCEL_DOWNLOAD_URL + "?objectName=" + uploadVo.getObjectName() + ">\u70b9\u51fb\u4e0b\u8f7d</a>", this.exportContext);
        }
        catch (BusinessException e) {
            log.error("\u5bfc\u51fa\u4efb\u52a1 [" + this.exportContext.getTaskCode() + "]\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25:" + e.getMsg(), (Throwable)e);
            this.exportHelper.sendWebsocketMsgMQ(e.getMsg(), this.exportContext);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u4efb\u52a1 [" + this.exportContext.getTaskCode() + "]\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            this.exportHelper.sendWebsocketMsgMQ("\u5bfc\u51faexcel\u6587\u4ef6\u5931\u8d25.....", this.exportContext);
        }
    }
}

