/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.export.extend.head.sfa;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.nebular.sfa.helpdefense.SfaHelpDefenseDto;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseDetailRespVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseRespVo;
import com.biz.crm.sfa.visitnote.SfaVisitAssitPlanFeign;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="sfa_interview_planExportHeadExtend")
public class HelpDefenseExportHeadExtend
implements ExportHeadExtend {
    private static final Logger log = LoggerFactory.getLogger(HelpDefenseExportHeadExtend.class);
    private static final String ID = "id";
    private static final String CLIENT_CODE = "clientCode";
    private static final String CLIENT_NAME = "\u7ec8\u7aef";
    private static final String REAL_NAME = "realName";
    private static final String NAME = "\u88ab\u534f\u8bbf\u4eba\u5458\u59d3\u540d";
    @Resource
    private SfaVisitAssitPlanFeign sfaVisitAssitPlanFeign;

    @Override
    public List<MdmColumnExportRespVo> getHeads(ExportHeadExtend.ExportHeadExtendParam headExtendParam) throws BusinessException {
        Integer headVariableSum = headExtendParam.getHeadVariableSum();
        ArrayList columnExportRespVos = Lists.newArrayList();
        this.buildColumn(headVariableSum, columnExportRespVos);
        return columnExportRespVos;
    }

    private void buildColumn(Integer headVariableSum, List<MdmColumnExportRespVo> columnExportRespVos) {
        MdmColumnExportRespVo columnExportRespVo1 = new MdmColumnExportRespVo();
        columnExportRespVo1.setField(REAL_NAME);
        columnExportRespVo1.setTitle(NAME);
        columnExportRespVos.add(columnExportRespVo1);
        for (int i = 1; i <= headVariableSum; ++i) {
            MdmColumnExportRespVo columnExportRespVo = new MdmColumnExportRespVo();
            columnExportRespVo.setField(CLIENT_CODE + i);
            columnExportRespVo.setTitle(CLIENT_NAME + i);
            columnExportRespVos.add(columnExportRespVo);
        }
    }

    private Map<String, List<SfaHelpDefenseDto>> getDate(List<String> idList) {
        List sfaHelpDefenseRespVos = (List)ApiResultUtil.objResult((Result)this.sfaVisitAssitPlanFeign.queryListById(idList), (boolean)true);
        if (CollectionUtil.listEmpty((List)sfaHelpDefenseRespVos)) {
            return Maps.newHashMap();
        }
        Map<String, List<SfaHelpDefenseDto>> result = sfaHelpDefenseRespVos.stream().collect(Collectors.toMap(UuidVo::getId, SfaHelpDefenseRespVo::getSfaHelpDefenseList));
        return result;
    }

    @Override
    public List<Map> getHeadsValue(DefaultExportContext exportContext, List<Map> value) {
        List<String> idList = value.stream().map(map -> (String)map.get(ID)).collect(Collectors.toList());
        ArrayList objects = Lists.newArrayList();
        if (CollectionUtil.listNotEmpty(value)) {
            Map<String, List<SfaHelpDefenseDto>> date = this.getDate(idList);
            value.forEach(v -> {
                String id = (String)v.get(ID);
                List sfaHelpDefenseDtos = (List)date.get(id);
                if (CollectionUtil.listEmpty((List)sfaHelpDefenseDtos)) {
                    objects.add(v);
                }
                sfaHelpDefenseDtos.forEach(s -> {
                    HashMap map2 = Maps.newHashMap();
                    map2.putAll(v);
                    String coverHelpRealName = s.getCoverHelpRealName();
                    if (StringUtils.isNotEmpty((String)coverHelpRealName)) {
                        map2.put(REAL_NAME, coverHelpRealName);
                        List sfaHelpDefenseDetailList = s.getSfaHelpDefenseDetailList();
                        if (CollectionUtil.listNotEmpty((List)sfaHelpDefenseDetailList)) {
                            List clientNames = sfaHelpDefenseDetailList.stream().map(SfaHelpDefenseDetailRespVo::getClientName).collect(Collectors.toList());
                            if (clientNames.size() > exportContext.getHeadVariableSum()) {
                                exportContext.setHeadVariableSum(clientNames.size());
                            }
                            for (int i = 1; i <= clientNames.size(); ++i) {
                                map2.put(CLIENT_CODE + i, clientNames.get(i - 1));
                            }
                        }
                    }
                    objects.add(map2);
                });
            });
        }
        return objects;
    }
}

