/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.export.extend.head.sfa;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.excel.util.DefaultExportContext;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActTableRespVo;
import com.biz.crm.sfa.visitstep.SfaVisitStepTpmActivityFeign;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="sfaCenter_activityActivityReport_tpmExecuteReport_listExportHeadExtend")
public class TpmActCollectDetailExportHeadExtend
implements ExportHeadExtend {
    private static final Logger log = LoggerFactory.getLogger(TpmActCollectDetailExportHeadExtend.class);
    private static final String ID = "id";
    private static final String PHOTO = "photo";
    private static final String PHOTO_TITLE = "\u7167\u7247";
    @Resource
    private SfaVisitStepTpmActivityFeign sfaVisitStepTpmActivityFeign;

    @Override
    public List<MdmColumnExportRespVo> getHeads(ExportHeadExtend.ExportHeadExtendParam headExtendParam) throws BusinessException {
        Integer headVariableSum = headExtendParam.getHeadVariableSum();
        ArrayList columnExportRespVos = Lists.newArrayList();
        this.buildColumn(headVariableSum, columnExportRespVos);
        return columnExportRespVos;
    }

    private void buildColumn(Integer headVariableSum, List<MdmColumnExportRespVo> columnExportRespVos) {
        for (int i = 1; i <= headVariableSum; ++i) {
            MdmColumnExportRespVo columnExportRespVo = new MdmColumnExportRespVo();
            columnExportRespVo.setField(PHOTO + (i - 1));
            columnExportRespVo.setTitle(PHOTO_TITLE + i);
            columnExportRespVos.add(columnExportRespVo);
        }
    }

    @Override
    public List<Map> getHeadsValue(DefaultExportContext exportContext, List<Map> value) {
        value.forEach(m -> {
            Integer headVariableSum = exportContext.getHeadVariableSum();
            String id = (String)m.get(ID);
            SfaTpmActTableRespVo respVo = (SfaTpmActTableRespVo)ApiResultUtil.objResult((Result)this.sfaVisitStepTpmActivityFeign.loadTpmActCollectDetailTableById(id), (boolean)true);
            if (null == respVo) {
                return;
            }
            List collectFormList = respVo.getCollectFormList();
            long count = collectFormList.stream().mapToInt(s -> s.getAttachmentList().size()).sum();
            if (count > (long)headVariableSum.intValue()) {
                exportContext.setHeadVariableSum((int)count);
            }
            collectFormList.forEach(form -> {
                List attachmentList = form.getAttachmentList();
                if (null == attachmentList) {
                    return;
                }
                List urlList = attachmentList.stream().map(AttachmentVo::getUrl).collect(Collectors.toList());
                for (int i = 0; i < urlList.size(); ++i) {
                    m.put(PHOTO + i, urlList.get(i));
                }
            });
        });
        return value;
    }
}

