/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.sfa.visitgroup;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.sfa.SfaVisitGroupImportVo;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.sfa.test.entity.SfaVisitGroupEntity;
import com.biz.crm.sfa.test.entity.SfaVisitclientRelEntity;
import com.biz.crm.sfa.test.mapper.SfaVisitClientRelMapper;
import com.biz.crm.sfa.test.mapper.SfaVisitGroupMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.websocket.WebsocketUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="sfaVisitGroupSaver")
@Transactional(value="sfaTransactionManager")
public class SfaVisitGroupSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<SfaVisitGroupMapper, SfaVisitGroupEntity, SfaVisitGroupImportVo>
implements ExcelImportSaver<SfaVisitGroupImportVo> {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitGroupSaver.class);
    private static final String DEALER = "0";
    private static final String TERMINAL = "1";
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private SfaVisitClientRelMapper sfaVisitClientRelMapper;
    @Autowired
    private WebsocketUtil websocketUtil;

    @Override
    public void save(List<SfaVisitGroupImportVo> list, DefaultImportContext context) {
        List partitionList = Lists.partition(list, (int)500);
        partitionList.forEach(data -> {
            List posCodeList = data.stream().map(SfaVisitGroupImportVo::getPosCode).collect(Collectors.toList());
            List userOrgRespVoList = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.detailBatchByPositionCodeList(posCodeList));
            Map<String, MdmPositionUserOrgRespVo> userMap = userOrgRespVoList.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, k -> k));
            this.checkPos((List<SfaVisitGroupImportVo>)data, userMap);
            this.checkPosClient((List<SfaVisitGroupImportVo>)data, userMap);
        });
    }

    private void checkPos(List<SfaVisitGroupImportVo> data, Map<String, MdmPositionUserOrgRespVo> userMap) {
        data.forEach(p -> {
            if (!userMap.containsKey(p.getPosCode())) {
                p.appendErrorSaveMsg("\u804c\u4f4d\u7f16\u7801\u4e0d\u5b58\u5728" + p.getPosCode());
            }
        });
    }

    private void checkPosClient(List<SfaVisitGroupImportVo> data, Map<String, MdmPositionUserOrgRespVo> userMap) {
        Map<String, List<SfaVisitGroupImportVo>> posClientTypeMap = data.stream().filter(da -> da.getProcessType().equals((Object)AbstractImportVo.ProcessTypeEnum.SUCCESS)).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(da -> da.getPosCode() + "-" + da.getGroupName()));
        posClientTypeMap.entrySet().forEach(pc -> {
            final String posCode = ((String)pc.getKey()).split("-")[0];
            final String groupName = ((String)pc.getKey()).split("-")[1];
            if (!userMap.containsKey(posCode)) {
                return;
            }
            SfaVisitGroupEntity visitGroupEntity = (SfaVisitGroupEntity)((Object)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitGroupEntity::getPosCode, (Object)posCode)).eq(SfaVisitGroupEntity::getGroupName, (Object)groupName)).one()));
            if (visitGroupEntity != null) {
                Boolean flag = false;
                for (SfaVisitGroupImportVo da : data) {
                    String key = da.getPosCode() + "-" + da.getGroupName();
                    if (!key.equals(pc.getKey())) continue;
                    da.appendErrorSaveMsg("\u6570\u636e\u5e93\u5b58\u5728\u8be5\u804c\u4f4d[" + posCode + "]\u76f8\u540c\u7684\u7ebf\u8def\u7ec4\u540d\u79f0:[" + groupName + "]");
                    flag = true;
                }
                if (flag.booleanValue()) {
                    return;
                }
            }
            final MdmPositionUserOrgRespVo userOrgRespVo = (MdmPositionUserOrgRespVo)userMap.get(posCode);
            final SfaVisitGroupEntity sfaVisitGroupEntity = new SfaVisitGroupEntity(){
                {
                    this.setGroupName(groupName);
                    this.setGroupCode(CodeUtil.getCodeDefault());
                    this.setPosCode(userOrgRespVo.getPositionCode());
                    this.setPosName(userOrgRespVo.getPositionName());
                    this.setUserName(userOrgRespVo.getUserName());
                    this.setFullName(userOrgRespVo.getFullName());
                    this.setOrgCode(userOrgRespVo.getOrgCode());
                    this.setOrgName(userOrgRespVo.getOrgName());
                }
            };
            ArrayList sfaVisitClientRelEntities = new ArrayList();
            Map<String, List<SfaVisitGroupImportVo>> clientListMap = ((List)pc.getValue()).stream().collect(Collectors.groupingBy(SfaVisitGroupImportVo::getType));
            clientListMap.entrySet().forEach(client -> {
                if (((String)client.getKey()).equals(DEALER)) {
                    PageResult customerResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmCustomerMsgFeign.listAndContactPage(new MdmCustomerContactPageReqVo(){
                        {
                            this.setPositionCode(posCode);
                            this.setPageSize(-1);
                        }
                    }));
                    if (customerResult != null && CollectionUtil.listNotEmptyNotSizeZero((List)customerResult.getData())) {
                        Map<String, MdmCustomerMsgRespVo> customerMap = customerResult.getData().stream().collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerCode, k -> k));
                        ((List)client.getValue()).forEach(c -> {
                            if (!customerMap.containsKey(c.getCode())) {
                                c.appendErrorSaveMsg("\u672a\u67e5\u8be2\u5230\u8be5\u804c\u4f4d" + posCode + "\u5bf9\u5e94\u7684\u7ecf\u9500\u5546[" + c.getName() + "]");
                            } else {
                                final MdmCustomerMsgRespVo customer = (MdmCustomerMsgRespVo)customerMap.get(c.getCode());
                                SfaVisitclientRelEntity relEntity = new SfaVisitclientRelEntity(){
                                    {
                                        this.setClientCode(customer.getCustomerCode());
                                        this.setClientName(customer.getCustomerName());
                                        this.setClientType(SfaVisitEnum.ClientType.DEALER.getVal());
                                        this.setClientTypeName(SfaVisitEnum.ClientType.DEALER.getDesc());
                                        this.setClientId(customer.getId());
                                        this.setClientPhone(customer.getCustomerContact());
                                        this.setClientAddress(customer.getRegisteredAddress());
                                        this.setClientSubclass(customer.getCustomerType());
                                        this.setClientSubclassName(customer.getCustomerTypeName());
                                        this.setGroupCode(sfaVisitGroupEntity.getGroupCode());
                                    }
                                };
                                if (CollectionUtil.listNotEmptyNotSizeZero((List)customer.getMdmCustomerContactVos())) {
                                    relEntity.setClientContacts(((MdmCustomerContactRespVo)customer.getMdmCustomerContactVos().get(0)).getContactName());
                                }
                                sfaVisitClientRelEntities.add(relEntity);
                            }
                        });
                    } else {
                        ((List)client.getValue()).forEach(c -> c.appendErrorSaveMsg("\u672a\u67e5\u8be2\u5230\u8be5\u804c\u4f4d" + posCode + "\u5bf9\u5e94\u7684\u7ecf\u9500\u5546[" + c.getName() + "]"));
                    }
                } else if (((String)client.getKey()).equals(TERMINAL)) {
                    PageResult terminalResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmTerminalFeign.terminalContactPage(new MdmTerminalContactPageReqVo(){
                        {
                            this.setPositionCode(posCode);
                            this.setPositionCodeList(Lists.newArrayList((Object[])new String[]{posCode}));
                            this.setPageSize(-1);
                        }
                    }));
                    if (terminalResult != null && CollectionUtil.listNotEmptyNotSizeZero((List)terminalResult.getData())) {
                        Map<String, MdmTerminalContactPageVo> customerMap = terminalResult.getData().stream().collect(Collectors.toMap(MdmTerminalContactPageVo::getTerminalCode, k -> k));
                        ((List)client.getValue()).forEach(c -> {
                            if (!customerMap.containsKey(c.getCode())) {
                                c.appendErrorSaveMsg("\u672a\u67e5\u8be2\u5230\u8be5\u804c\u4f4d" + posCode + "\u5bf9\u5e94\u7684\u7ec8\u7aef[" + c.getName() + "]");
                            } else {
                                final MdmTerminalContactPageVo terminal = (MdmTerminalContactPageVo)customerMap.get(c.getCode());
                                SfaVisitclientRelEntity relEntity = new SfaVisitclientRelEntity(){
                                    {
                                        this.setClientCode(terminal.getTerminalCode());
                                        this.setClientName(terminal.getTerminalName());
                                        this.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
                                        this.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
                                        this.setClientId(terminal.getId());
                                        this.setClientContacts(terminal.getContactName());
                                        this.setClientPhone(terminal.getContactPhone());
                                        this.setClientPhoto(terminal.getShopImagePath());
                                        this.setClientAddress(terminal.getTerminalAddress());
                                        this.setClientSubclass(terminal.getTerminalType());
                                        this.setClientSubclassName(terminal.getTerminalTypeName());
                                        this.setGroupCode(sfaVisitGroupEntity.getGroupCode());
                                    }
                                };
                                sfaVisitClientRelEntities.add(relEntity);
                            }
                        });
                    } else {
                        ((List)client.getValue()).forEach(c -> c.appendErrorSaveMsg("\u672a\u67e5\u8be2\u5230\u8be5\u804c\u4f4d" + posCode + "\u5bf9\u5e94\u7684\u7ec8\u7aef[" + c.getName() + "]"));
                    }
                }
            });
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitClientRelEntities)) {
                this.save((Object)sfaVisitGroupEntity);
                sfaVisitClientRelEntities.forEach(rel -> this.sfaVisitClientRelMapper.insert(rel));
            }
        });
    }
}

