/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.kaproduct;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.kaproduct.KmsTenantryDirectProductImportVo;
import com.biz.crm.kms.confadmin.entity.KmsDirectOrderTypeEntity;
import com.biz.crm.kms.confadmin.mapper.KmsDirectOrderTypeMapper;
import com.biz.crm.kms.kaproduct.entity.KmsTenantryDirectProductEntity;
import com.biz.crm.kms.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.entity.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="kmsTenantryDirectProductValidator")
public class KmsTenantryDirectProductValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsTenantryDirectProductMapper, KmsTenantryDirectProductEntity, KmsTenantryDirectProductImportVo>
implements ExcelImportValidator<KmsTenantryDirectProductImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectProductValidator.class);
    private List<KmsTenantryDirectCustomerOrgEntity> spareCustomerOrgList = Lists.newArrayList();
    private Map<String, KmsTenantryDirectCustomerOrgEntity> spareCustomerOrgMap = Maps.newHashMap();
    private Map<String, MdmCustomerEntity> spareSellPartyMap = Maps.newHashMap();
    private Map<String, MdmProductEntity> spareProductMap = Maps.newHashMap();
    private Map<String, Set<String>> spareOrderTypeMap = Maps.newHashMap();
    private Set<String> systemIds = Sets.newHashSet();
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Resource
    private MdmProductMapper mdmProductMapper;
    @Resource
    private KmsDirectOrderTypeMapper kmsDirectOrderTypeMapper;
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;

    @Override
    public void validate(List<KmsTenantryDirectProductImportVo> data, DefaultImportContext context) {
        ConcurrentHashMap map = ThreadLocalUtil.get();
        map.put("functionCode", "kms_on_product_table");
        map.put("menuCode", "CRM20210414000001468");
        ThreadLocalUtil.setUser((UserRedis)UserUtils.getUser());
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet bsCodeSet = Sets.newHashSet();
        HashSet sellPartySet = Sets.newHashSet();
        HashSet productCodeSet = Sets.newHashSet();
        HashSet kaProductCodeSet = Sets.newHashSet();
        HashMap repeatWithoutWeekMap = Maps.newHashMap();
        HashMap repeatWithWeekMap = Maps.newHashMap();
        data.forEach(x -> {
            String repeatStr;
            x.setId(StringUtils.replace((String)UUID.randomUUID().toString(), (String)"-", (String)""));
            if (StringUtils.isBlank((CharSequence)x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getSellPartyCode())) {
                x.appendErrorValidateMsg("\u3010\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getProductCode())) {
                x.appendErrorValidateMsg("\u3010\u4f01\u4e1a\u4ea7\u54c1\u4fe1\u606f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getKaProductCode())) {
                x.appendErrorValidateMsg("\u3010\u5ba2\u6237\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getIsDefault())) {
                x.appendErrorValidateMsg("\u3010\u662f\u5426\u9ed8\u8ba4\u4ea7\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getOrderType())) {
                x.appendErrorValidateMsg("\u3010\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getUnitCode())) {
                x.appendErrorValidateMsg("\u3010\u4f01\u4e1a\u4ea7\u54c1\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getKaUnitCode())) {
                x.appendErrorValidateMsg("\u3010\u5546\u8d85\u4ea7\u54c1\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            }
            if (x.getRatio() == null) {
                x.appendErrorValidateMsg("\u3010\u5355\u4f4d\u8f6c\u6362\u6bd4\u4f8b\u7cfb\u6570\u4e0d\u80fd\u4e3a\u4e3a\u7a7a\u3011\u3001");
            }
            if (!GlobalWhetherEnum.YES.getCode().equals(x.getIsDefault()) && !GlobalWhetherEnum.NO.getCode().equals(x.getIsDefault())) {
                x.appendErrorValidateMsg("\u3010\u662f\u5426\u9ed8\u8ba4\u4ea7\u54c1\u53ea\u80fd\u586b\u5199Y/N\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getIsDirect()) && !GlobalWhetherEnum.YES.getCode().equals(x.getIsDirect()) && !GlobalWhetherEnum.NO.getCode().equals(x.getIsDirect())) {
                x.appendErrorValidateMsg("\u3010\u662f\u5426\u9ed8\u8ba4\u76f4\u8425\u4ea7\u54c1\u53ea\u80fd\u586b\u5199Y/N\u3011\u3001");
            }
            bsCodeSet.add(x.getBsDirectSystemCode());
            sellPartySet.add(x.getSellPartyCode());
            productCodeSet.add(x.getProductCode());
            kaProductCodeSet.add(x.getKaProductCode());
            if (x.getTimeOfWeek() != null) {
                repeatStr = x.getBsDirectSystemCode() + x.getProductCode() + x.getSellPartyCode() + x.getKaProductCode() + x.getTimeOfWeek();
                if (repeatWithWeekMap.containsKey(repeatStr)) {
                    x.appendErrorValidateMsg("\u3010\u8be5\u884cexcel\u6570\u636e\u91cd\u590d\u3011\u3001");
                } else {
                    repeatWithWeekMap.put(repeatStr, x);
                }
            }
            if (x.getTimeOfWeek() == null) {
                repeatStr = x.getBsDirectSystemCode() + x.getProductCode() + x.getSellPartyCode() + x.getKaProductCode();
                if (repeatWithoutWeekMap.containsKey(repeatStr)) {
                    x.appendErrorValidateMsg("\u3010\u8be5\u884cexcel\u6570\u636e\u91cd\u590d\u3011\u3001");
                } else {
                    repeatWithoutWeekMap.put(repeatStr, x);
                }
            }
        });
        this.buildSpareData(bsCodeSet, sellPartySet, productCodeSet);
        this.checkSpare(data);
        this.checkExistByDb(repeatWithoutWeekMap, repeatWithWeekMap, bsCodeSet, sellPartySet, productCodeSet, kaProductCodeSet, data);
    }

    private void checkExistByDb(Map<String, KmsTenantryDirectProductImportVo> repeatWithoutWeekMap, Map<String, KmsTenantryDirectProductImportVo> repeatWithWeekMap, Set<String> bsCodeSet, Set<String> sellPartySet, Set<String> productCodeSet, Set<String> kaProductCodeSet, List<KmsTenantryDirectProductImportVo> data) {
        if (CollectionUtils.isEmpty(this.systemIds)) {
            data.forEach(x -> x.appendErrorValidateMsg("\u3010\u6ca1\u6709\u53ef\u7528\u7684\u76f4\u8425\u4f53\u7cfb\u3011"));
            return;
        }
        KmsTenantryDirectProductReqVo reqVo = new KmsTenantryDirectProductReqVo();
        reqVo.setBsDirectSystemIdList((List)Lists.newArrayList(this.systemIds));
        reqVo.setSellPartyCodeList((List)Lists.newArrayList(sellPartySet));
        reqVo.setProductCodes((List)Lists.newArrayList(productCodeSet));
        reqVo.setKaProductCodes((List)Lists.newArrayList(kaProductCodeSet));
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsTenantryDirectProductEntity> productEntities = this.kmsTenantryDirectProductMapper.selectListForExcel(reqVo);
        if (CollectionUtils.isEmpty(productEntities)) {
            return;
        }
        HashMap checkWithoutWeekByDb = Maps.newHashMap();
        HashMap checkWithWeekByDb = Maps.newHashMap();
        productEntities.forEach(x -> {
            if (x.getTimeOfWeek() == null) {
                checkWithoutWeekByDb.put(x.getBsDirectSystemCode() + x.getProductCode() + x.getSellPartyCode() + x.getKaProductCode(), x);
            }
            if (x.getTimeOfWeek() != null) {
                checkWithWeekByDb.put(x.getBsDirectSystemCode() + x.getProductCode() + x.getSellPartyCode() + x.getKaProductCode() + x.getTimeOfWeek(), x);
            }
        });
        repeatWithoutWeekMap.keySet().retainAll(checkWithoutWeekByDb.keySet());
        if (CollectionUtils.isNotEmpty(repeatWithoutWeekMap.keySet())) {
            data.forEach(x -> {
                if (repeatWithoutWeekMap.containsKey(x.getBsDirectSystemCode() + x.getProductCode() + x.getSellPartyCode() + x.getKaProductCode())) {
                    x.appendErrorValidateMsg("\u3010\u8be5\u884c\u7684\u6570\u636e\u5df2\u5b58\u5728\u3011\u3001");
                }
            });
        }
        repeatWithWeekMap.keySet().retainAll(checkWithWeekByDb.keySet());
        if (CollectionUtils.isNotEmpty(repeatWithWeekMap.keySet())) {
            data.forEach(x -> {
                if (repeatWithWeekMap.containsKey(x.getBsDirectSystemCode() + x.getProductCode() + x.getSellPartyCode() + x.getKaProductCode() + x.getTimeOfWeek())) {
                    x.appendErrorValidateMsg("\u3010\u8be5\u884c\u7684\u6570\u636e\u5df2\u5b58\u5728\u3011\u3001");
                }
            });
        }
    }

    private void checkSpare(List<KmsTenantryDirectProductImportVo> data) {
        Map unitMap = DictUtil.dictMap((String)"product_sale_unit");
        data.forEach(x -> {
            if (!this.spareCustomerOrgMap.containsKey(x.getBsDirectSystemCode())) {
                x.setDirectId(null);
                x.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb\u7f16\u7801" + x.getBsDirectSystemCode() + "\u7684\u76f4\u8425\u4f53\u7cfb\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3011\u3001");
            } else {
                KmsTenantryDirectCustomerOrgEntity entity = this.spareCustomerOrgMap.get(x.getBsDirectSystemCode());
                x.setBsDirectSystemId(entity.getBsDirectSystemId());
                x.setBsDirectSystemName(entity.getBsDirectSystemName());
                x.setDirectId(entity.getDirectId());
                this.systemIds.add(x.getBsDirectSystemId());
            }
            if (!this.spareSellPartyMap.containsKey(x.getSellPartyCode())) {
                x.appendErrorValidateMsg("\u3010\u552e\u8fbe\u65b9" + x.getSellPartyCode() + "\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3011\u3001");
            } else {
                x.setSellPartyName(this.spareSellPartyMap.get(x.getSellPartyCode()).getCustomerName());
            }
            if (!this.spareProductMap.containsKey(x.getProductCode())) {
                x.appendErrorValidateMsg("\u3010\u4f01\u4e1a\u4ea7\u54c1\u7f16\u7801" + x.getProductCode() + "\u7684\u4ea7\u54c1\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3011\u3001");
            } else {
                x.setProductName(this.spareProductMap.get(x.getProductCode()).getProductName());
            }
            if (this.spareOrderTypeMap.containsKey(x.getDirectId())) {
                if (!this.spareOrderTypeMap.get(x.getDirectId()).contains(x.getOrderType())) {
                    x.appendErrorValidateMsg("\u3010\u5355\u636e\u7c7b\u578b" + x.getBsDirectSystemCode() + "\u3001" + x.getOrderType() + "\u4e0d\u53ef\u7528\u3011\u3001");
                }
            } else {
                x.appendErrorValidateMsg("\u3010\u8be5\u884c\u6ca1\u6709\u53ef\u7528\u7684\u5355\u636e\u7c7b\u578b\u3011\u3001");
            }
        });
    }

    private void buildSpareData(Set<String> bsCodeSet, Set<String> sellPartySet, Set<String> productCodeSet) {
        if (CollectionUtils.isNotEmpty(bsCodeSet)) {
            this.spareCustomerOrgData(bsCodeSet);
        }
        if (CollectionUtils.isNotEmpty(sellPartySet)) {
            this.spareSellPartyData(sellPartySet);
        }
        if (CollectionUtils.isNotEmpty(productCodeSet)) {
            this.spareProductData(productCodeSet);
        }
        if (CollectionUtils.isNotEmpty(this.spareCustomerOrgList)) {
            Set directIdCode = this.spareCustomerOrgList.stream().map(KmsTenantryDirectCustomerOrgEntity::getDirectId).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(directIdCode)) {
                throw new BusinessException("\u3010\u5355\u636e\u7c7b\u578b\u4e0d\u53ef\u7528\u3011\u3001");
            }
            List orderTypeEntities = this.kmsDirectOrderTypeMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).in(KmsDirectOrderTypeEntity::getDirectId, directIdCode));
            if (CollectionUtils.isEmpty((Collection)orderTypeEntities)) {
                throw new BusinessException("\u3010\u6ca1\u6709\u53ef\u7528\u5355\u636e\u7c7b\u578b\u3011\u3001");
            }
            HashMap map = Maps.newHashMap();
            orderTypeEntities.forEach(x -> {
                if (map.containsKey(x.getDirectId())) {
                    Set orderTypeSet = (Set)map.get(x.getDirectId());
                    orderTypeSet.add(x.getOrderType());
                    map.put(x.getDirectId(), orderTypeSet);
                } else {
                    HashSet initOrderTypeSet = Sets.newHashSet();
                    initOrderTypeSet.add(x.getOrderType());
                    map.put(x.getDirectId(), initOrderTypeSet);
                }
            });
            this.spareOrderTypeMap = map;
        }
    }

    private void spareProductData(Set<String> productCodeSet) {
        ArrayList productCodeList = Lists.newArrayList(productCodeSet);
        List mdmProductEntities = this.mdmProductMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmProductEntity::getProductCode, (Collection)productCodeList)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
            this.spareProductMap = mdmProductEntities.stream().collect(Collectors.toMap(MdmProductEntity::getProductCode, Function.identity()));
        }
    }

    private void spareSellPartyData(Set<String> sellPartySet) {
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setCustomerCodeList(new ArrayList<String>(sellPartySet));
        mdmCustomerMsgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List entities = this.mdmCustomerMsgMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmCustomerEntity::getCustomerCode, sellPartySet)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        this.spareSellPartyMap = entities.stream().collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, Function.identity()));
    }

    private void spareCustomerOrgData(Set<String> bsCodeSet) {
        KmsTenantryDirectCustomerOrgReqVo reqVo = new KmsTenantryDirectCustomerOrgReqVo();
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setBsDirectSystemCodeList(bsCodeSet);
        this.spareCustomerOrgList = this.kmsTenantryDirectCustomerOrgMapper.selectListForExcel(reqVo);
        if (CollectionUtils.isEmpty(this.spareCustomerOrgList)) {
            return;
        }
        this.spareCustomerOrgMap = this.spareCustomerOrgList.stream().collect(Collectors.toMap(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, Function.identity()));
    }
}

