/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.tenantrydirectcustomerorg;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.tenantrydirectcustomerorg.KmsTenantryDirectCustomerOrgImportVo;
import com.biz.crm.kms.confadmin.entity.KmsDirectSystemEntity;
import com.biz.crm.kms.confadmin.mapper.KmsDirectSystemMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.entity.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="kmsTenantryDirectCustomerOrgValidator")
public class KmsTenantryDirectCustomerOrgValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsTenantryDirectCustomerOrgMapper, KmsTenantryDirectCustomerOrgEntity, KmsTenantryDirectCustomerOrgImportVo>
implements ExcelImportValidator<KmsTenantryDirectCustomerOrgImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectCustomerOrgValidator.class);
    @Resource
    private KmsTenantryDirectCustomerOrgMapper customerOrgMapper;
    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;
    @Resource
    private KmsDirectSystemMapper systemMapper;
    private List<KmsTenantryDirectCustomerOrgImportVo> importVoList = Lists.newArrayList();
    private List<KmsTenantryDirectCustomerOrgEntity> updateEntities = Lists.newArrayList();

    @Override
    public void validate(List<KmsTenantryDirectCustomerOrgImportVo> data, DefaultImportContext context) {
        ConcurrentHashMap map = ThreadLocalUtil.get();
        map.put("functionCode", "bs_direct_system_list");
        map.put("menuCode", "CRM20210519000001676");
        ThreadLocalUtil.setUser((UserRedis)UserUtils.getUser());
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet systemCodeSet = Sets.newHashSet();
        HashSet directNameSet = Sets.newHashSet();
        HashSet cusOrgCodeSet = Sets.newHashSet();
        data.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getDirectName())) {
                x.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb\u672a\u586b\u5199\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getBsDirectSystemName())) {
                x.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getCustomerOrgCode())) {
                x.appendErrorValidateMsg("\u3010\u5ba2\u6237\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3011\u3001");
            }
            if (systemCodeSet.contains(x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("\u3010" + x.getBsDirectSystemCode() + "\u3011\u7684\u7f16\u7801\u91cd\u590d\u3001");
            }
            if (directNameSet.contains(x.getDirectName())) {
                x.appendErrorValidateMsg("\u3010" + x.getDirectName() + "\u3011\u7684\u5546\u8d85\u91cd\u590d\u3001");
            }
            if (StringUtils.isNotBlank((CharSequence)x.getCustomerOrgCode()) && StringUtils.isNotBlank((CharSequence)x.getBsDirectSystemCode()) && StringUtils.isNotBlank((CharSequence)x.getDirectName())) {
                cusOrgCodeSet.add(x.getCustomerOrgCode());
                systemCodeSet.add(x.getBsDirectSystemCode());
                directNameSet.add(x.getDirectName());
            }
        });
        if (CollectionUtils.isEmpty((Collection)directNameSet)) {
            return;
        }
        List systemEntityList = this.systemMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(KmsDirectSystemEntity::getDirectName, (Collection)directNameSet));
        if (CollectionUtils.isEmpty((Collection)systemEntityList)) {
            data.forEach(x -> x.appendErrorValidateMsg("\u3010" + x.getDirectName() + "\u3011\u7684\u5546\u8d85\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001"));
            return;
        }
        Map systemEntityMap = systemEntityList.stream().collect(Collectors.toMap(KmsDirectSystemEntity::getDirectName, Function.identity()));
        data.forEach(x -> {
            if (systemEntityMap.containsKey(x.getDirectName())) {
                x.setDirectId(((KmsDirectSystemEntity)((Object)((Object)systemEntityMap.get(x.getDirectName())))).getDirectName());
            } else {
                x.appendErrorValidateMsg("\u3010" + x.getDirectName() + "\u3011\u7684\u5546\u8d85\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
            }
        });
        if (CollectionUtils.isEmpty((Collection)cusOrgCodeSet)) {
            return;
        }
        List cusOrgEntities = this.mdmCusOrgMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(MdmCusOrgEntity::getCustomerOrgCode, (Collection)cusOrgCodeSet));
        if (CollectionUtils.isEmpty((Collection)cusOrgEntities)) {
            data.forEach(x -> x.appendErrorValidateMsg("\u3010" + x.getCustomerOrgCode() + "\u3011\u7684\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001"));
            return;
        }
        Map mdmCusOrgEntityMap = cusOrgEntities.stream().collect(Collectors.toMap(MdmCusOrgEntity::getCustomerOrgCode, Function.identity()));
        List customerOrgEntities = this.customerOrgMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsTenantryDirectCustomerOrgEntity::getDirectId, systemEntityMap.keySet())).eq(CrmBaseEntity::getCreateOrgCode, (Object)UserUtils.getUser().getOrgcode()));
        ArrayList vos = Lists.newArrayList();
        for (int i = 0; i < data.size(); ++i) {
            KmsTenantryDirectCustomerOrgImportVo x2 = data.get(i);
            if (!mdmCusOrgEntityMap.containsKey(x2.getCustomerOrgId())) {
                x2.appendErrorValidateMsg("\u7ec4\u7ec7\u5ba2\u6237\u4e3a\u3010" + x2.getCustomerOrgId() + "\u3011\u4e0d\u5b58\u5728\u3001");
            } else {
                x2.setCustomerOrgCode(((MdmCusOrgEntity)((Object)mdmCusOrgEntityMap.get(x2.getCustomerOrgId()))).getCustomerOrgCode());
                x2.setCustomerOrgName(((MdmCusOrgEntity)((Object)mdmCusOrgEntityMap.get(x2.getCustomerOrgId()))).getCustomerOrgName());
            }
            customerOrgEntities.forEach(y -> {
                if (x2.getDirectId().equals(y.getDirectId()) && (y.getEnableStatus().equals(CrmEnableStatusEnum.DISABLE.getCode()) || !y.getDelFlag().equals(CrmDelFlagEnum.DELETE.getCode()))) {
                    y.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                    y.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                    this.updateEntities.add((KmsTenantryDirectCustomerOrgEntity)((Object)y));
                    vos.add(x2);
                }
            });
        }
        this.updateBatchById(this.updateEntities);
        data.removeAll(vos);
    }
}

