/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.function;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.MdmPermissionObjEnum;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.function.MdmDataPermissionImportVo;
import com.biz.crm.mdm.function.entity.MdmFunctionEntity;
import com.biz.crm.mdm.function.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.function.mapper.MdmFunctionMapper;
import com.biz.crm.mdm.function.mapper.MdmFunctionSubMapper;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmDataPermissionValidator")
public class MdmDataPermissionValidator
implements ExcelImportValidator<MdmDataPermissionImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmDataPermissionValidator.class);
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmFunctionMapper mdmFunctionMapper;
    @Resource
    private MdmFunctionSubMapper mdmFunctionSubMapper;

    @Override
    public void validate(List<MdmDataPermissionImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validEmptyField(data);
        this.validRoleCode(data);
        this.validFunctionCode(data);
        this.validConfigCode(data);
        this.validPermissionObjName(data);
        this.validPermissionSearchTypeName(data);
    }

    protected void validPermissionSearchTypeName(List<MdmDataPermissionImportVo> data) {
        String orgDictTypeCode = "permission_obj_org";
        String positionDictTypeCode = "permission_obj_position";
        Map orgMap = DictUtil.dictRevertMap((String)orgDictTypeCode);
        Map positionMap = DictUtil.dictRevertMap((String)positionDictTypeCode);
        for (MdmDataPermissionImportVo importVo : data) {
            String permissionSearchType;
            String permissionSearchTypeName = importVo.getPermissionSearchTypeName();
            if (StringUtils.isEmpty((Object)permissionSearchTypeName)) {
                importVo.appendErrorValidateMsg("\u67e5\u8be2\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a;");
                continue;
            }
            if (StringUtils.isEmpty((Object)importVo.getPermissionObjCode())) continue;
            String permissionObjCode = importVo.getPermissionObjCode();
            if (MdmPermissionObjEnum.POSITION.getCode().equals(permissionObjCode)) {
                permissionSearchType = (String)positionMap.get(permissionSearchTypeName);
                if (StringUtils.isEmpty((Object)permissionObjCode)) {
                    importVo.appendErrorValidateMsg(permissionSearchType + "\u5728\u6570\u636e\u5b57\u5178" + positionDictTypeCode + "\u4e0d\u5b58\u5728;");
                } else {
                    importVo.setPermissionSearchType(permissionSearchType);
                }
            }
            if (!MdmPermissionObjEnum.ORG.getCode().equals(permissionObjCode)) continue;
            permissionSearchType = (String)orgMap.get(permissionSearchTypeName);
            if (StringUtils.isEmpty((Object)permissionObjCode)) {
                importVo.appendErrorValidateMsg(permissionSearchType + "\u5728\u6570\u636e\u5b57\u5178" + orgDictTypeCode + "\u4e0d\u5b58\u5728;");
                continue;
            }
            importVo.setPermissionSearchType(permissionSearchType);
        }
    }

    protected void validPermissionObjName(List<MdmDataPermissionImportVo> data) {
        String dictTypeCode = "permission_obj";
        Map map = DictUtil.dictRevertMap((String)dictTypeCode);
        for (MdmDataPermissionImportVo importVo : data) {
            String permissionObjName = importVo.getPermissionObjName();
            if (StringUtils.isEmpty((Object)permissionObjName)) {
                importVo.appendErrorValidateMsg("\u67e5\u8be2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a;");
                continue;
            }
            String permissionObjCode = (String)map.get(permissionObjName);
            if (StringUtils.isEmpty((Object)permissionObjCode)) {
                importVo.appendErrorValidateMsg(permissionObjName + "\u5728\u6570\u636e\u5b57\u5178" + dictTypeCode + "\u4e0d\u5b58\u5728;");
                continue;
            }
            importVo.setPermissionObjCode(permissionObjCode);
        }
    }

    protected void validConfigCode(List<MdmDataPermissionImportVo> data) {
        List excelConfigList = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getListConfigCode())).map(MdmDataPermissionImportVo::getListConfigCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(excelConfigList)) {
            return;
        }
        Set dbFunctionSet = Lists.partition(excelConfigList, (int)500).parallelStream().filter(x -> !CollectionUtils.isEmpty((Collection)x)).flatMap(list -> {
            LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmFunctionSubEntity::getFunctionCode, (Collection)list)).select(new SFunction[]{MdmFunctionSubEntity::getFunctionCode});
            return this.mdmFunctionSubMapper.selectList((Wrapper)wrapper).stream();
        }).map(MdmFunctionSubEntity::getFunctionCode).collect(Collectors.toSet());
        for (MdmDataPermissionImportVo importVo : data) {
            String listConfigCode = importVo.getListConfigCode();
            if (StringUtils.isEmpty((Object)listConfigCode) || dbFunctionSet.contains(listConfigCode)) continue;
            importVo.appendErrorValidateMsg("\u5217\u8868\u7f16\u7801" + listConfigCode + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validFunctionCode(List<MdmDataPermissionImportVo> data) {
        List excelFunctionCodeList = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmDataPermissionImportVo::getFunctionCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(excelFunctionCodeList)) {
            return;
        }
        Map<String, String> dbFunctionMap = Lists.partition(excelFunctionCodeList, (int)500).parallelStream().flatMap(list -> {
            LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmFunctionEntity::getFunctionCode, (Collection)list)).select(new SFunction[]{MdmFunctionEntity::getFunctionCode, CrmBaseEntity::getEnableStatus});
            return this.mdmFunctionMapper.selectList((Wrapper)wrapper).stream();
        }).collect(Collectors.toMap(MdmFunctionEntity::getFunctionCode, CrmBaseEntity::getEnableStatus, (x1, x2) -> x1));
        for (MdmDataPermissionImportVo importVo : data) {
            String functionCode = importVo.getFunctionCode();
            if (StringUtils.isEmpty((Object)functionCode)) continue;
            if (!dbFunctionMap.containsKey(functionCode)) {
                importVo.appendErrorValidateMsg("\u83dc\u5355\u7f16\u7801" + functionCode + "\u4e0d\u5b58\u5728;");
                continue;
            }
            if (CrmEnableStatusEnum.ENABLE.getCode().equals(dbFunctionMap.get(functionCode))) continue;
            importVo.appendErrorValidateMsg("\u83dc\u5355\u7f16\u7801" + functionCode + "\u672a\u542f\u7528;");
        }
    }

    protected void validRoleCode(List<MdmDataPermissionImportVo> data) {
        List excelRoleCodeList = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getRoleCode())).map(MdmDataPermissionImportVo::getRoleCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(excelRoleCodeList)) {
            return;
        }
        Map<String, String> dbRoleMap = Lists.partition(excelRoleCodeList, (int)500).parallelStream().flatMap(list -> {
            LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)list)).select(new SFunction[]{MdmRoleEntity::getRoleCode, CrmBaseEntity::getEnableStatus});
            return this.mdmRoleMapper.selectList((Wrapper)wrapper).stream();
        }).collect(Collectors.toMap(MdmRoleEntity::getRoleCode, CrmBaseEntity::getEnableStatus, (x1, x2) -> x1));
        for (MdmDataPermissionImportVo importVo : data) {
            String roleCode = importVo.getRoleCode();
            if (StringUtils.isEmpty((Object)roleCode)) continue;
            if (!dbRoleMap.containsKey(roleCode)) {
                importVo.appendErrorValidateMsg("\u89d2\u8272\u7f16\u7801" + roleCode + "\u4e0d\u5b58\u5728;");
                continue;
            }
            if (CrmEnableStatusEnum.ENABLE.getCode().equals(dbRoleMap.get(roleCode))) continue;
            importVo.appendErrorValidateMsg("\u89d2\u8272\u7f16\u7801" + roleCode + "\u672a\u542f\u7528;");
        }
    }

    protected void validEmptyField(List<MdmDataPermissionImportVo> data) {
        for (MdmDataPermissionImportVo importVo : data) {
            if (StringUtils.isEmpty((Object)importVo.getRoleCode())) {
                importVo.appendErrorValidateMsg("\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((Object)importVo.getFunctionCode())) {
                importVo.appendErrorValidateMsg("\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((Object)importVo.getListConfigCode())) {
                importVo.appendErrorValidateMsg("\u5217\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((Object)importVo.getPermissionObjName())) {
                importVo.appendErrorValidateMsg("\u67e5\u8be2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isEmpty((Object)importVo.getPermissionSearchTypeName())) continue;
            importVo.appendErrorValidateMsg("\u67e5\u8be2\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a;");
        }
    }
}

