/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.function;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.function.MdmRoleFunctionButtonImportVo;
import com.biz.crm.mdm.function.entity.MdmButtonEntity;
import com.biz.crm.mdm.function.entity.MdmFunctionEntity;
import com.biz.crm.mdm.function.entity.MdmFunctionRoleEntity;
import com.biz.crm.mdm.function.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.function.mapper.MdmButtonMapper;
import com.biz.crm.mdm.function.mapper.MdmFunctionMapper;
import com.biz.crm.mdm.function.mapper.MdmFunctionRoleMapper;
import com.biz.crm.mdm.function.mapper.MdmFunctionSubMapper;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmRoleFunctionButtonValidator")
public class MdmRoleFunctionButtonValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmFunctionRoleMapper, MdmFunctionRoleEntity, MdmRoleFunctionButtonImportVo>
implements ExcelImportValidator<MdmRoleFunctionButtonImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmRoleFunctionButtonValidator.class);
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmFunctionMapper mdmFunctionMapper;
    @Resource
    private MdmFunctionRoleMapper mdmFunctionRoleMapper;
    @Resource
    private MdmFunctionSubMapper mdmFunctionSubMapper;
    @Resource
    private MdmButtonMapper mdmButtonMapper;

    @Override
    public void validate(List<MdmRoleFunctionButtonImportVo> data, DefaultImportContext context) {
        this.validRole(data);
        this.validFunction(data);
        this.validListConfig(data);
        this.validButton(data);
    }

    protected void validButton(List<MdmRoleFunctionButtonImportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        List excelButtonCodeList = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getButtonCode())).map(MdmRoleFunctionButtonImportVo::getButtonCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(excelButtonCodeList)) {
            return;
        }
        Map<String, String> dbListButtonCodeMap = Lists.partition(excelButtonCodeList, (int)500).parallelStream().flatMap(list2 -> {
            LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmButtonEntity::getButtonCode, (Collection)excelButtonCodeList)).select(new SFunction[]{MdmButtonEntity::getButtonCode, CrmBaseEntity::getEnableStatus});
            return this.mdmButtonMapper.selectList((Wrapper)wrapper).stream();
        }).collect(Collectors.toMap(MdmButtonEntity::getButtonCode, CrmBaseEntity::getEnableStatus, (x1, x2) -> x1));
        for (MdmRoleFunctionButtonImportVo importVo : data) {
            String buttonCode = importVo.getButtonCode();
            if (StringUtils.isEmpty((Object)buttonCode)) continue;
            if (StringUtils.isEmpty((Object)importVo.getListConfigCode())) {
                importVo.appendErrorValidateMsg("\u5217\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
                continue;
            }
            if (!dbListButtonCodeMap.containsKey(buttonCode)) {
                importVo.appendErrorValidateMsg("\u6309\u94ae\u7f16\u7801:" + buttonCode + "\u4e0d\u5b58\u5728;");
                continue;
            }
            if (CrmEnableStatusEnum.ENABLE.getCode().equals(dbListButtonCodeMap.get(buttonCode))) continue;
            importVo.appendErrorValidateMsg("\u6309\u94ae\u7f16\u7801:" + buttonCode + "\u672a\u542f\u7528");
        }
    }

    protected void validListConfig(List<MdmRoleFunctionButtonImportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        List excelListConfigCodeList = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getListConfigCode())).map(MdmRoleFunctionButtonImportVo::getListConfigCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(excelListConfigCodeList)) {
            return;
        }
        Set dbListConfigCodeSet = Lists.partition(excelListConfigCodeList, (int)500).parallelStream().flatMap(list2 -> {
            LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmFunctionSubEntity::getFunctionCode, (Collection)excelListConfigCodeList)).select(new SFunction[]{MdmFunctionSubEntity::getFunctionCode});
            return this.mdmFunctionSubMapper.selectList((Wrapper)wrapper).stream();
        }).map(MdmFunctionSubEntity::getFunctionCode).collect(Collectors.toSet());
        for (MdmRoleFunctionButtonImportVo importVo : data) {
            String listConfigCode = importVo.getListConfigCode();
            if (StringUtils.isEmpty((Object)listConfigCode) || dbListConfigCodeSet.contains(listConfigCode)) continue;
            importVo.appendErrorValidateMsg("\u5217\u8868\u7f16\u7801:" + listConfigCode + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validFunction(List<MdmRoleFunctionButtonImportVo> data) {
        LambdaQueryWrapper wrapper;
        List mdmFunctionRoleEntities;
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet<String> repeatFunctionRoleSet = new HashSet<String>();
        for (MdmRoleFunctionButtonImportVo importVo : data) {
            if (StringUtils.isEmpty((Object)importVo.getFunctionCode())) {
                importVo.appendErrorValidateMsg("\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
                continue;
            }
            if (!StringUtils.isEmpty((Object)importVo.getListConfigCode()) || StringUtils.isEmpty((Object)importVo.getRoleCode()) || repeatFunctionRoleSet.add(importVo.getRoleCode() + ":" + importVo.getFunctionCode())) continue;
            importVo.appendErrorValidateMsg("\u83dc\u5355\u7f16\u7801:" + importVo.getFunctionCode() + ",\u89d2\u8272\u7f16\u7801:" + importVo.getRoleCode() + "\u91cd\u590d");
        }
        List excelFunctionCodeList = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmRoleFunctionButtonImportVo::getFunctionCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(excelFunctionCodeList)) {
            return;
        }
        Map<String, String> dbFunctionMap = Lists.partition(excelFunctionCodeList, (int)500).parallelStream().flatMap(list -> {
            LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmFunctionEntity::getFunctionCode, (Collection)list)).select(new SFunction[]{MdmFunctionEntity::getFunctionCode, CrmBaseEntity::getEnableStatus});
            return this.mdmFunctionMapper.selectList((Wrapper)wrapper).stream();
        }).collect(Collectors.toMap(MdmFunctionEntity::getFunctionCode, CrmBaseEntity::getEnableStatus, (x1, x2) -> x1));
        for (MdmRoleFunctionButtonImportVo importVo : data) {
            String functionCode = importVo.getFunctionCode();
            if (StringUtils.isEmpty((Object)functionCode)) continue;
            if (!dbFunctionMap.containsKey(functionCode)) {
                importVo.appendErrorValidateMsg("\u83dc\u5355\u7f16\u7801:" + functionCode + "\u4e0d\u5b58\u5728;");
                continue;
            }
            if (CrmEnableStatusEnum.ENABLE.getCode().equalsIgnoreCase(dbFunctionMap.get(functionCode))) continue;
            importVo.appendErrorValidateMsg("\u83dc\u5355\u7f16\u7801:" + functionCode + "\u672a\u542f\u7528;");
        }
        HashSet mayDbRoleCodeSet = new HashSet();
        HashSet mayDbFunctionCodeSet = new HashSet();
        data.stream().filter(x -> StringUtils.isEmpty((Object)x.getListConfigCode())).filter(x -> !StringUtils.isEmpty((Object)x.getRoleCode()) && !StringUtils.isEmpty((Object)x.getFunctionCode())).forEach(x -> {
            mayDbRoleCodeSet.add(x.getRoleCode());
            mayDbFunctionCodeSet.add(x.getFunctionCode());
        });
        if (!(CollectionUtils.isEmpty(mayDbRoleCodeSet) || CollectionUtils.isEmpty(mayDbFunctionCodeSet) || CollectionUtils.isEmpty((Collection)(mdmFunctionRoleEntities = this.mdmFunctionRoleMapper.selectList((Wrapper)(wrapper = ((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmFunctionRoleEntity::getRoleCode, mayDbRoleCodeSet)).in(MdmFunctionRoleEntity::getFunctionCode, mayDbFunctionCodeSet)).select(new SFunction[]{MdmFunctionRoleEntity::getRoleCode, MdmFunctionRoleEntity::getFunctionCode}))))))) {
            for (MdmRoleFunctionButtonImportVo importVo : data) {
                String roleCode = importVo.getRoleCode();
                String functionCode = importVo.getFunctionCode();
                String listConfigCode = importVo.getListConfigCode();
                if (StringUtils.isEmpty((Object)roleCode) || StringUtils.isEmpty((Object)functionCode) || !StringUtils.isEmpty((Object)listConfigCode)) continue;
                for (MdmFunctionRoleEntity mdmFunctionRoleEntity : mdmFunctionRoleEntities) {
                    if (!roleCode.equals(mdmFunctionRoleEntity.getRoleCode()) || !functionCode.equals(mdmFunctionRoleEntity.getFunctionCode())) continue;
                    importVo.appendErrorValidateMsg("\u89d2\u8272\u7f16\u7801:" + roleCode + ",\u83dc\u5355\u7f16\u7801:" + functionCode + "\u5df2\u5b58\u5728");
                }
            }
        }
    }

    protected void validRole(List<MdmRoleFunctionButtonImportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        for (MdmRoleFunctionButtonImportVo importVo : data) {
            if (!StringUtils.isEmpty((Object)importVo.getRoleCode())) continue;
            importVo.appendErrorValidateMsg("\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        List excelRoleCodeSet = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getRoleCode())).map(MdmRoleFunctionButtonImportVo::getRoleCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(excelRoleCodeSet)) {
            return;
        }
        Map<String, String> dbRoleMap = Lists.partition(excelRoleCodeSet, (int)500).parallelStream().flatMap(list -> {
            LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)list)).select(new SFunction[]{MdmRoleEntity::getRoleCode, CrmBaseEntity::getEnableStatus});
            return this.mdmRoleMapper.selectList((Wrapper)wrapper).stream();
        }).collect(Collectors.toMap(MdmRoleEntity::getRoleCode, CrmBaseEntity::getEnableStatus, (x1, x2) -> x1));
        for (MdmRoleFunctionButtonImportVo importVo : data) {
            String roleCode = importVo.getRoleCode();
            if (StringUtils.isEmpty((Object)roleCode)) continue;
            if (!dbRoleMap.containsKey(roleCode)) {
                importVo.appendErrorValidateMsg("\u89d2\u8272\u7f16\u7801" + roleCode + "\u4e0d\u5b58\u5728;");
                continue;
            }
            if (CrmEnableStatusEnum.ENABLE.getCode().equals(dbRoleMap.get(roleCode))) continue;
            importVo.appendErrorValidateMsg("\u89d2\u8272" + roleCode + "\u672a\u542f\u7528;");
        }
    }
}

