/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.function;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.PermissionResourceEnum;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.function.MdmDataPermissionImportVo;
import com.biz.crm.mdm.function.entity.MdmDataPermissionEntity;
import com.biz.crm.mdm.function.entity.MdmDataPermissionExtendEntity;
import com.biz.crm.mdm.function.mapper.MdmDataPermissionExtendMapper;
import com.biz.crm.mdm.function.mapper.MdmDataPermissionMapper;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component(value="mdmDataPermissionImportSavor")
@Transactional(value="mdmTransactionManager", rollbackFor={Exception.class})
public class MdmDataPermissionImportSavor
implements ExcelImportSaver<MdmDataPermissionImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmDataPermissionImportSavor.class);
    @Resource
    private MdmDataPermissionMapper mdmDataPermissionMapper;
    @Resource
    private MdmDataPermissionExtendMapper mdmDataPermissionExtendMapper;

    @Override
    public void save(List<MdmDataPermissionImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        Set functionSet = data.stream().map(MdmDataPermissionImportVo::getFunctionCode).collect(Collectors.toSet());
        LambdaQueryWrapper dataPermissionWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmDataPermissionEntity::getFunctionCode, functionSet);
        List dataPermissionUniqueKey = Optional.ofNullable(this.mdmDataPermissionMapper.selectList((Wrapper)dataPermissionWrapper)).map(x -> x.stream().map(k -> k.getFunctionCode() + k.getListConfigCode() + k.getRoleCode()).distinct().collect(Collectors.toList())).orElse(new ArrayList());
        LambdaQueryWrapper extendDataPermissionWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmDataPermissionExtendEntity::getFunctionCode, functionSet);
        List extendPermissionUniqueKey = Optional.ofNullable(this.mdmDataPermissionExtendMapper.selectList((Wrapper)extendDataPermissionWrapper)).map(x -> x.stream().map(k -> k.getFunctionCode() + k.getListConfigCode() + k.getRoleCode() + k.getPermissionObjCode() + k.getPermissionResource() + k.getPermissionSearchType()).distinct().collect(Collectors.toList())).orElse(new ArrayList());
        data = data.stream().peek(x -> x.setPermissionResource(PermissionResourceEnum.PRESUPPOSITION.getCode())).collect(Collectors.toList());
        String nowDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        Lists.partition(data, (int)500).parallelStream().forEach(list3 -> {
            List<MdmDataPermissionExtendEntity> extendEntityList;
            List<MdmDataPermissionEntity> mdmDataPermissionEntities = list3.stream().filter(x -> !dataPermissionUniqueKey.contains(x.getFunctionCode() + x.getListConfigCode() + x.getRoleCode())).map(x -> {
                MdmDataPermissionEntity mdmDataPermissionEntity = new MdmDataPermissionEntity();
                mdmDataPermissionEntity.setId(UUID.randomUUID().toString());
                mdmDataPermissionEntity.setFunctionCode(x.getFunctionCode());
                mdmDataPermissionEntity.setListConfigCode(x.getListConfigCode());
                mdmDataPermissionEntity.setRoleCode(x.getRoleCode());
                mdmDataPermissionEntity.setPermissionResource(x.getPermissionResource());
                mdmDataPermissionEntity.setPermissionObjCode(x.getPermissionObjCode());
                mdmDataPermissionEntity.setPermissionSearchType(x.getPermissionSearchType());
                mdmDataPermissionEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                mdmDataPermissionEntity.setCreateDate(nowDate);
                return mdmDataPermissionEntity;
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(mdmDataPermissionEntities)) {
                this.mdmDataPermissionMapper.insertBatch(mdmDataPermissionEntities);
            }
            if (!CollectionUtils.isEmpty(extendEntityList = list3.stream().filter(x -> !extendPermissionUniqueKey.contains(x.getFunctionCode() + x.getListConfigCode() + x.getRoleCode() + x.getPermissionObjCode() + x.getPermissionResource() + x.getPermissionSearchType())).map(x -> {
                MdmDataPermissionExtendEntity mdmDataPermissionExtendEntity = new MdmDataPermissionExtendEntity();
                mdmDataPermissionExtendEntity.setId(UUID.randomUUID().toString());
                mdmDataPermissionExtendEntity.setRoleCode(x.getRoleCode());
                mdmDataPermissionExtendEntity.setFunctionCode(x.getFunctionCode());
                mdmDataPermissionExtendEntity.setListConfigCode(x.getListConfigCode());
                mdmDataPermissionExtendEntity.setPermissionObjCode(x.getPermissionObjCode());
                mdmDataPermissionExtendEntity.setPermissionResource(x.getPermissionResource());
                mdmDataPermissionExtendEntity.setPermissionSearchType(x.getPermissionSearchType());
                mdmDataPermissionExtendEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                mdmDataPermissionExtendEntity.setCreateDate(nowDate);
                return mdmDataPermissionExtendEntity;
            }).collect(Collectors.toList()))) {
                this.mdmDataPermissionMapper.insertExtendBatch(extendEntityList);
            }
        });
    }
}

