/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.terminal;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.ApprovalType;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.terminal.MdmTerminalImportVo;
import com.biz.crm.mdm.kms.MdmKmsFeign;
import com.biz.crm.mdm.terminal.entity.MdmTerminalContactEntity;
import com.biz.crm.mdm.terminal.entity.MdmTerminalEntity;
import com.biz.crm.mdm.terminal.entity.MdmTerminalROrgEntity;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalContactMapper;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.mdm.terminal.mapper.MdmTerminalROrgMapper;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.websocket.WebsocketUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component(value="mdmTerminalImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmTerminalImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmTerminalMapper, MdmTerminalEntity, MdmTerminalImportVo>
implements ExcelImportSaver<MdmTerminalImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalImportSaver.class);
    @Resource
    private MdmTerminalROrgMapper mdmTerminalROrgMapper;
    @Resource
    private MdmTerminalContactMapper mdmTerminalContactMapper;
    @Resource
    private MdmKmsFeign mdmKmsFeign;
    @Autowired
    private WebsocketUtil websocketUtil;
    @Value(value="${kms.url:}")
    private String kms;

    @Override
    public void save(List<MdmTerminalImportVo> data, DefaultImportContext context) {
        log.info("\u7ec8\u7aef\u5bfc\u5165:{}" + data.size());
        String sid = context.getImportParamVo().getWebSocketClientId();
        this.websocketUtil.sendMsg(sid, "\u51c6\u5907\u4fdd\u5b58\u6570\u636e");
        Map channel = DictUtil.dictMap((String)"channel");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : channel.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        Map map = DictUtil.dictMap((String)"terminal_type");
        HashMap terminalTypeMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (terminalTypeMap.containsKey(entry.getValue())) continue;
            terminalTypeMap.put(entry.getValue(), entry.getKey());
        }
        if (!CollectionUtils.isEmpty(data)) {
            long count = (data = data.stream().filter(x -> AbstractImportVo.ProcessTypeEnum.SUCCESS == x.getProcessType()).collect(Collectors.toList())).stream().filter(x -> StringUtils.isEmpty((String)x.getTerminalCode())).count();
            if (count > 0L) {
                List codes = CodeUtil.generateCodeList((String)CodeRuleEnum.MDM_TERMINAL.getCode(), (int)((int)count));
                int i = 0;
                for (MdmTerminalImportVo item : data) {
                    if (!StringUtils.isEmpty((String)item.getTerminalCode())) continue;
                    item.setTerminalCode((String)codes.get(i++));
                }
            }
            List partition = Lists.partition(data, (int)100);
            this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u7ec8\u7aef\u4e0e\u7ec4\u7ec7\u5173\u7cfb");
            for (Object mdmTerminalVos : partition) {
                List<MdmTerminalROrgEntity> mdmTerminalROrgEntities = mdmTerminalVos.stream().filter(x -> !StringUtils.isEmpty((String)x.getOrgCode()) && x.getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS).flatMap(x -> {
                    ArrayList<MdmTerminalROrgEntity> list = new ArrayList<MdmTerminalROrgEntity>();
                    String terminalCode = x.getTerminalCode();
                    for (String orgCode : x.getOrgCode().split(",")) {
                        MdmTerminalROrgEntity mdmTerminalROrgEntity = new MdmTerminalROrgEntity();
                        mdmTerminalROrgEntity.setId(UUID.randomUUID().toString());
                        mdmTerminalROrgEntity.setOrgCode(orgCode);
                        mdmTerminalROrgEntity.setTerminalCode(terminalCode);
                        list.add(mdmTerminalROrgEntity);
                    }
                    return list.stream();
                }).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(mdmTerminalROrgEntities)) continue;
                this.mdmTerminalROrgMapper.insertBatch(mdmTerminalROrgEntities);
            }
            ArrayList<MdmTerminalImportVo> list = new ArrayList<MdmTerminalImportVo>();
            for (MdmTerminalImportVo mdmTerminalImportVo2 : data) {
                if (mdmTerminalImportVo2.getProcessType() != AbstractImportVo.ProcessTypeEnum.SUCCESS) continue;
                mdmTerminalImportVo2.setChannel((String)channelMap.get(mdmTerminalImportVo2.getChannel()));
                mdmTerminalImportVo2.setTerminalType((String)terminalTypeMap.get(mdmTerminalImportVo2.getTerminalType()));
                list.add(mdmTerminalImportVo2);
            }
            if (!CollectionUtils.isEmpty(list)) {
                List entityList = CrmBeanUtil.copyList(list, MdmTerminalEntity.class);
                entityList.forEach(x -> {
                    x.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
                    x.setApprovalType(ApprovalType.NULL.getValue());
                    x.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                });
                if (StringUtils.isNotEmpty((String)this.kms)) {
                    this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58KMS\u76f8\u5173\u4fe1\u606f");
                    this.mdmKmsFeign.addStoreBatch(CrmBeanUtil.copyList(list, MdmTerminalVo.class));
                }
                this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u7ec8\u7aef\u76f8\u5173\u4fe1\u606f");
                this.saveBatch(entityList);
            }
            List mdmTerminalContactEntities = data.stream().filter(x -> (!StringUtils.isEmpty((String)x.getContactName()) || !StringUtils.isEmpty((String)x.getContactPhone())) && x.getProcessType() == AbstractImportVo.ProcessTypeEnum.SUCCESS).map(mdmTerminalImportVo -> {
                MdmTerminalContactEntity mdmTerminalContactEntity = new MdmTerminalContactEntity();
                mdmTerminalContactEntity.setId(UUID.randomUUID().toString());
                mdmTerminalContactEntity.setTerminalCode(mdmTerminalImportVo.getTerminalCode());
                mdmTerminalContactEntity.setContactName(mdmTerminalImportVo.getContactName());
                mdmTerminalContactEntity.setContactPhone(mdmTerminalImportVo.getContactPhone());
                mdmTerminalContactEntity.setContactMain(YesNoEnum.yesNoEnum.ONE.getValue());
                return mdmTerminalContactEntity;
            }).collect(Collectors.toList());
            this.websocketUtil.sendMsg(sid, "\u5f00\u59cb\u4fdd\u5b58\u8054\u7cfb\u4eba\u4fe1\u606f");
            if (!CollectionUtils.isEmpty(mdmTerminalContactEntities)) {
                int total = mdmTerminalContactEntities.size();
                for (int i = 0; i < total; ++i) {
                    if (i % 100 == 0) {
                        this.websocketUtil.sendMsg(sid, "\u4fdd\u5b58\u8054\u7cfb\u4eba\u4fe1\u606f\uff1a\u8fdb\u5ea6\uff1a" + i + "/" + total);
                    }
                    this.mdmTerminalContactMapper.insert(mdmTerminalContactEntities.get(i));
                }
            }
            this.websocketUtil.sendMsg(sid, "\u4fdd\u5b58\u8054\u7cfb\u4eba\u4fe1\u606f\u5b8c\u6210");
        }
    }
}

