/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.kms.totalhouse;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.kms.totalwarehouse.KmsTotalWareHouseStoreImportVo;
import com.biz.crm.kms.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.kms.kaproduct.entity.KmsTenantryDirectProductEntity;
import com.biz.crm.kms.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.kms.tenantrydirectcustomerorg.entity.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.kms.tenantrydirectcustomerorg.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.kms.tenantrydirectstore.entity.KmsTenantryDirectStoreEntity;
import com.biz.crm.kms.tenantrydirectstore.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.kms.totalwarehouse.entity.KmsTotalWarehouseStoreEntity;
import com.biz.crm.kms.totalwarehouse.mapper.KmsTotalWarehouseStoreMapper;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTotalWarehouseStoreReqVo;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="kmsTotalWarehouseStoreValidator")
public class KmsTotalWarehouseStoreValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<KmsTotalWarehouseStoreMapper, KmsTotalWarehouseStoreEntity, KmsTotalWareHouseStoreImportVo>
implements ExcelImportValidator<KmsTotalWareHouseStoreImportVo> {
    private static final Logger log = LoggerFactory.getLogger(KmsTotalWarehouseStoreValidator.class);
    private Set<String> bsCodeSet = Sets.newHashSet();
    private Set<String> bsIdSet = Sets.newHashSet();
    private Set<String> terminalCodeSet = Sets.newHashSet();
    private Set<String> storeAndBsCodeSet = Sets.newHashSet();
    private Set<String> productIds = Sets.newHashSet();
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;
    @Resource
    private KmsTotalWarehouseStoreMapper kmsTotalWarehouseStoreMapper;
    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;
    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;

    @Override
    public void validate(List<KmsTotalWareHouseStoreImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        ConcurrentHashMap map = ThreadLocalUtil.get();
        map.put("functionCode", "warehouse_store_list");
        map.put("menuCode", "CRM20210629000001905");
        ThreadLocalUtil.setUser((UserRedis)UserUtils.getUser());
        this.validateNotEmpty(data);
        this.validateCusOrg(data);
        this.validateDirectStore(data);
        this.validateProduct(data);
        this.convertData(data);
        this.validateByDb(data);
    }

    private void validateProduct(List<KmsTotalWareHouseStoreImportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet kaProductCode = Sets.newHashSet();
        HashSet productCode = Sets.newHashSet();
        data.forEach(x -> {
            if (StringUtils.isNotBlank((CharSequence)x.getProductCode())) {
                productCode.add(x.getProductCode());
            }
        });
        KmsTenantryDirectProductReqVo reqVo = new KmsTenantryDirectProductReqVo();
        reqVo.setProductCodes((List)Lists.newArrayList((Iterable)productCode));
        reqVo.setBsDirectSystemIdList((List)Lists.newArrayList(this.bsIdSet));
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectProductEntity> productEntities = this.kmsTenantryDirectProductMapper.selectListForExcel(reqVo);
        if (CollectionUtils.isEmpty(productEntities)) {
            data.forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getProductCode())) {
                    x.appendErrorValidateMsg("\u3010\u7269\u6599\u4fe1\u606f\u3011\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
                }
            });
        }
        HashMap map = Maps.newHashMap();
        productEntities.forEach(x -> {
            String mapKey = x.getBsDirectSystemId() + x.getProductCode();
            if (map.containsKey(mapKey)) {
                ((List)map.get(mapKey)).add(x);
            } else {
                map.put(mapKey, Lists.newArrayList((Object[])new KmsTenantryDirectProductEntity[]{x}));
            }
        });
        data.forEach(x -> {
            if (StringUtils.isNotBlank((CharSequence)x.getProductCode())) {
                if (!map.containsKey(x.getBsDirectSystemId() + x.getProductCode())) {
                    x.appendErrorValidateMsg("\u3010\u7269\u6599\u4fe1\u606f\u3011\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
                } else {
                    List products = (List)map.get(x.getBsDirectSystemId() + x.getProductCode());
                    x.setKaProductCode(((KmsTenantryDirectProductEntity)((Object)((Object)products.get(0)))).getId());
                    x.setDirectProductId(((KmsTenantryDirectProductEntity)((Object)((Object)products.get(0)))).getId());
                    x.setProductName(((KmsTenantryDirectProductEntity)((Object)((Object)products.get(0)))).getProductName());
                }
            }
        });
    }

    private void validateByDb(List<KmsTotalWareHouseStoreImportVo> data) {
        if (CollectionUtils.isEmpty(this.bsIdSet) || CollectionUtils.isEmpty(this.terminalCodeSet)) {
            return;
        }
        KmsTotalWarehouseStoreReqVo reqVo = new KmsTotalWarehouseStoreReqVo();
        reqVo.setBsDirectSystemIdList((List)Lists.newArrayList(this.bsIdSet));
        reqVo.setTerminalCodeList((List)Lists.newArrayList(this.terminalCodeSet));
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        List<KmsTotalWarehouseStoreEntity> entities = this.kmsTotalWarehouseStoreMapper.selectListWithDataPurview(reqVo);
        if (CollectionUtils.isNotEmpty(entities)) {
            HashMap map = Maps.newHashMap();
            entities.forEach(x -> {
                if (map.containsKey(x.getBsDirectSystemId() + x.getTerminalCode() + x.getProductType())) {
                    ((List)map.get(x.getBsDirectSystemId() + x.getTerminalCode() + x.getProductType())).add(x);
                } else {
                    map.put(x.getBsDirectSystemId() + x.getTerminalCode() + x.getProductType(), Lists.newArrayList((Object[])new KmsTotalWarehouseStoreEntity[]{x}));
                }
            });
            data.forEach(x -> {
                if (map.containsKey(x.getBsDirectSystemId() + x.getTerminalCode() + x.getProductType())) {
                    List entityList = (List)map.get(x.getBsDirectSystemId() + x.getTerminalCode() + x.getProductType());
                    if (CollectionUtils.isEmpty((Collection)entityList)) {
                        return;
                    }
                    if (StringUtils.isBlank((CharSequence)((KmsTotalWarehouseStoreEntity)((Object)((Object)entityList.get(0)))).getProductCode())) {
                        x.appendErrorValidateMsg("\u3010\u8be5\u884c\u6570\u636e\u5df2\u5b58\u5728\u3011");
                        return;
                    }
                    Set productCodeSet = entityList.stream().map(KmsTotalWarehouseStoreEntity::getProductCode).collect(Collectors.toSet());
                    if (StringUtils.isBlank((CharSequence)x.getProductCode())) {
                        x.appendErrorValidateMsg("\u3010\u8be5\u884c\u6570\u636e\u5df2\u5b58\u5728\u3011");
                    }
                    if (StringUtils.isNotBlank((CharSequence)x.getProductCode()) && productCodeSet.contains(x.getProductCode())) {
                        x.appendErrorValidateMsg("\u3010\u8be5\u884c\u6570\u636e\u5df2\u5b58\u5728\u3011");
                    }
                }
            });
        }
    }

    private void validateNotEmpty(List<KmsTotalWareHouseStoreImportVo> data) {
        HashMap storeAndBsMap = Maps.newHashMap();
        HashMap storeAndBsMapWithoutProduct = Maps.newHashMap();
        HashMap map = Maps.newHashMap();
        AtomicReference<Integer> rowNumber = new AtomicReference<Integer>();
        rowNumber.set(2);
        data.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getBsDirectSystemCode())) {
                x.appendErrorValidateMsg("\u7b2c" + rowNumber.get() + "\u884c\u7684\u3010\u76f4\u8425\u4f53\u7cfb\u672a\u586b\u5199\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getTerminalCode())) {
                x.appendErrorValidateMsg("\u7b2c" + rowNumber.get() + "\u884c\u7684\u3010\u9001\u8fbe\u65b9\u4fe1\u606f\u672a\u586b\u5199\u3011\u3001");
            }
            if (StringUtils.isBlank((CharSequence)x.getProductTypeDesc())) {
                x.appendErrorValidateMsg("\u7b2c" + rowNumber.get() + "\u884c\u7684\u3010\u4ea7\u54c1\u7c7b\u578b\u672a\u586b\u5199\u3011\u3001");
            }
            x.setProductType(x.getProductTypeDesc());
            if (StringUtils.isNotBlank((CharSequence)x.getTerminalCode()) || StringUtils.isNotBlank((CharSequence)x.getBsDirectSystemCode()) || StringUtils.isNotBlank((CharSequence)x.getProductTypeDesc())) {
                this.bsCodeSet.add(x.getBsDirectSystemCode());
                this.terminalCodeSet.add(x.getTerminalCode());
                this.storeAndBsCodeSet.add(x.getBsDirectSystemCode() + x.getTerminalCode());
                if (StringUtils.isBlank((CharSequence)x.getProductCode())) {
                    if (storeAndBsMapWithoutProduct.containsKey(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType())) {
                        x.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb\u548c\u9001\u8fbe\u65b9\u4fe1\u606f\u3011\u4e0e" + ((Integer)storeAndBsMapWithoutProduct.get(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType())).toString() + "\u884c\u91cd\u590d\u3001");
                    } else if (map.containsKey(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType())) {
                        x.appendErrorValidateMsg("\u3010\u7b2c" + ((List)map.get(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType())).toString() + "\u884c\u5df2\u7ecf\u7ef4\u62a4\u4e2a\u522b\u7269\u6599\u7684\u5927\u4ed3\u3011\u3001");
                    } else {
                        storeAndBsMapWithoutProduct.put(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType(), rowNumber.get());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)x.getProductCode())) {
                    if (storeAndBsMap.containsKey(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductCode() + x.getProductType())) {
                        x.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb\u548c\u9001\u8fbe\u65b9\u4fe1\u606f\u3011\u4e0e" + ((Integer)storeAndBsMap.get(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductCode() + x.getProductType())).toString() + "\u884c\u91cd\u590d\u3001");
                    } else if (storeAndBsMapWithoutProduct.containsKey(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType())) {
                        x.appendErrorValidateMsg("\u3010\u7b2c" + storeAndBsMapWithoutProduct.get(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType()) + "\u884c\u5df2\u7ecf\u7ef4\u62a4\u5168\u90e8\u7269\u6599\u7684\u5927\u4ed3\u3011\u3001");
                    } else {
                        storeAndBsMap.put(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductCode() + x.getProductType(), rowNumber.get());
                        if (map.containsKey(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType())) {
                            ((List)map.get(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType())).add(rowNumber.get());
                        } else {
                            ArrayList list = Lists.newArrayList((Object[])new Integer[]{(Integer)rowNumber.get()});
                            map.put(x.getBsDirectSystemCode() + x.getTerminalCode() + x.getProductType(), list);
                        }
                    }
                }
            }
            rowNumber.getAndSet((Integer)rowNumber.get() + 1);
        });
    }

    private void validateCusOrg(List<KmsTotalWareHouseStoreImportVo> data) {
        if (CollectionUtils.isEmpty(this.bsCodeSet)) {
            data.forEach(x -> x.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb" + x.getBsDirectSystemCode() + "\u3011\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001"));
        }
        KmsTenantryDirectCustomerOrgReqVo reqVo = new KmsTenantryDirectCustomerOrgReqVo();
        reqVo.setBsDirectSystemCodeList((Collection)Lists.newArrayList(this.bsCodeSet));
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectCustomerOrgEntity> customerOrgEntities = this.kmsTenantryDirectCustomerOrgMapper.selectListForExcel(reqVo);
        if (CollectionUtils.isEmpty(customerOrgEntities)) {
            data.forEach(x -> x.appendErrorValidateMsg("\u3010\u76f4\u8425\u4f53\u7cfb" + x.getBsDirectSystemCode() + "\u3011\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001"));
            return;
        }
        Map map = customerOrgEntities.stream().collect(Collectors.toMap(KmsTenantryDirectCustomerOrgEntity::getBsDirectSystemCode, Function.identity()));
        data.forEach(x -> {
            if (map.containsKey(x.getBsDirectSystemCode())) {
                x.setBsDirectSystemId(((KmsTenantryDirectCustomerOrgEntity)((Object)((Object)map.get(x.getBsDirectSystemCode())))).getBsDirectSystemId());
                x.setBsDirectSystemName(((KmsTenantryDirectCustomerOrgEntity)((Object)((Object)map.get(x.getBsDirectSystemCode())))).getBsDirectSystemName());
                x.setDirectId(((KmsTenantryDirectCustomerOrgEntity)((Object)((Object)map.get(x.getBsDirectSystemCode())))).getDirectId());
                this.bsIdSet.add(x.getBsDirectSystemId());
            } else {
                x.appendErrorValidateMsg("\u76f4\u8425\u4f53\u7cfb\u3010" + x.getBsDirectSystemCode() + "\u3011\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
            }
        });
    }

    private void validateDirectStore(List<KmsTotalWareHouseStoreImportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        KmsTenantryDirectStoreReqVo reqVo = new KmsTenantryDirectStoreReqVo();
        reqVo.setTerminalCodes((List)Lists.newArrayList(this.terminalCodeSet));
        reqVo.setBsDirectSystemIdList((List)Lists.newArrayList(this.bsIdSet));
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectStoreEntity> entities = this.kmsTenantryDirectStoreMapper.selectListByCompetence(reqVo);
        if (CollectionUtils.isEmpty(entities)) {
            data.forEach(x -> x.appendErrorValidateMsg("\u3010\u9001\u8fbe\u65b9" + x.getTerminalCode() + "\u3011\u4e0d\u5728\u7ef4\u62a4\u4e2d"));
            return;
        }
        HashMap map = Maps.newHashMap();
        entities.forEach(x -> {
            if (map.containsKey(x.getBsDirectSystemId() + x.getTerminalCode())) {
                ((List)map.get(x.getBsDirectSystemId() + x.getTerminalCode())).add(x);
            } else {
                map.put(x.getBsDirectSystemId() + x.getTerminalCode(), Lists.newArrayList((Object[])new KmsTenantryDirectStoreEntity[]{x}));
            }
        });
        data.forEach(x -> {
            if (map.containsKey(x.getBsDirectSystemId() + x.getTerminalCode())) {
                List entityList = (List)map.get(x.getBsDirectSystemId() + x.getTerminalCode());
                x.setDirectStoreId(((KmsTenantryDirectStoreEntity)((Object)((Object)entityList.get(0)))).getId());
                x.setTerminalName(((KmsTenantryDirectStoreEntity)((Object)((Object)entityList.get(0)))).getTerminalName());
            } else {
                x.appendErrorValidateMsg("\u9001\u8fbe\u65b9\u3010" + x.getTerminalCode() + "\u3011\u4e0d\u5728\u7ef4\u62a4\u4e2d\u3001");
            }
        });
    }

    private void convertData(List<KmsTotalWareHouseStoreImportVo> data) {
    }
}

