/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.config.OperatorInterceptor;
import com.biz.crm.data.KmsDruidParam;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(value={"com.biz.crm.kms.**.mapper*"}, sqlSessionTemplateRef="kmsSqlSessionTemplate")
public class KmsDruidConfig {
    private static final Logger log = LoggerFactory.getLogger(KmsDruidConfig.class);
    @Resource
    private KmsDruidParam kmsDruidParam;

    @Bean(value={"kmsDataSource"})
    public DataSource kmsDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.kmsDruidParam.getDbUrl());
        datasource.setUsername(this.kmsDruidParam.getUsername());
        datasource.setPassword(this.kmsDruidParam.getPassword());
        datasource.setDriverClassName(this.kmsDruidParam.getDriverClassName());
        datasource.setInitialSize(this.kmsDruidParam.getInitialSize());
        datasource.setMinIdle(this.kmsDruidParam.getMinIdle());
        datasource.setMaxActive(this.kmsDruidParam.getMaxActive());
        datasource.setMaxWait((long)this.kmsDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis((long)this.kmsDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis((long)this.kmsDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis((long)this.kmsDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(this.kmsDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(this.kmsDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(this.kmsDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(this.kmsDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(this.kmsDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(this.kmsDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(this.kmsDruidParam.getFilters());
        }
        catch (Exception e) {
            log.error("druid configuration initialization filter", (Throwable)e);
        }
        datasource.setConnectionProperties(this.kmsDruidParam.getConnectionProperties());
        return datasource;
    }

    @Bean
    public SqlSessionFactory kmsSqlSessionFactory() throws Exception {
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(this.kmsDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/kms/**/*.xml"));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new OperatorInterceptor());
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }

    @Bean(name={"kmsTransactionManager"})
    @Primary
    public DataSourceTransactionManager mdmTransactionManager() {
        return new DataSourceTransactionManager(this.kmsDataSource());
    }

    @Primary
    @Bean(name={"kmsSqlSessionTemplate"})
    public SqlSessionTemplate mdmSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(this.kmsSqlSessionFactory());
    }
}

